/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.neo4j.cypher.CypherException;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.server.database.CypherExecutor;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.CypherResultRepresentation;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;

@Path(value="/cypher")
public class CypherService {
    private static final String PARAMS_KEY = "params";
    private static final String QUERY_KEY = "query";
    private static final String INCLUDE_STATS_PARAM = "includeStats";
    private static final String INCLUDE_PLAN_PARAM = "includePlan";
    private static final String PROFILE_PARAM = "profile";
    private CypherExecutor cypherExecutor;
    private OutputFormat output;
    private InputFormat input;

    public CypherService(@Context CypherExecutor cypherExecutor, @Context InputFormat input, @Context OutputFormat output) {
        this.cypherExecutor = cypherExecutor;
        this.input = input;
        this.output = output;
    }

    public OutputFormat getOutputFormat() {
        return this.output;
    }

    @POST
    public Response cypher(String body, @QueryParam(value="includeStats") boolean includeStats, @QueryParam(value="includePlan") boolean includePlan, @QueryParam(value="profile") boolean profile) throws BadInputException {
        Map command = this.input.readMap(body, new String[0]);
        if (!command.containsKey(QUERY_KEY)) {
            return this.output.badRequest(new BadInputException("You have to provide the 'query' parameter."));
        }
        String query = (String)command.get(QUERY_KEY);
        Map params = null;
        try {
            params = (Map)(command.containsKey(PARAMS_KEY) && command.get(PARAMS_KEY) != null ? command.get(PARAMS_KEY) : new HashMap());
        }
        catch (ClassCastException e) {
            return this.output.badRequest(new IllegalArgumentException("Parameters must be a JSON map"));
        }
        try {
            if (profile) {
                ExecutionResult result = this.cypherExecutor.getExecutionEngine().profile(query, params);
                return this.output.ok((Representation)new CypherResultRepresentation(result, includeStats, true));
            }
            ExecutionResult result = this.cypherExecutor.getExecutionEngine().execute(query, params);
            return this.output.ok((Representation)new CypherResultRepresentation(result, includeStats, includePlan));
        }
        catch (Throwable e) {
            if (e.getCause() instanceof CypherException) {
                return this.output.badRequest(e.getCause());
            }
            return this.output.badRequest(e);
        }
    }
}

