/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest.representations;

import java.util.ArrayList;
import javax.management.openmbean.CompositeData;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.ObjectRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationDispatcher;
import org.neo4j.server.rest.repr.ValueRepresentation;
import org.neo4j.server.webadmin.rest.representations.JmxAttributeRepresentationDispatcher;
import org.neo4j.server.webadmin.rest.representations.NameDescriptionValueRepresentation;

public class JmxCompositeDataRepresentation
extends ObjectRepresentation {
    protected CompositeData data;
    private static final RepresentationDispatcher REPRESENTATION_DISPATCHER = new JmxAttributeRepresentationDispatcher();

    public JmxCompositeDataRepresentation(CompositeData data) {
        super("jmxCompositeData");
        this.data = data;
    }

    @ObjectRepresentation.Mapping(value="type")
    public ValueRepresentation getType() {
        return ValueRepresentation.string((String)this.data.getCompositeType().getTypeName());
    }

    @ObjectRepresentation.Mapping(value="description")
    public ValueRepresentation getDescription() {
        return ValueRepresentation.string((String)this.data.getCompositeType().getDescription());
    }

    @ObjectRepresentation.Mapping(value="value")
    public ListRepresentation getValue() {
        ArrayList<NameDescriptionValueRepresentation> values = new ArrayList<NameDescriptionValueRepresentation>();
        for (String key : this.data.getCompositeType().keySet()) {
            String name = key.toString();
            String description = this.data.getCompositeType().getDescription(name);
            Representation value = (Representation)REPRESENTATION_DISPATCHER.dispatch(this.data.get(name), "");
            values.add(new NameDescriptionValueRepresentation(name, description, value));
        }
        return new ListRepresentation("value", values);
    }
}

