/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.ServerHelper;
import org.neo4j.server.logging.InMemoryAppender;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class NeoServerShutdownLoggingDocIT
extends ExclusiveServerTestBase {
    private NeoServer server;

    @Before
    public void setupServer() throws IOException {
        this.server = ServerHelper.createPersistentServer(this.folder.getRoot());
        ServerHelper.cleanTheDatabase(this.server);
    }

    @After
    public void shutdownTheServer() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void shouldLogShutdown() throws Exception {
        InMemoryAppender appender = new InMemoryAppender(AbstractNeoServer.log);
        this.server.stop();
        String actual = appender.toString();
        Assert.assertTrue((actual.contains("INFO: Successfully shutdown database.") || actual.contains("Information: Successfully shutdown database.") ? 1 : 0) != 0);
    }
}

