/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.neo4j.cypher.internal.compiler.v2_0.prettifier.Prettifier$;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.Pair;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.web.PropertyValueException;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.GraphHolder;
import org.neo4j.test.TestData;
import org.neo4j.test.server.SharedServerTestBase;
import org.neo4j.visualization.asciidoc.AsciidocHelper;

public class AbstractRestFunctionalTestBase
extends SharedServerTestBase
implements GraphHolder {
    protected static final String NODES = "http://localhost:7474/db/data/node/";
    @Rule
    public TestData<Map<String, Node>> data = TestData.producedThrough((TestData.Producer)GraphDescription.createGraphFor((GraphHolder)this, (boolean)true));
    @Rule
    public TestData<RESTDocsGenerator> gen = TestData.producedThrough(RESTDocsGenerator.PRODUCER);

    @Before
    public void setUp() {
        this.gen().setSection(this.getDocumentationSectionName());
    }

    @Before
    public void cleanContent() {
        this.cleanDatabase();
        this.gen().setGraph(this.graphdb());
    }

    @SafeVarargs
    public final String doCypherRestCall(String endpoint, String scriptTemplate, Response.Status status, Pair<String, String> ... params) {
        String parameterString = this.createParameterString(params);
        return this.doCypherRestCall(endpoint, scriptTemplate, status, parameterString);
    }

    public String doCypherRestCall(String endpoint, String scriptTemplate, Response.Status status, String parameterString) {
        this.data.get();
        String script = this.createScript(scriptTemplate);
        String queryString = "{\"query\": \"" + script + "\",\"params\":{" + parameterString + "}}";
        String snippet = Prettifier$.MODULE$.apply(script);
        this.gen().expectedStatus(status.getStatusCode()).payload(queryString).description(AsciidocHelper.createAsciiDocSnippet((String)"cypher", (String)snippet));
        return this.gen().post(endpoint).entity();
    }

    protected String formatJavaScript(String script) {
        if (!(script = script.replace(";", "\n")).endsWith("\n")) {
            script = script + "\n";
        }
        return "_Raw script source_\n\n[source, javascript]\n----\n" + script + "----\n";
    }

    private Long idFor(String name) {
        return ((Node)((Map)this.data.get()).get(name)).getId();
    }

    private String createParameterString(Pair<String, String>[] params) {
        String paramString = "";
        for (Pair<String, String> param : params) {
            String delimiter = paramString.isEmpty() || paramString.endsWith("{") ? "" : ",";
            paramString = paramString + delimiter + "\"" + (String)param.first() + "\":\"" + (String)param.other() + "\"";
        }
        return paramString;
    }

    protected String createScript(String template) {
        for (String key : ((Map)this.data.get()).keySet()) {
            template = template.replace("%" + key + "%", this.idFor(key).toString());
        }
        return template;
    }

    protected String startGraph(String name) {
        return AsciidocHelper.createGraphVizWithNodeId((String)"Starting Graph", (GraphDatabaseService)this.graphdb(), (String)name);
    }

    public GraphDatabaseService graphdb() {
        return AbstractRestFunctionalTestBase.server().getDatabase().getGraph();
    }

    protected String getDataUri() {
        return "http://localhost:7474/db/data/";
    }

    protected String getDatabaseUri() {
        return "http://localhost:7474/db/";
    }

    protected String getNodeUri(Node node) {
        return this.getNodeUri(node.getId());
    }

    protected String getNodeUri(long node) {
        return this.getDataUri() + "node/" + node;
    }

    protected String getRelationshipUri(Relationship node) {
        return this.getDataUri() + "relationship/" + node.getId();
    }

    protected String getNodeIndexUri(String indexName, String key, String value) {
        return this.postNodeIndexUri(indexName) + "/" + key + "/" + value;
    }

    protected String postNodeIndexUri(String indexName) {
        return this.getDataUri() + "index/node/" + indexName;
    }

    protected String postRelationshipIndexUri(String indexName) {
        return this.getDataUri() + "index/relationship/" + indexName;
    }

    protected String getRelationshipIndexUri(String indexName, String key, String value) {
        return this.getDataUri() + "index/relationship/" + indexName + "/" + key + "/" + value;
    }

    protected Node getNode(String name) {
        return (Node)((Map)this.data.get()).get(name);
    }

    protected Node[] getNodes(String ... names) {
        Node[] nodes = new Node[]{};
        ArrayList<Node> result = new ArrayList<Node>();
        for (String name : names) {
            result.add(this.getNode(name));
        }
        return result.toArray(nodes);
    }

    public void assertSize(int expectedSize, String entity) {
        try {
            Collection hits = (Collection)JsonHelper.jsonToSingleValue((String)entity);
            Assert.assertEquals((long)expectedSize, (long)hits.size());
        }
        catch (PropertyValueException e) {
            throw new RuntimeException(e);
        }
    }

    public String getPropertiesUri(Relationship rel) {
        return this.getRelationshipUri(rel) + "/properties";
    }

    public String getPropertiesUri(Node node) {
        return this.getNodeUri(node) + "/properties";
    }

    public RESTDocsGenerator gen() {
        return (RESTDocsGenerator)((Object)this.gen.get());
    }

    public void description(String description) {
        this.gen().description(description);
    }

    protected String getDocumentationSectionName() {
        return "dev/rest-api";
    }

    public String getLabelsUri() {
        return String.format("%slabels", this.getDataUri());
    }

    public String getPropertyKeysUri() {
        return String.format("%spropertykeys", this.getDataUri());
    }

    public String getNodesWithLabelUri(String label) {
        return String.format("%slabel/%s/nodes", this.getDataUri(), label);
    }

    public String getNodesWithLabelAndPropertyUri(String label, String property, Object value) throws UnsupportedEncodingException {
        return String.format("%slabel/%s/nodes?%s=%s", this.getDataUri(), label, property, URLEncoder.encode(JsonHelper.createJsonFrom((Object)value), "UTF-8"));
    }

    public String getSchemaIndexLabelUri(String label) {
        return this.getDataUri() + "schema/index/" + label;
    }

    public String getSchemaIndexLabelPropertyUri(String label, String property) {
        return this.getDataUri() + "schema/index/" + label + "/" + property;
    }

    public String getSchemaConstraintUri() {
        return this.getDataUri() + "schema/constraint/";
    }

    public String getSchemaConstraintLabelUri(String label) {
        return this.getDataUri() + "schema/constraint/" + label;
    }

    public String getSchemaConstraintLabelUniquenessUri(String label) {
        return this.getDataUri() + "schema/constraint/" + label + "/uniqueness/";
    }

    public String getSchemaConstraintLabelUniquenessPropertyUri(String label, String property) {
        return this.getDataUri() + "schema/constraint/" + label + "/uniqueness/" + property;
    }
}

