/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional.integration;

import java.text.ParseException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.jackson.JsonNode;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.repr.util.RFC1123;
import org.neo4j.server.rest.transactional.error.Status;
import org.neo4j.test.server.HTTP;
import org.neo4j.tooling.GlobalGraphOperations;

public class TransactionMatchers {
    static Matcher<String> isValidRFCTimestamp() {
        return new TypeSafeMatcher<String>(){

            protected boolean matchesSafely(String item) {
                try {
                    return RFC1123.parseTimestamp((String)item).getTime() > 0L;
                }
                catch (ParseException e) {
                    return false;
                }
            }

            public void describeTo(Description description) {
                description.appendText("valid RFC1134 timestamp");
            }
        };
    }

    static Matcher<String> matches(final String pattern) {
        final Pattern regex = Pattern.compile(pattern);
        return new TypeSafeMatcher<String>(){

            protected boolean matchesSafely(String item) {
                return regex.matcher(item).matches();
            }

            public void describeTo(Description description) {
                description.appendText("matching regex: ").appendValue((Object)pattern);
            }
        };
    }

    public static Matcher<? super HTTP.Response> containsNoErrors() {
        return TransactionMatchers.hasErrors(new Status[0]);
    }

    public static Matcher<? super HTTP.Response> hasErrors(final Status ... expectedErrors) {
        return new TypeSafeMatcher<HTTP.Response>(){

            protected boolean matchesSafely(HTTP.Response response) {
                try {
                    Iterator errors = response.get("errors").iterator();
                    Iterator expected = IteratorUtil.iterator((Object[])expectedErrors);
                    while (expected.hasNext()) {
                        Assert.assertTrue((boolean)errors.hasNext());
                        MatcherAssert.assertThat((Object)((JsonNode)errors.next()).get("code").asText(), (Matcher)CoreMatchers.equalTo((Object)((Status)expected.next()).code().getCode()));
                    }
                    if (errors.hasNext()) {
                        JsonNode error = (JsonNode)errors.next();
                        Assert.fail((String)("Expected no more errors, but got " + error.get("code") + " - '" + error.get("message") + "'."));
                    }
                    return true;
                }
                catch (JsonParseException e) {
                    return false;
                }
            }

            public void describeTo(Description description) {
            }
        };
    }

    public static long countNodes(GraphDatabaseService graphdb) {
        try (Transaction ignore = graphdb.beginTx();){
            long count = 0L;
            Iterator allNodes = GlobalGraphOperations.at((GraphDatabaseService)graphdb).getAllNodes().iterator();
            while (allNodes.hasNext()) {
                allNodes.next();
                ++count;
            }
            long l = count;
            return l;
        }
    }

    public static Matcher<? super HTTP.Response> containsNoStackTraces() {
        return new TypeSafeMatcher<HTTP.Response>(){

            protected boolean matchesSafely(HTTP.Response response) {
                Map content = (Map)response.content();
                List errors = (List)content.get("errors");
                for (Map error : errors) {
                    if (!error.containsKey("stackTrace")) continue;
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("contains stack traces");
            }
        };
    }
}

