/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional.integration;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.transactional.error.Status;
import org.neo4j.server.rest.transactional.integration.TransactionMatchers;
import org.neo4j.test.server.HTTP;

public class TransactionErrorIT
extends AbstractRestFunctionalTestBase {
    @Test
    public void begin__commit_with_invalid_cypher() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response response = HTTP.POST(this.txUri(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE n' } ] }"));
        String commitResource = response.stringFromContent("commit");
        response = HTTP.POST(commitResource, HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE ;;' } ] }"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, TransactionMatchers.hasErrors(new Status[]{Status.Statement.InvalidSyntax}));
        MatcherAssert.assertThat((Object)response, TransactionMatchers.containsNoStackTraces());
        MatcherAssert.assertThat((Object)this.countNodes(), (Matcher)CoreMatchers.equalTo((Object)nodesInDatabaseBeforeTransaction));
    }

    @Test
    public void begin__commit_with_malformed_json() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response begin = HTTP.POST(this.txUri(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE n' } ] }"));
        String commitResource = begin.stringFromContent("commit");
        HTTP.Response response = HTTP.POST(commitResource, HTTP.RawPayload.rawPayload("[{asd,::}]"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, TransactionMatchers.hasErrors(new Status[]{Status.Request.InvalidFormat}));
        MatcherAssert.assertThat((Object)this.countNodes(), (Matcher)CoreMatchers.equalTo((Object)nodesInDatabaseBeforeTransaction));
    }

    private String txUri() {
        return this.getDataUri() + "transaction";
    }

    private long countNodes() {
        return TransactionMatchers.countNodes(this.graphdb());
    }
}

