/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.logging.InMemoryAppender;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class NeoServerPortConflictDocIT
extends ExclusiveServerTestBase {
    @Test
    public void shouldComplainIfServerPortIsAlreadyTaken() throws IOException {
        int contestedPort = 9999;
        try (ServerSocket ignored = new ServerSocket(contestedPort, 0, InetAddress.getByName("0.0.0.0"));){
            InMemoryAppender appender = new InMemoryAppender(AbstractNeoServer.log);
            CommunityNeoServer server = CommunityServerBuilder.server().onPort(contestedPort).usingDatabaseDir(this.folder.getRoot().getAbsolutePath()).onHost("0.0.0.0").build();
            try {
                server.start();
                Assert.fail((String)"Should have reported failure to start");
            }
            catch (ServerStartupException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Starting Neo4j Server failed"));
            }
            Assert.assertThat((Object)appender.toString(), (Matcher)Matchers.containsString((String)String.format(": Failed to start Neo Server", new Object[0])));
            server.stop();
        }
    }
}

