/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import org.junit.Assert;
import org.neo4j.server.rest.repr.RepresentationTestAccess;
import org.neo4j.server.rest.repr.ValueRepresentation;

class RepresentationTestBase {
    static final URI BASE_URI = URI.create("http://neo4j.org/");
    static final String NODE_URI_PATTERN = "http://.*/node/[0-9]+";
    static final String RELATIONSHIP_URI_PATTERN = "http://.*/relationship/[0-9]+";

    static void assertUriMatches(String expectedRegex, ValueRepresentation uriRepr) {
        RepresentationTestBase.assertUriMatches(expectedRegex, RepresentationTestAccess.serialize(uriRepr));
    }

    static void assertUriMatches(String expectedRegex, URI actualUri) {
        RepresentationTestBase.assertUriMatches(expectedRegex, actualUri.toString());
    }

    static void assertUriMatches(String expectedRegex, String actualUri) {
        Assert.assertTrue((String)("expected <" + expectedRegex + "> got <" + actualUri + ">"), (boolean)actualUri.matches(expectedRegex));
    }

    static String uriPattern(String subPath) {
        return "http://.*/[0-9]+" + subPath;
    }

    private RepresentationTestBase() {
    }
}

