/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.server;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.JsonNode;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;

public class HTTP {
    private static final Builder BUILDER = new Builder().withHeaders("Accept", "application/json");
    private static final Client CLIENT = new Client();

    public static Builder withHeaders(Map<String, String> headers) {
        return BUILDER.withHeaders(headers);
    }

    public static Builder withHeaders(String ... kvPairs) {
        return BUILDER.withHeaders(kvPairs);
    }

    public static Builder withBaseUri(String baseUri) {
        return BUILDER.withBaseUri(baseUri);
    }

    public static Response POST(String uri) {
        return BUILDER.POST(uri);
    }

    public static Response POST(String uri, Object payload) {
        return BUILDER.POST(uri, payload);
    }

    public static Response POST(String uri, RawPayload payload) {
        return BUILDER.POST(uri, payload);
    }

    public static Response PUT(String uri) {
        return BUILDER.PUT(uri);
    }

    public static Response PUT(String uri, Object payload) {
        return BUILDER.PUT(uri, payload);
    }

    public static Response PUT(String uri, RawPayload payload) {
        return BUILDER.PUT(uri, payload);
    }

    public static Response DELETE(String uri) {
        return BUILDER.DELETE(uri);
    }

    public static Response GET(String uri) {
        return BUILDER.GET(uri);
    }

    public static class RawPayload {
        private final String payload;

        public static RawPayload rawPayload(String payload) {
            return new RawPayload(payload);
        }

        public static RawPayload quotedJson(String json) {
            return new RawPayload(json.replaceAll("'", "\""));
        }

        private RawPayload(String payload) {
            this.payload = payload;
        }

        public String get() {
            return this.payload;
        }
    }

    public static class Response {
        private final ClientResponse response;
        private final String entity;

        public Response(ClientResponse response) {
            this.response = response;
            this.entity = (String)response.getEntity(String.class);
        }

        public int status() {
            return this.response.getStatus();
        }

        public String location() {
            if (this.response.getLocation() != null) {
                return this.response.getLocation().toString();
            }
            throw new RuntimeException("The request did not contain a location header, unable to provide location. Status code was: " + this.status());
        }

        public <T> T content() {
            try {
                return (T)JsonHelper.readJson((String)this.entity);
            }
            catch (JsonParseException e) {
                throw new RuntimeException("Unable to deserialize: " + this.entity, e);
            }
        }

        public String rawContent() {
            return this.entity;
        }

        public String stringFromContent(String key) throws JsonParseException {
            return this.get(key).asText();
        }

        public JsonNode get(String fieldName) throws JsonParseException {
            return JsonHelper.jsonNode((String)this.entity).get(fieldName);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("HTTP ").append(this.response.getStatus()).append("\n");
            for (Map.Entry header : this.response.getHeaders().entrySet()) {
                for (String headerEntry : (List)header.getValue()) {
                    sb.append((String)header.getKey() + ": ").append(headerEntry).append("\n");
                }
            }
            sb.append("\n");
            sb.append(this.entity).append("\n");
            return sb.toString();
        }
    }

    public static class Builder {
        private final Map<String, String> headers;
        private final String baseUri;

        private Builder() {
            this(Collections.emptyMap(), "");
        }

        private Builder(Map<String, String> headers, String baseUri) {
            this.baseUri = baseUri;
            this.headers = Collections.unmodifiableMap(headers);
        }

        public Builder withHeaders(String ... kvPairs) {
            return this.withHeaders(MapUtil.stringMap((String[])kvPairs));
        }

        public Builder withHeaders(Map<String, String> newHeaders) {
            HashMap<String, String> combined = new HashMap<String, String>();
            combined.putAll(newHeaders);
            combined.putAll(this.headers);
            return new Builder(combined, this.baseUri);
        }

        public Builder withBaseUri(String baseUri) {
            return new Builder(this.headers, baseUri);
        }

        public Response POST(String uri) {
            return this.exec("POST", uri);
        }

        public Response POST(String uri, Object payload) {
            return this.exec("POST", uri, payload);
        }

        public Response POST(String uri, RawPayload payload) {
            return this.exec("POST", uri, payload);
        }

        public Response PUT(String uri) {
            return this.exec("PUT", uri);
        }

        public Response PUT(String uri, Object payload) {
            return this.exec("PUT", uri, payload);
        }

        public Response PUT(String uri, RawPayload payload) {
            return this.exec("PUT", uri, payload);
        }

        public Response DELETE(String uri) {
            return this.exec("DELETE", uri);
        }

        public Response GET(String uri) {
            return this.exec("GET", uri);
        }

        public Response exec(String method, String uri) {
            return new Response(CLIENT.handle(this.build().build(this.buildUri(uri), method)));
        }

        public Response exec(String method, String uri, Object payload) {
            String jsonPayload = payload instanceof RawPayload ? ((RawPayload)payload).get() : JsonHelper.createJsonFrom((Object)payload);
            ClientRequest.Builder lastBuilder = (ClientRequest.Builder)this.build().entity((Object)jsonPayload, MediaType.APPLICATION_JSON_TYPE);
            return new Response(CLIENT.handle(lastBuilder.build(this.buildUri(uri), method)));
        }

        private URI buildUri(String uri) {
            URI unprefixedUri = URI.create(uri);
            if (unprefixedUri.isAbsolute()) {
                return unprefixedUri;
            }
            return URI.create(this.baseUri + uri);
        }

        private ClientRequest.Builder build() {
            ClientRequest.Builder builder = ClientRequest.create();
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                builder = (ClientRequest.Builder)builder.header(header.getKey(), (Object)header.getValue());
            }
            return builder;
        }
    }
}

