/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.FakeClock;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.impl.util.TestLogger;
import org.neo4j.server.rest.transactional.TransactionHandle;
import org.neo4j.server.rest.transactional.TransactionHandleRegistry;
import org.neo4j.server.rest.transactional.error.InvalidConcurrentTransactionAccess;
import org.neo4j.server.rest.transactional.error.InvalidTransactionId;

public class TransactionHandleRegistryTest {
    @Test
    public void shouldGenerateTransactionId() throws Exception {
        TestLogger log = new TestLogger();
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)new FakeClock(), 0L, (StringLogger)log);
        long id1 = registry.begin();
        long id2 = registry.begin();
        Assert.assertNotEquals((long)id1, (long)id2);
        log.assertNoLoggingOccurred();
    }

    @Test
    public void shouldStoreSuspendedTransaction() throws Exception {
        TestLogger log = new TestLogger();
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)new FakeClock(), 0L, (StringLogger)log);
        TransactionHandle handle = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        long id = registry.begin();
        registry.release(id, handle);
        TransactionHandle acquiredHandle = registry.acquire(id);
        Assert.assertSame((Object)handle, (Object)acquiredHandle);
        log.assertNoLoggingOccurred();
    }

    @Test
    public void acquiringATransactionThatHasAlreadyBeenAcquiredShouldThrowInvalidConcurrentTransactionAccess() throws Exception {
        TestLogger log = new TestLogger();
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)new FakeClock(), 0L, (StringLogger)log);
        TransactionHandle handle = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        long id = registry.begin();
        registry.release(id, handle);
        registry.acquire(id);
        try {
            registry.acquire(id);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (InvalidConcurrentTransactionAccess e) {
            // empty catch block
        }
        log.assertNoLoggingOccurred();
    }

    @Test
    public void acquiringANonExistentTransactionShouldThrowErrorInvalidTransactionId() throws Exception {
        TestLogger log = new TestLogger();
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)new FakeClock(), 0L, (StringLogger)log);
        long madeUpTransactionId = 1337L;
        try {
            registry.acquire(madeUpTransactionId);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (InvalidTransactionId e) {
            // empty catch block
        }
        log.assertNoLoggingOccurred();
    }

    @Test
    public void transactionsShouldBeEvictedWhenUnusedLongerThanTimeout() throws Exception {
        FakeClock clock = new FakeClock();
        TestLogger log = new TestLogger();
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)clock, 0L, (StringLogger)log);
        TransactionHandle oldTx = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        TransactionHandle newTx = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        long txId1 = registry.begin();
        long txId2 = registry.begin();
        registry.release(txId1, oldTx);
        clock.forward(1L, TimeUnit.MINUTES);
        registry.release(txId2, newTx);
        registry.rollbackSuspendedTransactionsIdleSince(clock.currentTimeMillis() - 1000L);
        Assert.assertThat((Object)registry.acquire(txId2), (Matcher)CoreMatchers.equalTo((Object)newTx));
        try {
            registry.acquire(txId1);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (InvalidTransactionId e) {
            // empty catch block
        }
        log.assertExactly(new TestLogger.LogCall[]{TestLogger.LogCall.info((String)"Transaction with id 1 has been automatically rolled back.")});
    }

    @Test
    public void expiryTimeShouldBeSetToCurrentTimePlusTimeout() throws Exception {
        TestLogger log = new TestLogger();
        FakeClock clock = new FakeClock();
        int timeoutLength = 123;
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)clock, (long)timeoutLength, (StringLogger)log);
        TransactionHandle handle = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        long id = registry.begin();
        long timesOutAt = registry.release(id, handle);
        Assert.assertThat((Object)timesOutAt, (Matcher)CoreMatchers.equalTo((Object)(clock.currentTimeMillis() + (long)timeoutLength)));
        clock.forward(1337L, TimeUnit.MILLISECONDS);
        registry.acquire(id);
        timesOutAt = registry.release(id, handle);
        Assert.assertThat((Object)timesOutAt, (Matcher)CoreMatchers.equalTo((Object)(clock.currentTimeMillis() + (long)timeoutLength)));
    }
}

