/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.DefaultGraphDatabaseDependencies;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.WrappingNeoServer;
import org.neo4j.server.WrappingNeoServerBootstrapper;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.ServerConfigurator;
import org.neo4j.server.web.Jetty9WebServer;
import org.neo4j.server.web.WebServer;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.Mute;

@Path(value="/")
public class TestJetty9WebServer {
    @Rule
    public Mute mute = Mute.muteAll();

    @GET
    public Response index() {
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToRestart() throws Throwable {
        AbstractGraphDatabase db = (AbstractGraphDatabase)Mockito.mock(AbstractGraphDatabase.class);
        Mockito.when((Object)db.getDependencyResolver()).thenReturn((Object)this.noLoggingDependencyResolver());
        WrappingNeoServer neoServer = new WrappingNeoServer((GraphDatabaseAPI)db);
        WebServer server = neoServer.getWebServer();
        try {
            server.setAddress("127.0.0.1");
            server.setPort(7878);
            server.start();
            server.stop();
            server.start();
        }
        finally {
            try {
                server.stop();
            }
            catch (Throwable t) {}
        }
    }

    private DependencyResolver noLoggingDependencyResolver() {
        return new DependencyResolver.Adapter(){

            public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) throws IllegalArgumentException {
                if (Logging.class.isAssignableFrom(type)) {
                    return type.cast(DevNullLoggingService.DEV_NULL);
                }
                return null;
            }
        };
    }

    @Test
    public void shouldBeAbleToSetExecutionLimit() throws Throwable {
        ImpermanentGraphDatabase db = new ImpermanentGraphDatabase("path", MapUtil.stringMap((String[])new String[0]), (InternalAbstractGraphDatabase.Dependencies)new DefaultGraphDatabaseDependencies()){};
        ServerConfigurator config = new ServerConfigurator((GraphDatabaseAPI)db);
        config.configuration().setProperty("org.neo4j.server.webserver.port", (Object)7476);
        config.configuration().setProperty("org.neo4j.server.webserver.limit.executiontime", (Object)1000);
        WrappingNeoServerBootstrapper testBootstrapper = new WrappingNeoServerBootstrapper((GraphDatabaseAPI)db, (Configurator)config);
        testBootstrapper.start();
        testBootstrapper.stop();
    }

    @Test
    public void shouldStopCleanlyEvenWhenItHasntBeenStarted() {
        new Jetty9WebServer(DevNullLoggingService.DEV_NULL).stop();
    }
}

