/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.database;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.database.CommunityDatabase;
import org.neo4j.server.database.Database;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellLobby;
import org.neo4j.shell.ShellSettings;
import org.neo4j.test.BufferingLogging;
import org.neo4j.test.Mute;

public class TestCommunityDatabase {
    @Rule
    public Mute mute = Mute.muteAll();
    private File databaseDirectory;
    private Database theDatabase;
    private boolean deletionFailureOk;
    private Logging logging;

    @Before
    public void setup() throws Exception {
        this.databaseDirectory = ServerTestUtils.createTempDir();
        this.logging = new BufferingLogging();
        this.theDatabase = new CommunityDatabase(TestCommunityDatabase.configuratorWithServerProperties(MapUtil.stringMap((String[])new String[]{"org.neo4j.server.database.location", this.databaseDirectory.getAbsolutePath()})), this.logging);
    }

    private static Configurator configuratorWithServerProperties(final Map<String, String> serverProperties) {
        return new Configurator.Adapter(){

            public Configuration configuration() {
                return new MapConfiguration(serverProperties);
            }
        };
    }

    @After
    public void shutdownDatabase() throws Throwable {
        block2: {
            this.theDatabase.stop();
            try {
                FileUtils.forceDelete((File)this.databaseDirectory);
            }
            catch (IOException e) {
                if (this.deletionFailureOk) break block2;
                throw e;
            }
        }
    }

    @Test
    public void shouldLogOnSuccessfulStartup() throws Throwable {
        this.theDatabase.start();
        Assert.assertThat((Object)this.logging.toString(), (Matcher)Matchers.containsString((String)"Successfully started database"));
    }

    @Test
    public void shouldShutdownCleanly() throws Throwable {
        this.theDatabase.start();
        this.theDatabase.stop();
        Assert.assertThat((Object)this.logging.toString(), (Matcher)Matchers.containsString((String)"Successfully stopped database"));
    }

    @Test
    public void shouldComplainIfDatabaseLocationIsAlreadyInUse() throws Throwable {
        this.deletionFailureOk = true;
        this.theDatabase.start();
        CommunityDatabase db = new CommunityDatabase(TestCommunityDatabase.configuratorWithServerProperties(MapUtil.stringMap((String[])new String[]{"org.neo4j.server.database.location", this.databaseDirectory.getAbsolutePath()})), this.logging);
        try {
            db.start();
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)e.getCause().getCause(), (Matcher)IsInstanceOf.instanceOf(StoreLockException.class));
        }
    }

    @Test
    public void connectWithShellOnDefaultPortWhenNoShellConfigSupplied() throws Throwable {
        this.theDatabase.start();
        ShellLobby.newClient().shutdown();
    }

    @Test
    public void shouldBeAbleToOverrideShellConfig() throws Throwable {
        final int customPort = this.findFreeShellPortToUse(8881);
        final File tempDir = ServerTestUtils.createTempDir();
        CommunityDatabase otherDb = new CommunityDatabase((Configurator)new Configurator.Adapter(){

            public Configuration configuration() {
                return new MapConfiguration(MapUtil.stringMap((String[])new String[]{"org.neo4j.server.database.location", tempDir.getAbsolutePath()}));
            }

            public Map<String, String> getDatabaseTuningProperties() {
                return MapUtil.stringMap((String[])new String[]{ShellSettings.remote_shell_enabled.name(), "true", ShellSettings.remote_shell_port.name(), "" + customPort});
            }
        }, this.logging);
        otherDb.start();
        ShellLobby.newClient((int)customPort).shutdown();
        otherDb.stop();
    }

    @Test
    public void shouldBeAbleToGetLocation() throws Throwable {
        this.theDatabase.start();
        Assert.assertThat((Object)this.theDatabase.getLocation(), (Matcher)Matchers.is((Object)this.theDatabase.getGraph().getStoreDir()));
    }

    private int findFreeShellPortToUse(int startingPort) {
        try {
            while (true) {
                ShellLobby.newClient((int)startingPort++).shutdown();
            }
        }
        catch (ShellException e) {
            return startingPort;
        }
    }
}

