/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.server.database.Database;

public class GraphDbHelper {
    private final Database database;

    public GraphDbHelper(Database database) {
        this.database = database;
    }

    public int getNumberOfNodes() {
        return this.numberOfEntitiesFor(Node.class);
    }

    public int getNumberOfRelationships() {
        return this.numberOfEntitiesFor(Relationship.class);
    }

    private int numberOfEntitiesFor(Class<? extends PropertyContainer> type) {
        return (int)((NodeManager)this.database.getGraph().getDependencyResolver().resolveDependency(NodeManager.class)).getNumberOfIdsInUse(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getNodeProperties(long nodeId) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            Node node = this.database.getGraph().getNodeById(nodeId);
            HashMap<String, Object> allProperties = new HashMap<String, Object>();
            for (String propertyKey : node.getPropertyKeys()) {
                allProperties.put(propertyKey, node.getProperty(propertyKey));
            }
            tx.success();
            HashMap<String, Object> hashMap = allProperties;
            return hashMap;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeProperties(long nodeId, Map<String, Object> properties) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            Node node = this.database.getGraph().getNodeById(nodeId);
            for (Map.Entry<String, Object> propertyEntry : properties.entrySet()) {
                node.setProperty(propertyEntry.getKey(), propertyEntry.getValue());
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createNode(Label ... labels) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            Node node = this.database.getGraph().createNode(labels);
            tx.success();
            long l = node.getId();
            return l;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createNode(Map<String, Object> properties, Label ... labels) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            Node node = this.database.getGraph().createNode(labels);
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                node.setProperty(entry.getKey(), entry.getValue());
            }
            tx.success();
            long l = node.getId();
            return l;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNode(long id) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            Node node = this.database.getGraph().getNodeById(id);
            node.delete();
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createRelationship(String type, long startNodeId, long endNodeId) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            Node startNode = this.database.getGraph().getNodeById(startNodeId);
            Node endNode = this.database.getGraph().getNodeById(endNodeId);
            Relationship relationship = startNode.createRelationshipTo(endNode, (RelationshipType)DynamicRelationshipType.withName((String)type));
            tx.success();
            long l = relationship.getId();
            return l;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createRelationship(String type) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            Node startNode = this.database.getGraph().createNode();
            Node endNode = this.database.getGraph().createNode();
            Relationship relationship = startNode.createRelationshipTo(endNode, (RelationshipType)DynamicRelationshipType.withName((String)type));
            tx.success();
            long l = relationship.getId();
            return l;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRelationshipProperties(long relationshipId, Map<String, Object> properties) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            Relationship relationship = this.database.getGraph().getRelationshipById(relationshipId);
            for (Map.Entry<String, Object> propertyEntry : properties.entrySet()) {
                relationship.setProperty(propertyEntry.getKey(), propertyEntry.getValue());
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getRelationshipProperties(long relationshipId) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            Relationship relationship = this.database.getGraph().getRelationshipById(relationshipId);
            HashMap<String, Object> allProperties = new HashMap<String, Object>();
            for (String propertyKey : relationship.getPropertyKeys()) {
                allProperties.put(propertyKey, relationship.getProperty(propertyKey));
            }
            tx.success();
            HashMap<String, Object> hashMap = allProperties;
            return hashMap;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Relationship getRelationship(long relationshipId) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            Relationship relationship = this.database.getGraph().getRelationshipById(relationshipId);
            tx.success();
            Relationship relationship2 = relationship;
            return relationship2;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodeToIndex(String indexName, String key, Object value, long id) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            this.database.getNodeIndex(indexName).add((PropertyContainer)this.database.getGraph().getNodeById(id), key, value);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Long> queryIndexedNodes(String indexName, String key, Object value) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            ArrayList<Long> result = new ArrayList<Long>();
            for (Node node : this.database.getNodeIndex(indexName).query(key, value)) {
                result.add(node.getId());
            }
            tx.success();
            ArrayList<Long> arrayList = result;
            return arrayList;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Long> getIndexedNodes(String indexName, String key, Object value) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            ArrayList<Long> result = new ArrayList<Long>();
            for (Node node : this.database.getNodeIndex(indexName).get(key, value)) {
                result.add(node.getId());
            }
            tx.success();
            ArrayList<Long> arrayList = result;
            return arrayList;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Long> getIndexedRelationships(String indexName, String key, Object value) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            ArrayList<Long> result = new ArrayList<Long>();
            for (Relationship relationship : this.database.getRelationshipIndex(indexName).get(key, value)) {
                result.add(relationship.getId());
            }
            tx.success();
            ArrayList<Long> arrayList = result;
            return arrayList;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRelationshipToIndex(String indexName, String key, String value, long relationshipId) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            Index index = this.database.getRelationshipIndex(indexName);
            index.add((PropertyContainer)this.database.getGraph().getRelationshipById(relationshipId), key, (Object)value);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getNodeIndexes() {
        Transaction transaction = this.database.getGraph().beginTx();
        try {
            String[] stringArray = this.database.getIndexManager().nodeIndexNames();
            return stringArray;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index<Node> createNodeFullTextIndex(String named) {
        Transaction transaction = this.database.getGraph().beginTx();
        try {
            Index index = this.database.getIndexManager().forNodes(named, MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "fulltext"}));
            transaction.success();
            Index index2 = index;
            return index2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index<Node> createNodeIndex(String named) {
        Transaction transaction = this.database.getGraph().beginTx();
        try {
            Index nodeIndex = this.database.getIndexManager().forNodes(named);
            transaction.success();
            Index index = nodeIndex;
            return index;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getRelationshipIndexes() {
        Transaction transaction = this.database.getGraph().beginTx();
        try {
            String[] stringArray = this.database.getIndexManager().relationshipIndexNames();
            return stringArray;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFirstNode() {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            Node referenceNode = this.database.getGraph().getNodeById(0L);
            tx.success();
            long l = referenceNode.getId();
            return l;
        }
        catch (NotFoundException e) {
            Node newNode = this.database.getGraph().createNode();
            tx.success();
            long l = newNode.getId();
            return l;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index<Relationship> createRelationshipIndex(String named) {
        Transaction transaction = this.database.getGraph().beginTx();
        try {
            RelationshipIndex relationshipIndex = this.database.getIndexManager().forRelationships(named);
            transaction.success();
            RelationshipIndex relationshipIndex2 = relationshipIndex;
            return relationshipIndex2;
        }
        finally {
            transaction.finish();
        }
    }

    public Iterable<String> getNodeLabels(long node) {
        return new IterableWrapper<String, Label>(this.database.getGraph().getNodeById(node).getLabels()){

            protected String underlyingObjectToObject(Label object) {
                return object.name();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLabelToNode(long node, String labelName) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            this.database.getGraph().getNodeById(node).addLabel(DynamicLabel.label((String)labelName));
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    public Iterable<IndexDefinition> getSchemaIndexes(String labelName) {
        return this.database.getGraph().schema().getIndexes(DynamicLabel.label((String)labelName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexDefinition createSchemaIndex(String labelName, String propertyKey) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            IndexDefinition index = this.database.getGraph().schema().indexFor(DynamicLabel.label((String)labelName)).on(propertyKey).create();
            tx.success();
            IndexDefinition indexDefinition = index;
            return indexDefinition;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<ConstraintDefinition> getPropertyUniquenessConstraints(String labelName, final String propertyKey) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            Iterable definitions = Iterables.filter((Predicate)new Predicate<ConstraintDefinition>(){

                public boolean accept(ConstraintDefinition item) {
                    if (item.isConstraintType(ConstraintType.UNIQUENESS)) {
                        Iterable keys = item.getPropertyKeys();
                        return ((String)Iterables.single((Iterable)keys)).equals(propertyKey);
                    }
                    return false;
                }
            }, (Iterable)this.database.getGraph().schema().getConstraints(DynamicLabel.label((String)labelName)));
            tx.success();
            Iterable iterable = definitions;
            return iterable;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstraintDefinition createPropertyUniquenessConstraint(String labelName, List<String> propertyKeys) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            ConstraintCreator creator = this.database.getGraph().schema().constraintFor(DynamicLabel.label((String)labelName));
            for (String propertyKey : propertyKeys) {
                creator = creator.assertPropertyIsUnique(propertyKey);
            }
            ConstraintDefinition result = creator.create();
            tx.success();
            ConstraintDefinition constraintDefinition = result;
            return constraintDefinition;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLabelCount(long nodeId) {
        Transaction transaction = this.database.getGraph().beginTx();
        try {
            long l = Iterables.count((Iterable)this.database.getGraph().getNodeById(nodeId).getLabels());
            return l;
        }
        finally {
            transaction.finish();
        }
    }
}

