/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.FakeClock;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.WrappedDatabase;
import org.neo4j.server.rest.domain.GraphDbHelper;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.domain.TraverserReturnType;
import org.neo4j.server.rest.paging.LeaseManager;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RelationshipRepresentationTest;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;
import org.neo4j.server.rest.web.DatabaseActions;
import org.neo4j.server.rest.web.ModelBuilder;
import org.neo4j.server.rest.web.RestfulGraphDatabase;
import org.neo4j.server.rest.web.TransactionWrappingRestfulGraphDatabase;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.server.EntityOutputFormat;

public class RestfulGraphDatabaseTest {
    private static final String NODE_AUTO_INDEX = "node_auto_index";
    private static final String RELATIONSHIP_AUTO_INDEX = "relationship_auto_index";
    private static final String BASE_URI = "http://neo4j.org/";
    private static final String NODE_SUBPATH = "node/";
    private static RestfulGraphDatabase service;
    private static Database database;
    private static GraphDbHelper helper;
    private static EntityOutputFormat output;
    private static LeaseManager leaseManager;
    private static final ForceMode FORCE;
    private static AbstractGraphDatabase graph;

    @BeforeClass
    public static void doBefore() throws IOException {
        graph = (AbstractGraphDatabase)new TestGraphDatabaseFactory().newImpermanentDatabase();
        database = new WrappedDatabase(graph);
        helper = new GraphDbHelper(database);
        output = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), URI.create(BASE_URI), null);
        leaseManager = new LeaseManager((Clock)new FakeClock());
        service = new RestfulGraphDatabase((InputFormat)new JsonFormat(), (OutputFormat)output, new DatabaseActions(leaseManager, ForceMode.forced, true, database.getGraph()));
        service = new TransactionWrappingRestfulGraphDatabase(graph, service);
    }

    @Before
    public void deleteAllIndexes() throws JsonParseException {
        for (String name : helper.getNodeIndexes()) {
            if (NODE_AUTO_INDEX.equals(name)) {
                this.stopAutoIndexAllPropertiesAndDisableAutoIndex("node");
                continue;
            }
            service.deleteNodeIndex(FORCE, name);
        }
        for (String name : helper.getRelationshipIndexes()) {
            if (RELATIONSHIP_AUTO_INDEX.equals(name)) {
                this.stopAutoIndexAllPropertiesAndDisableAutoIndex("relationship");
                continue;
            }
            service.deleteRelationshipIndex(FORCE, name);
        }
    }

    protected void stopAutoIndexAllPropertiesAndDisableAutoIndex(String type) throws JsonParseException {
        Response response = service.getAutoIndexedProperties(type);
        List<String> properties = RestfulGraphDatabaseTest.entityAsList(response);
        for (String property : properties) {
            service.stopAutoIndexingProperty(type, property);
        }
        service.setAutoIndexerEnabled(type, "false");
    }

    @AfterClass
    public static void shutdownDatabase() throws Throwable {
        graph.shutdown();
    }

    private static String entityAsString(Response response) {
        byte[] bytes = (byte[])response.getEntity();
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not decode UTF-8", e);
        }
    }

    private static List<String> entityAsList(Response response) throws JsonParseException {
        String entity = RestfulGraphDatabaseTest.entityAsString(response);
        return (List)JsonHelper.readJson((String)entity);
    }

    @Test
    public void shouldFailGracefullyWhenViolatingConstraintOnPropertyUpdate() throws Exception {
        Response response = service.createPropertyUniquenessConstraint("Person", "{\"property_keys\":[\"name\"]}");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.createPerson("Fred");
        String wilma = this.createPerson("Wilma");
        Assert.assertEquals((long)409L, (long)service.setAllNodeProperties(FORCE, Long.parseLong(wilma), "{\"name\":\"Fred\"}").getStatus());
        Assert.assertEquals((long)409L, (long)service.setNodeProperty(FORCE, Long.parseLong(wilma), "name", "\"Fred\"").getStatus());
    }

    private String createPerson(String name) throws JsonParseException {
        Response response = service.createNode(FORCE, "{\"name\" : \"" + name + "\"}");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        String self = (String)JsonHelper.jsonToMap((String)RestfulGraphDatabaseTest.entityAsString(response)).get("self");
        String nodeId = self.substring(self.indexOf(NODE_SUBPATH) + NODE_SUBPATH.length());
        response = service.addNodeLabel(FORCE, Long.parseLong(nodeId), "\"Person\"");
        Assert.assertEquals((long)204L, (long)response.getStatus());
        return nodeId;
    }

    @Test
    public void shouldRespondWith201LocationHeaderAndNodeRepresentationInJSONWhenEmptyNodeCreated() throws Exception {
        Response response = service.createNode(FORCE, null);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertNotNull(((List)response.getMetadata().get((Object)"Location")).get(0));
        this.checkContentTypeCharsetUtf8(response);
        String json = RestfulGraphDatabaseTest.entityAsString(response);
        Map map = JsonHelper.jsonToMap((String)json);
        Assert.assertNotNull((Object)map);
        Assert.assertTrue((boolean)map.containsKey("self"));
    }

    @Test
    public void shouldRespondWith201LocationHeaderAndNodeRepresentationInJSONWhenPopulatedNodeCreated() throws Exception {
        Response response = service.createNode(FORCE, "{\"foo\" : \"bar\"}");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertNotNull(((List)response.getMetadata().get((Object)"Location")).get(0));
        this.checkContentTypeCharsetUtf8(response);
        String json = RestfulGraphDatabaseTest.entityAsString(response);
        Map map = JsonHelper.jsonToMap((String)json);
        Assert.assertNotNull((Object)map);
        Assert.assertTrue((boolean)map.containsKey("self"));
        Map data = (Map)map.get("data");
        Assert.assertEquals((Object)"bar", data.get("foo"));
    }

    @Test
    public void shouldRespondWith201LocationHeaderAndNodeRepresentationInJSONWhenPopulatedNodeCreatedWithArrays() throws Exception {
        Response response = service.createNode(FORCE, "{\"foo\" : [\"bar\", \"baz\"] }");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertNotNull(((List)response.getMetadata().get((Object)"Location")).get(0));
        String json = RestfulGraphDatabaseTest.entityAsString(response);
        Map map = JsonHelper.jsonToMap((String)json);
        Assert.assertNotNull((Object)map);
        Map data = (Map)map.get("data");
        List foo = (List)data.get("foo");
        Assert.assertNotNull((Object)foo);
        Assert.assertEquals((long)2L, (long)foo.size());
    }

    @Test
    public void shouldRespondWith400WhenNodeCreatedWithUnsupportedPropertyData() {
        Response response = service.createNode(FORCE, "{\"foo\" : {\"bar\" : \"baz\"}}");
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith400WhenNodeCreatedWithInvalidJSON() {
        Response response = service.createNode(FORCE, "this:::isNot::JSON}");
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith200AndNodeRepresentationInJSONWhenNodeRequested() throws Exception {
        Response response = service.getNode(helper.createNode(new Label[0]));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        String json = RestfulGraphDatabaseTest.entityAsString(response);
        Map map = JsonHelper.jsonToMap((String)json);
        Assert.assertNotNull((Object)map);
        Assert.assertTrue((boolean)map.containsKey("self"));
    }

    @Test
    public void shouldRespondWith404WhenRequestedNodeDoesNotExist() throws Exception {
        Response response = service.getNode(9000000000000L);
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith204AfterSettingPropertiesOnExistingNode() throws Exception {
        Response response = service.setAllNodeProperties(FORCE, helper.createNode(new Label[0]), "{\"foo\" : \"bar\", \"a-boolean\": true, \"boolean-array\": [true, false, false]}");
        Assert.assertEquals((long)204L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith404WhenSettingPropertiesOnNodeThatDoesNotExist() throws Exception {
        Response response = service.setAllNodeProperties(FORCE, 9000000000000L, "{\"foo\" : \"bar\"}");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith400WhenTransferringCorruptJsonPayload() throws Exception {
        Response response = service.setAllNodeProperties(FORCE, helper.createNode(new Label[0]), "{\"foo\" : bad-json-here \"bar\"}");
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith400WhenTransferringIncompatibleJsonPayload() throws Exception {
        Response response = service.setAllNodeProperties(FORCE, helper.createNode(new Label[0]), "{\"foo\" : {\"bar\" : \"baz\"}}");
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith200ForGetNodeProperties() throws Exception {
        long nodeId = helper.createNode(new Label[0]);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("foo", "bar");
        helper.setNodeProperties(nodeId, properties);
        Response response = service.getAllNodeProperties(nodeId);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.checkContentTypeCharsetUtf8(response);
    }

    @Test
    public void shouldRespondWith204ForGetNoNodeProperties() throws Exception {
        long nodeId = helper.createNode(new Label[0]);
        Response response = service.getAllNodeProperties(nodeId);
        Assert.assertEquals((long)204L, (long)response.getStatus());
    }

    @Test
    public void shouldGetPropertiesForGetNodeProperties() throws Exception {
        long nodeId = helper.createNode(new Label[0]);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("foo", "bar");
        properties.put("number", 15);
        properties.put("double", 15.7);
        helper.setNodeProperties(nodeId, properties);
        Response response = service.getAllNodeProperties(nodeId);
        String jsonBody = RestfulGraphDatabaseTest.entityAsString(response);
        Map readProperties = JsonHelper.jsonToMap((String)jsonBody);
        Assert.assertEquals(properties, (Object)readProperties);
    }

    @Test
    public void shouldRespondWith204OnSuccessfulDelete() {
        long id = helper.createNode(new Label[0]);
        Response response = service.deleteNode(FORCE, id);
        Assert.assertEquals((long)204L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith409IfNodeCannotBeDeleted() {
        long id = helper.createNode(new Label[0]);
        helper.createRelationship("LOVES", id, helper.createNode(new Label[0]));
        Response response = service.deleteNode(FORCE, id);
        Assert.assertEquals((long)409L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith404IfNodeToBeDeletedDoesNotExist() {
        long nonExistentId = 999999L;
        Response response = service.deleteNode(FORCE, nonExistentId);
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith204ForSetNodeProperty() {
        long nodeId = helper.createNode(new Label[0]);
        String key = "foo";
        String json = "\"bar\"";
        Response response = service.setNodeProperty(FORCE, nodeId, key, json);
        Assert.assertEquals((long)204L, (long)response.getStatus());
    }

    @Test
    public void shouldSetRightValueForSetNodeProperty() {
        long nodeId = helper.createNode(new Label[0]);
        String key = "foo";
        String value = "bar";
        String json = "\"" + value + "\"";
        service.setNodeProperty(FORCE, nodeId, key, json);
        Map<String, Object> readProperties = helper.getNodeProperties(nodeId);
        Assert.assertEquals(Collections.singletonMap(key, value), readProperties);
    }

    @Test
    public void shouldRespondWith404ForSetNodePropertyOnNonExistingNode() {
        String key = "foo";
        String json = "\"bar\"";
        Response response = service.setNodeProperty(FORCE, 999999L, key, json);
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith400ForSetNodePropertyWithInvalidJson() {
        String key = "foo";
        String json = "{invalid json";
        Response response = service.setNodeProperty(FORCE, 999999L, key, json);
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith404ForGetNonExistentNodeProperty() {
        long nodeId = helper.createNode(new Label[0]);
        Response response = service.getNodeProperty(FORCE, nodeId, "foo");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith404ForGetNodePropertyOnNonExistentNode() {
        long nodeId = 999999L;
        Response response = service.getNodeProperty(FORCE, nodeId, "foo");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith200ForGetNodeProperty() {
        long nodeId = helper.createNode(new Label[0]);
        String key = "foo";
        String value = "bar";
        helper.setNodeProperties(nodeId, Collections.singletonMap(key, value));
        Response response = service.getNodeProperty(FORCE, nodeId, "foo");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.checkContentTypeCharsetUtf8(response);
    }

    @Test
    public void shouldReturnCorrectValueForGetNodeProperty() throws Exception {
        long nodeId = helper.createNode(new Label[0]);
        String key = "foo";
        String value = "bar";
        helper.setNodeProperties(nodeId, Collections.singletonMap(key, value));
        Response response = service.getNodeProperty(FORCE, nodeId, "foo");
        Assert.assertEquals((Object)JsonHelper.createJsonFrom((Object)value), (Object)RestfulGraphDatabaseTest.entityAsString(response));
    }

    @Test
    public void shouldRespondWith201AndLocationWhenRelationshipIsCreatedWithoutProperties() {
        long startNode = helper.createNode(new Label[0]);
        long endNode = helper.createNode(new Label[0]);
        Response response = service.createRelationship(FORCE, startNode, "{\"to\" : \"http://neo4j.org/" + endNode + "\", \"type\" : \"LOVES\"}");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertNotNull(((List)response.getMetadata().get((Object)"Location")).get(0));
    }

    @Test
    public void shouldRespondWith201AndLocationWhenRelationshipIsCreatedWithProperties() {
        long startNode = helper.createNode(new Label[0]);
        long endNode = helper.createNode(new Label[0]);
        Response response = service.createRelationship(FORCE, startNode, "{\"to\" : \"http://neo4j.org/" + endNode + "\", \"type\" : \"LOVES\", " + "\"properties\" : {\"foo\" : \"bar\"}}");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertNotNull(((List)response.getMetadata().get((Object)"Location")).get(0));
    }

    @Test
    public void shouldReturnRelationshipRepresentationWhenCreatingRelationship() throws Exception {
        long startNode = helper.createNode(new Label[0]);
        long endNode = helper.createNode(new Label[0]);
        Response response = service.createRelationship(FORCE, startNode, "{\"to\" : \"http://neo4j.org/" + endNode + "\", \"type\" : \"LOVES\", \"data\" : {\"foo\" : \"bar\"}}");
        Map map = JsonHelper.jsonToMap((String)RestfulGraphDatabaseTest.entityAsString(response));
        Assert.assertNotNull((Object)map);
        Assert.assertTrue((boolean)map.containsKey("self"));
        this.checkContentTypeCharsetUtf8(response);
        Map data = (Map)map.get("data");
        Assert.assertEquals((Object)"bar", data.get("foo"));
    }

    @Test
    public void shouldRespondWith404WhenTryingToCreateRelationshipFromNonExistentNode() {
        long nodeId = helper.createNode(new Label[0]);
        Response response = service.createRelationship(FORCE, nodeId * 1000L, "{\"to\" : \"http://neo4j.org/" + nodeId + "\", \"type\" : \"LOVES\"}");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith400WhenTryingToCreateRelationshipToNonExistentNode() {
        long nodeId = helper.createNode(new Label[0]);
        Response response = service.createRelationship(FORCE, nodeId, "{\"to\" : \"http://neo4j.org/" + nodeId * 1000L + "\", \"type\" : \"LOVES\"}");
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith201WhenTryingToCreateRelationshipBackToSelf() {
        long nodeId = helper.createNode(new Label[0]);
        Response response = service.createRelationship(FORCE, nodeId, "{\"to\" : \"http://neo4j.org/" + nodeId + "\", \"type\" : \"LOVES\"}");
        Assert.assertEquals((long)201L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith400WhenTryingToCreateRelationshipWithBadJson() {
        long startNode = helper.createNode(new Label[0]);
        long endNode = helper.createNode(new Label[0]);
        Response response = service.createRelationship(FORCE, startNode, "{\"to\" : \"http://neo4j.org/" + endNode + "\", \"type\" ***and junk*** : \"LOVES\"}");
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith400WhenTryingToCreateRelationshipWithUnsupportedProperties() {
        long startNode = helper.createNode(new Label[0]);
        long endNode = helper.createNode(new Label[0]);
        Response response = service.createRelationship(FORCE, startNode, "{\"to\" : \"http://neo4j.org/" + endNode + "\", \"type\" : \"LOVES\", \"data\" : {\"foo\" : {\"bar\" : \"baz\"}}}");
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith204ForRemoveNodeProperties() {
        long nodeId = helper.createNode(new Label[0]);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("foo", "bar");
        properties.put("number", 15);
        helper.setNodeProperties(nodeId, properties);
        Response response = service.deleteAllNodeProperties(FORCE, nodeId);
        Assert.assertEquals((long)204L, (long)response.getStatus());
    }

    @Test
    public void shouldBeAbleToRemoveNodeProperties() {
        long nodeId = helper.createNode(new Label[0]);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("foo", "bar");
        properties.put("number", 15);
        helper.setNodeProperties(nodeId, properties);
        service.deleteAllNodeProperties(FORCE, nodeId);
        Assert.assertEquals((Object)true, (Object)helper.getNodeProperties(nodeId).isEmpty());
    }

    @Test
    public void shouldRespondWith404ForRemoveNodePropertiesForNonExistingNode() {
        long nodeId = 999999L;
        Response response = service.deleteAllNodeProperties(FORCE, nodeId);
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldBeAbleToRemoveNodeProperty() {
        long nodeId = helper.createNode(new Label[0]);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("foo", "bar");
        properties.put("number", 15);
        helper.setNodeProperties(nodeId, properties);
        service.deleteNodeProperty(FORCE, nodeId, "foo");
        Assert.assertEquals(Collections.singletonMap("number", 15), helper.getNodeProperties(nodeId));
    }

    @Test
    public void shouldGet404WhenRemovingNonExistingProperty() {
        long nodeId = helper.createNode(new Label[0]);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("foo", "bar");
        properties.put("number", 15);
        helper.setNodeProperties(nodeId, properties);
        Response response = service.deleteNodeProperty(FORCE, nodeId, "baz");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldGet404WhenRemovingPropertyFromNonExistingNode() {
        long nodeId = 999999L;
        Response response = service.deleteNodeProperty(FORCE, nodeId, "foo");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldGet200WhenRetrievingARelationshipFromANode() {
        long relationshipId = helper.createRelationship("BEATS");
        Response response = service.getRelationship(relationshipId);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.checkContentTypeCharsetUtf8(response);
    }

    @Test
    public void shouldGet404WhenRetrievingRelationshipThatDoesNotExist() {
        Response response = service.getRelationship(999999L);
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith200AndDataForGetRelationshipProperties() throws Exception {
        long relationshipId = helper.createRelationship("knows");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("foo", "bar");
        helper.setRelationshipProperties(relationshipId, properties);
        Response response = service.getAllRelationshipProperties(relationshipId);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.checkContentTypeCharsetUtf8(response);
        Map readProperties = JsonHelper.jsonToMap((String)RestfulGraphDatabaseTest.entityAsString(response));
        Assert.assertEquals(properties, (Object)readProperties);
    }

    @Test
    public void shouldRespondWith204ForGetNoRelationshipProperties() {
        long relationshipId = helper.createRelationship("knows");
        Response response = service.getAllRelationshipProperties(relationshipId);
        Assert.assertEquals((long)204L, (long)response.getStatus());
    }

    @Test
    public void shouldGet200WhenSuccessfullyRetrievedPropertyOnRelationship() throws Exception {
        long relationshipId = helper.createRelationship("knows");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("some-key", "some-value");
        helper.setRelationshipProperties(relationshipId, properties);
        Response response = service.getRelationshipProperty(relationshipId, "some-key");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"some-value", (Object)JsonHelper.jsonToSingleValue((String)RestfulGraphDatabaseTest.entityAsString(response)));
        this.checkContentTypeCharsetUtf8(response);
    }

    @Test
    public void shouldGet404WhenCannotResolveAPropertyOnRelationship() {
        long relationshipId = helper.createRelationship("knows");
        Response response = service.getRelationshipProperty(relationshipId, "some-key");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldGet204WhenRemovingARelationship() {
        long relationshipId = helper.createRelationship("KNOWS");
        Response response = service.deleteRelationship(FORCE, relationshipId);
        Assert.assertEquals((long)204L, (long)response.getStatus());
    }

    @Test
    public void shouldGet404WhenRemovingNonExistentRelationship() {
        long relationshipId = helper.createRelationship("KNOWS");
        Response response = service.deleteRelationship(FORCE, relationshipId + 1000L);
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith200AndListOfRelationshipRepresentationsWhenGettingRelationshipsForANode() throws Exception {
        long nodeId = helper.createNode(new Label[0]);
        helper.createRelationship("LIKES", nodeId, helper.createNode(new Label[0]));
        helper.createRelationship("LIKES", helper.createNode(new Label[0]), nodeId);
        helper.createRelationship("HATES", nodeId, helper.createNode(new Label[0]));
        Response response = service.getNodeRelationships(nodeId, DatabaseActions.RelationshipDirection.all, new RestfulGraphDatabase.AmpersandSeparatedCollection(""));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.checkContentTypeCharsetUtf8(response);
        this.verifyRelReps(3, RestfulGraphDatabaseTest.entityAsString(response));
        response = service.getNodeRelationships(nodeId, DatabaseActions.RelationshipDirection.in, new RestfulGraphDatabase.AmpersandSeparatedCollection(""));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.verifyRelReps(1, RestfulGraphDatabaseTest.entityAsString(response));
        response = service.getNodeRelationships(nodeId, DatabaseActions.RelationshipDirection.out, new RestfulGraphDatabase.AmpersandSeparatedCollection(""));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.verifyRelReps(2, RestfulGraphDatabaseTest.entityAsString(response));
        response = service.getNodeRelationships(nodeId, DatabaseActions.RelationshipDirection.out, new RestfulGraphDatabase.AmpersandSeparatedCollection("LIKES&HATES"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.verifyRelReps(2, RestfulGraphDatabaseTest.entityAsString(response));
        response = service.getNodeRelationships(nodeId, DatabaseActions.RelationshipDirection.all, new RestfulGraphDatabase.AmpersandSeparatedCollection("LIKES"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.verifyRelReps(2, RestfulGraphDatabaseTest.entityAsString(response));
    }

    @Test
    public void shouldNotReturnDuplicatesIfSameTypeSpecifiedMoreThanOnce() throws Exception {
        long nodeId = helper.createNode(new Label[0]);
        helper.createRelationship("LIKES", nodeId, helper.createNode(new Label[0]));
        Response response = service.getNodeRelationships(nodeId, DatabaseActions.RelationshipDirection.all, new RestfulGraphDatabase.AmpersandSeparatedCollection("LIKES&LIKES"));
        Collection array = (Collection)JsonHelper.jsonToSingleValue((String)RestfulGraphDatabaseTest.entityAsString(response));
        Assert.assertEquals((long)1L, (long)array.size());
    }

    private void verifyRelReps(int expectedSize, String entity) throws JsonParseException {
        List relreps = JsonHelper.jsonToList((String)entity);
        Assert.assertEquals((long)expectedSize, (long)relreps.size());
        for (Map relrep : relreps) {
            RelationshipRepresentationTest.verifySerialisation(relrep);
        }
    }

    @Test
    public void shouldRespondWith200AndEmptyListOfRelationshipRepresentationsWhenGettingRelationshipsForANodeWithoutRelationships() throws Exception {
        long nodeId = helper.createNode(new Label[0]);
        Response response = service.getNodeRelationships(nodeId, DatabaseActions.RelationshipDirection.all, new RestfulGraphDatabase.AmpersandSeparatedCollection(""));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.verifyRelReps(0, RestfulGraphDatabaseTest.entityAsString(response));
        this.checkContentTypeCharsetUtf8(response);
    }

    @Test
    public void shouldRespondWith404WhenGettingIncomingRelationshipsForNonExistingNode() {
        Response response = service.getNodeRelationships(999999L, DatabaseActions.RelationshipDirection.all, new RestfulGraphDatabase.AmpersandSeparatedCollection(""));
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith204AndSetCorrectDataWhenSettingRelationshipProperties() {
        long relationshipId = helper.createRelationship("KNOWS");
        String json = "{\"name\": \"Mattias\", \"age\": 30}";
        Response response = service.setAllRelationshipProperties(FORCE, relationshipId, json);
        Assert.assertEquals((long)204L, (long)response.getStatus());
        HashMap<String, Object> setProperties = new HashMap<String, Object>();
        setProperties.put("name", "Mattias");
        setProperties.put("age", 30);
        Assert.assertEquals(setProperties, helper.getRelationshipProperties(relationshipId));
    }

    @Test
    public void shouldRespondWith400WhenSettingRelationshipPropertiesWithBadJson() {
        long relationshipId = helper.createRelationship("KNOWS");
        String json = "{\"name: \"Mattias\", \"age\": 30}";
        Response response = service.setAllRelationshipProperties(FORCE, relationshipId, json);
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith404WhenSettingRelationshipPropertiesOnNonExistingRelationship() {
        long relationshipId = 99999999L;
        String json = "{\"name\": \"Mattias\", \"age\": 30}";
        Response response = service.setAllRelationshipProperties(FORCE, relationshipId, json);
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith204AndSetCorrectDataWhenSettingRelationshipProperty() {
        long relationshipId = helper.createRelationship("KNOWS");
        String key = "name";
        String value = "Mattias";
        String json = "\"" + value + "\"";
        Response response = service.setRelationshipProperty(FORCE, relationshipId, key, json);
        Assert.assertEquals((long)204L, (long)response.getStatus());
        Assert.assertEquals((Object)value, (Object)helper.getRelationshipProperties(relationshipId).get("name"));
    }

    @Test
    public void shouldRespondWith400WhenSettingRelationshipPropertyWithBadJson() {
        long relationshipId = helper.createRelationship("KNOWS");
        String json = "}Mattias";
        Response response = service.setRelationshipProperty(FORCE, relationshipId, "name", json);
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith404WhenSettingRelationshipPropertyOnNonExistingRelationship() {
        long relationshipId = 99999999L;
        String json = "\"Mattias\"";
        Response response = service.setRelationshipProperty(FORCE, relationshipId, "name", json);
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith204WhenSuccessfullyRemovedRelationshipProperties() {
        long relationshipId = helper.createRelationship("KNOWS");
        helper.setRelationshipProperties(relationshipId, Collections.singletonMap("foo", "bar"));
        Response response = service.deleteAllRelationshipProperties(FORCE, relationshipId);
        Assert.assertEquals((long)204L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith204WhenSuccessfullyRemovedRelationshipPropertiesWhichAreEmpty() {
        long relationshipId = helper.createRelationship("KNOWS");
        Response response = service.deleteAllRelationshipProperties(FORCE, relationshipId);
        Assert.assertEquals((long)204L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith404WhenNoRelationshipFromWhichToRemoveProperties() {
        long relationshipId = helper.createRelationship("KNOWS");
        Response response = service.deleteAllRelationshipProperties(FORCE, relationshipId + 1000L);
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith204WhenRemovingRelationshipProperty() {
        long relationshipId = helper.createRelationship("KNOWS");
        helper.setRelationshipProperties(relationshipId, Collections.singletonMap("foo", "bar"));
        Response response = service.deleteRelationshipProperty(FORCE, relationshipId, "foo");
        Assert.assertEquals((long)204L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith404WhenRemovingRelationshipPropertyWhichDoesNotExist() {
        long relationshipId = helper.createRelationship("KNOWS");
        Response response = service.deleteRelationshipProperty(FORCE, relationshipId, "foo");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith404WhenNoRelationshipFromWhichToRemoveProperty() {
        long relationshipId = helper.createRelationship("KNOWS");
        Response response = service.deleteRelationshipProperty(FORCE, relationshipId * 1000L, "some-key");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWithNoIndexOrOnlyNodeAutoIndex() throws JsonParseException {
        Response isEnabled = service.isAutoIndexerEnabled("node");
        Assert.assertEquals((Object)"false", (Object)RestfulGraphDatabaseTest.entityAsString(isEnabled));
        Response response = service.getNodeIndexRoot();
        if (response.getStatus() == 200) {
            Set<String> indexes = output.getResultAsMap().keySet();
            Assert.assertEquals((long)1L, (long)indexes.size());
            Assert.assertTrue((boolean)indexes.iterator().next().equals(NODE_AUTO_INDEX));
        } else {
            Assert.assertEquals((long)204L, (long)response.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRespondWithAvailableIndexNodeRoots() throws BadInputException {
        int numberOfAutoIndexesWhichCouldNotBeDeletedAtTestSetup = helper.getNodeIndexes().length;
        String indexName = "someNodes";
        helper.createNodeIndex(indexName);
        Response response = service.getNodeIndexRoot();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Transaction transaction = graph.beginTx();
        try {
            Map<String, Object> resultAsMap = output.getResultAsMap();
            Assert.assertThat((Object)resultAsMap.size(), (Matcher)Is.is((Object)(numberOfAutoIndexesWhichCouldNotBeDeletedAtTestSetup + 1)));
            Assert.assertThat(resultAsMap, (Matcher)Matchers.hasKey((Object)indexName));
        }
        finally {
            transaction.finish();
        }
    }

    @Test
    public void shouldRespondWithNoContentWhenNoRelationshipIndexesExist() {
        Response response = service.getRelationshipIndexRoot();
        Assert.assertEquals((long)204L, (long)response.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRespondWithAvailableIndexRelationshipRoots() throws BadInputException {
        String indexName = "someRelationships";
        helper.createRelationshipIndex(indexName);
        Response response = service.getRelationshipIndexRoot();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Transaction transaction = graph.beginTx();
        try {
            Map<String, Object> resultAsMap = output.getResultAsMap();
            Assert.assertThat((Object)resultAsMap.size(), (Matcher)Is.is((Object)1));
            Assert.assertThat(resultAsMap, (Matcher)Matchers.hasKey((Object)indexName));
        }
        finally {
            transaction.finish();
        }
    }

    @Test
    public void shouldBeAbleToGetRoot() throws JsonParseException {
        Response response = service.getRoot();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        String entity = RestfulGraphDatabaseTest.entityAsString(response);
        Map map = JsonHelper.jsonToMap((String)entity);
        Assert.assertNotNull(map.get("node"));
        Assert.assertNotNull(map.get("neo4j_version"));
        Assert.assertNotNull(map.get("node_index"));
        Assert.assertNotNull(map.get("extensions_info"));
        Assert.assertNotNull(map.get("relationship_index"));
        Assert.assertNotNull(map.get("batch"));
        this.checkContentTypeCharsetUtf8(response);
    }

    @Test
    public void shouldBeAbleToGetRootWhenNoReferenceNodePresent() throws Exception {
        helper.deleteNode(0L);
        Response response = service.getRoot();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        String entity = RestfulGraphDatabaseTest.entityAsString(response);
        Map map = JsonHelper.jsonToMap((String)entity);
        Assert.assertNotNull(map.get("node"));
        Assert.assertNotNull(map.get("node_index"));
        Assert.assertNotNull(map.get("extensions_info"));
        Assert.assertNotNull(map.get("relationship_index"));
        Assert.assertNull(map.get("reference_node"));
        this.checkContentTypeCharsetUtf8(response);
    }

    @Test
    public void shouldBeAbleToIndexNode() {
        Response response = service.createNode(FORCE, null);
        URI nodeUri = (URI)response.getMetadata().getFirst((Object)"Location");
        HashMap<String, String> postBody = new HashMap<String, String>();
        postBody.put("key", "mykey");
        postBody.put("value", "my/key");
        postBody.put("uri", nodeUri.toString());
        response = service.addToNodeIndex(FORCE, "node", null, null, JsonHelper.createJsonFrom(postBody));
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getMetadata().getFirst((Object)"Location"));
    }

    @Test
    public void shouldBeAbleToIndexNodeUniquely() {
        HashMap<String, String> postBody = new HashMap<String, String>();
        postBody.put("key", "mykey");
        postBody.put("value", "my/key");
        Response response = service.addToNodeIndex(FORCE, "unique-nodes", "", "", JsonHelper.createJsonFrom(postBody));
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getMetadata().getFirst((Object)"Location"));
        response = service.addToNodeIndex(FORCE, "unique-nodes", "", "", JsonHelper.createJsonFrom(postBody));
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void shouldNotBeAbleToIndexNodeUniquelyWithBothUriAndPropertiesInPayload() throws Exception {
        URI node = (URI)service.createNode(FORCE, null).getMetadata().getFirst((Object)"Location");
        HashMap<String, Object> postBody = new HashMap<String, Object>();
        postBody.put("key", "mykey");
        postBody.put("value", "my/key");
        postBody.put("uri", node.toString());
        postBody.put("properties", new HashMap());
        Response response = service.addToNodeIndex(FORCE, "unique-nodes", "", "", JsonHelper.createJsonFrom(postBody));
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void uniquelyIndexedNodeGetsTheSpecifiedKeyAndValueAsPropertiesIfNoPropertiesAreSpecified() throws Exception {
        String key = "somekey";
        String value = "somevalue";
        HashMap<String, String> postBody = new HashMap<String, String>();
        postBody.put("key", "somekey");
        postBody.put("value", "somevalue");
        Response response = service.addToNodeIndex(FORCE, "unique-nodes", "", "", JsonHelper.createJsonFrom(postBody));
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Object node = response.getMetadata().getFirst((Object)"Location");
        Assert.assertNotNull((Object)node);
        String uri = node.toString();
        Map<String, Object> properties = helper.getNodeProperties(Long.parseLong(uri.substring(uri.lastIndexOf(47) + 1)));
        Assert.assertEquals((long)1L, (long)properties.size());
        Assert.assertEquals((Object)"somevalue", (Object)properties.get("somekey"));
    }

    @Test
    public void specifiedPropertiesOverrideKeyAndValueForUniquelyIndexedNodes() throws Exception {
        String key = "a_key";
        String value = "a value";
        HashMap<String, Object> postBody = new HashMap<String, Object>();
        postBody.put("key", "a_key");
        postBody.put("value", "a value");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("name", "J\u00fcrgen");
        properties.put("age", "42");
        properties.put("occupation", "crazy");
        postBody.put("properties", properties);
        Response response = service.addToNodeIndex(FORCE, "unique-nodes", "", "", JsonHelper.createJsonFrom(postBody));
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Object node = response.getMetadata().getFirst((Object)"Location");
        Assert.assertNotNull((Object)node);
        String uri = node.toString();
        Assert.assertEquals(properties, helper.getNodeProperties(Long.parseLong(uri.substring(uri.lastIndexOf(47) + 1))));
    }

    @Test
    public void shouldNotBeAbleToCreateAnIndexWithEmptyName() throws Exception {
        URI node = (URI)service.createNode(FORCE, null).getMetadata().getFirst((Object)"Location");
        HashMap<String, String> createRel = new HashMap<String, String>();
        createRel.put("to", node.toString());
        createRel.put("type", "knows");
        URI rel = (URI)service.createRelationship(FORCE, helper.createNode(new Label[0]), JsonHelper.createJsonFrom(createRel)).getMetadata().getFirst((Object)"Location");
        HashMap<String, String> indexPostBody = new HashMap<String, String>();
        indexPostBody.put("key", "mykey");
        indexPostBody.put("value", "myvalue");
        indexPostBody.put("uri", node.toString());
        Response response = service.addToNodeIndex(FORCE, "", "", "", JsonHelper.createJsonFrom(indexPostBody));
        Assert.assertEquals((String)"http bad request when trying to create an index with empty name", (long)400L, (long)response.getStatus());
        indexPostBody.put("uri", rel.toString());
        response = service.addToRelationshipIndex(FORCE, "", "", "", JsonHelper.createJsonFrom(indexPostBody));
        Assert.assertEquals((String)"http bad request when trying to create an index with empty name", (long)400L, (long)response.getStatus());
        HashMap<String, String> basicIndexCreation = new HashMap<String, String>();
        basicIndexCreation.put("name", "");
        response = service.jsonCreateNodeIndex(FORCE, JsonHelper.createJsonFrom(basicIndexCreation));
        Assert.assertEquals((String)"http bad request when trying to create an index with empty name", (long)400L, (long)response.getStatus());
        response = service.jsonCreateRelationshipIndex(FORCE, JsonHelper.createJsonFrom(basicIndexCreation));
        Assert.assertEquals((String)"http bad request when trying to create an index with empty name", (long)400L, (long)response.getStatus());
    }

    @Test
    public void shouldNotBeAbleToIndexNodeUniquelyWithRequiredParameterMissing() throws Exception {
        service.createNode(FORCE, null).getMetadata().getFirst((Object)"Location");
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("key", "mykey");
        body.put("value", "my/key");
        for (String key : body.keySet()) {
            HashMap postBody = new HashMap(body);
            postBody.remove(key);
            Response response = service.addToNodeIndex(FORCE, "unique-nodes", "", "", JsonHelper.createJsonFrom(postBody));
            Assert.assertEquals((String)("unexpected response code with \"" + key + "\" missing."), (long)400L, (long)response.getStatus());
        }
    }

    @Test
    public void shouldBeAbleToIndexRelationshipUniquely() throws Exception {
        URI start = (URI)service.createNode(FORCE, null).getMetadata().getFirst((Object)"Location");
        URI end = (URI)service.createNode(FORCE, null).getMetadata().getFirst((Object)"Location");
        HashMap<String, String> postBody = new HashMap<String, String>();
        postBody.put("key", "mykey");
        postBody.put("value", "my/key");
        postBody.put("start", start.toString());
        postBody.put("end", end.toString());
        postBody.put("type", "knows");
        for (int i = 0; i < 2; ++i) {
            Response response = service.addToNodeIndex(FORCE, "unique-relationships", "", "", JsonHelper.createJsonFrom(postBody));
            Assert.assertEquals((long)(201 - i), (long)response.getStatus());
            if (i != 0) continue;
            Assert.assertNotNull((Object)response.getMetadata().getFirst((Object)"Location"));
        }
    }

    @Test
    public void uniquelyIndexedRelationshipGetsTheSpecifiedKeyAndValueAsPropertiesIfNoPropertiesAreSpecified() throws Exception {
        String key = "somekey";
        String value = "somevalue";
        URI start = (URI)service.createNode(FORCE, null).getMetadata().getFirst((Object)"Location");
        URI end = (URI)service.createNode(FORCE, null).getMetadata().getFirst((Object)"Location");
        HashMap<String, String> postBody = new HashMap<String, String>();
        postBody.put("key", "somekey");
        postBody.put("value", "somevalue");
        postBody.put("start", start.toString());
        postBody.put("end", end.toString());
        postBody.put("type", "knows");
        Response response = service.addToRelationshipIndex(FORCE, "unique-relationships", "", "", JsonHelper.createJsonFrom(postBody));
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Object rel = response.getMetadata().getFirst((Object)"Location");
        Assert.assertNotNull((Object)rel);
        String uri = rel.toString();
        Map<String, Object> properties = helper.getRelationshipProperties(Long.parseLong(uri.substring(uri.lastIndexOf(47) + 1)));
        Assert.assertEquals((long)1L, (long)properties.size());
        Assert.assertEquals((Object)"somevalue", (Object)properties.get("somekey"));
    }

    @Test
    public void specifiedPropertiesOverrideKeyAndValueForUniquelyIndexedRelationships() throws Exception {
        String key = "a_key";
        String value = "a value";
        URI start = (URI)service.createNode(FORCE, null).getMetadata().getFirst((Object)"Location");
        URI end = (URI)service.createNode(FORCE, null).getMetadata().getFirst((Object)"Location");
        HashMap<String, Object> postBody = new HashMap<String, Object>();
        postBody.put("key", "a_key");
        postBody.put("value", "a value");
        postBody.put("start", start.toString());
        postBody.put("end", end.toString());
        postBody.put("type", "knows");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("name", "J\u00fcrgen");
        properties.put("age", "42");
        properties.put("occupation", "crazy");
        postBody.put("properties", properties);
        Response response = service.addToRelationshipIndex(FORCE, "unique-relationships", "", "", JsonHelper.createJsonFrom(postBody));
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Object rel = response.getMetadata().getFirst((Object)"Location");
        Assert.assertNotNull((Object)rel);
        String uri = rel.toString();
        Assert.assertEquals(properties, helper.getRelationshipProperties(Long.parseLong(uri.substring(uri.lastIndexOf(47) + 1))));
    }

    @Test
    public void shouldNotBeAbleToIndexRelationshipUniquelyWithBothUriAndCreationalDataInPayload() throws Exception {
        URI start = (URI)service.createNode(FORCE, null).getMetadata().getFirst((Object)"Location");
        URI end = (URI)service.createNode(FORCE, null).getMetadata().getFirst((Object)"Location");
        String path = start.getPath();
        URI rel = (URI)service.createRelationship(FORCE, Long.parseLong(path.substring(path.lastIndexOf(47) + 1)), "{\"to\":\"" + end + "\",\"type\":\"knows\"}").getMetadata().getFirst((Object)"Location");
        HashMap<String, Object> unwanted = new HashMap<String, Object>();
        unwanted.put("properties", new HashMap());
        unwanted.put("start", start.toString());
        unwanted.put("end", end.toString());
        unwanted.put("type", "friend");
        for (Map.Entry bad : unwanted.entrySet()) {
            HashMap<String, String> postBody = new HashMap<String, String>();
            postBody.put("key", "mykey");
            postBody.put("value", "my/key");
            postBody.put("uri", rel.toString());
            postBody.put((String)bad.getKey(), (String)bad.getValue());
            Response response = service.addToRelationshipIndex(FORCE, "unique-relationships", "", "", JsonHelper.createJsonFrom(postBody));
            Assert.assertEquals((String)("unexpected response code with \"" + (String)bad.getKey() + "\"."), (long)400L, (long)response.getStatus());
        }
    }

    @Test
    public void shouldNotBeAbleToIndexRelationshipUniquelyWithRequiredParameterMissing() throws Exception {
        URI start = (URI)service.createNode(FORCE, null).getMetadata().getFirst((Object)"Location");
        URI end = (URI)service.createNode(FORCE, null).getMetadata().getFirst((Object)"Location");
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("key", "mykey");
        body.put("value", "my/key");
        body.put("start", start.toString());
        body.put("end", end.toString());
        body.put("type", "knows");
        for (String key : body.keySet()) {
            HashMap postBody = new HashMap(body);
            postBody.remove(key);
            Response response = service.addToRelationshipIndex(FORCE, "unique-relationships", "", "", JsonHelper.createJsonFrom(postBody));
            Assert.assertEquals((String)("unexpected response code with \"" + key + "\" missing."), (long)400L, (long)response.getStatus());
        }
    }

    @Test
    public void shouldBeAbleToRemoveNodeIndex() {
        String indexName = "myFancyIndex";
        int numberOfAutoIndexesWhichCouldNotBeDeletedAtTestSetup = helper.getNodeIndexes().length;
        helper.createNodeIndex(indexName);
        helper.createNodeIndex("another one");
        Assert.assertEquals((long)(numberOfAutoIndexesWhichCouldNotBeDeletedAtTestSetup + 2), (long)helper.getNodeIndexes().length);
        Response response = service.deleteNodeIndex(FORCE, indexName);
        Assert.assertEquals((long)204L, (long)response.getStatus());
        Assert.assertEquals((long)(numberOfAutoIndexesWhichCouldNotBeDeletedAtTestSetup + 1), (long)helper.getNodeIndexes().length);
    }

    @Test
    public void shouldBeAbleToRemoveRelationshipIndex() {
        String indexName = "myFancyIndex";
        Assert.assertEquals((long)0L, (long)helper.getRelationshipIndexes().length);
        helper.createRelationshipIndex(indexName);
        Assert.assertEquals((long)1L, (long)helper.getRelationshipIndexes().length);
        Response response = service.deleteRelationshipIndex(FORCE, indexName);
        Assert.assertEquals((long)204L, (long)response.getStatus());
        Assert.assertEquals((long)0L, (long)helper.getRelationshipIndexes().length);
    }

    @Test
    public void shouldBeAbleToGetNodeRepresentationFromIndexUri() throws Exception {
        String key = "key_get_noderep";
        String value = "value";
        long nodeId = helper.createNode(new Label[0]);
        String indexName = "all-the-best-nodes";
        helper.addNodeToIndex(indexName, key, value, nodeId);
        Response response = service.getNodeFromIndexUri(indexName, key, value, nodeId);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.checkContentTypeCharsetUtf8(response);
        Assert.assertNull((Object)response.getMetadata().get((Object)"Location"));
        Map map = JsonHelper.jsonToMap((String)RestfulGraphDatabaseTest.entityAsString(response));
        Assert.assertNotNull((Object)map);
        Assert.assertTrue((boolean)map.containsKey("self"));
    }

    private void checkContentTypeCharsetUtf8(Response response) {
        Assert.assertTrue((boolean)response.getMetadata().getFirst((Object)"Content-Type").toString().contains("UTF-8"));
    }

    @Test
    public void shouldBeAbleToGetRelationshipRepresentationFromIndexUri() throws Exception {
        String key = "key_get_noderep";
        String value = "value";
        long startNodeId = helper.createNode(new Label[0]);
        long endNodeId = helper.createNode(new Label[0]);
        String relationshipType = "knows";
        long relationshipId = helper.createRelationship(relationshipType, startNodeId, endNodeId);
        String indexName = "all-the-best-relationships";
        helper.addRelationshipToIndex(indexName, key, value, relationshipId);
        Response response = service.getRelationshipFromIndexUri(indexName, key, value, relationshipId);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.checkContentTypeCharsetUtf8(response);
        Assert.assertNull((Object)response.getMetadata().get((Object)"Location"));
        Map map = JsonHelper.jsonToMap((String)RestfulGraphDatabaseTest.entityAsString(response));
        Assert.assertNotNull((Object)map);
        Assert.assertTrue((boolean)map.containsKey("self"));
    }

    @Test
    public void shouldBeAbleToGetListOfNodeRepresentationsFromIndexLookup() throws Exception {
        ModelBuilder.DomainModel matrixers = ModelBuilder.generateMatrix(service);
        Map.Entry<String, String> indexedKeyValue = matrixers.indexedNodeKeyValues.entrySet().iterator().next();
        Response response = service.getIndexedNodes(matrixers.nodeIndexName, indexedKeyValue.getKey(), indexedKeyValue.getValue());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Collection items = (Collection)JsonHelper.jsonToSingleValue((String)RestfulGraphDatabaseTest.entityAsString(response));
        int counter = 0;
        for (Object item : items) {
            Map map = (Map)item;
            Map properties = (Map)map.get("data");
            Assert.assertNotNull(map.get("self"));
            String indexedUri = (String)map.get("indexed");
            Assert.assertEquals((Object)matrixers.indexedNodeUriToEntityMap.get((Object)new URI((String)indexedUri)).properties.get("name"), properties.get("name"));
            ++counter;
        }
        Assert.assertEquals((long)2L, (long)counter);
    }

    @Test
    public void shouldBeAbleToGetListOfNodeRepresentationsFromIndexQuery() throws Exception {
        ModelBuilder.DomainModel matrixers = ModelBuilder.generateMatrix(service);
        Map.Entry<String, String> indexedKeyValue = matrixers.indexedNodeKeyValues.entrySet().iterator().next();
        Response response = service.getIndexedNodesByQuery(matrixers.nodeIndexName, indexedKeyValue.getKey() + ":" + indexedKeyValue.getValue().substring(0, 1) + "*", "");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Collection items = (Collection)JsonHelper.jsonToSingleValue((String)RestfulGraphDatabaseTest.entityAsString(response));
        int counter = 0;
        for (Object item : items) {
            Map map = (Map)item;
            Map properties = (Map)map.get("data");
            String indexedUri = (String)map.get("indexed");
            Assert.assertNull((Object)indexedUri);
            String selfUri = (String)map.get("self");
            Assert.assertNotNull((Object)selfUri);
            Assert.assertEquals((Object)matrixers.nodeUriToEntityMap.get((Object)new URI((String)selfUri)).properties.get("name"), properties.get("name"));
            ++counter;
        }
        Assert.assertThat((Object)counter, (Matcher)Is.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2))));
    }

    @Test
    public void shouldBeAbleToGetListOfNodeRepresentationsFromIndexQueryWithDefaultKey() throws Exception {
        ModelBuilder.DomainModel matrixers = ModelBuilder.generateMatrix(service);
        Map.Entry<String, String> indexedKeyValue = matrixers.indexedNodeKeyValues.entrySet().iterator().next();
        Response response = service.getIndexedNodesByQuery(matrixers.nodeIndexName, indexedKeyValue.getKey(), indexedKeyValue.getValue().substring(0, 1) + "*", "");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Collection items = (Collection)JsonHelper.jsonToSingleValue((String)RestfulGraphDatabaseTest.entityAsString(response));
        int counter = 0;
        for (Object item : items) {
            Map map = (Map)item;
            Map properties = (Map)map.get("data");
            String indexedUri = (String)map.get("indexed");
            Assert.assertNull((Object)indexedUri);
            String selfUri = (String)map.get("self");
            Assert.assertNotNull((Object)selfUri);
            Assert.assertEquals((Object)matrixers.nodeUriToEntityMap.get((Object)new URI((String)selfUri)).properties.get("name"), properties.get("name"));
            ++counter;
        }
        Assert.assertThat((Object)counter, (Matcher)Is.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2))));
    }

    @Test
    public void shouldBeAbleToGetListOfRelationshipRepresentationsFromIndexLookup() throws Exception {
        String key = "key_get";
        String value = "value";
        long startNodeId = helper.createNode(new Label[0]);
        long endNodeId = helper.createNode(new Label[0]);
        String relationshipType1 = "KNOWS";
        long relationshipId1 = helper.createRelationship(relationshipType1, startNodeId, endNodeId);
        String relationshipType2 = "PLAYS-NICE-WITH";
        long relationshipId2 = helper.createRelationship(relationshipType2, startNodeId, endNodeId);
        String indexName = "matrixal-relationships";
        helper.createRelationshipIndex(indexName);
        helper.addRelationshipToIndex(indexName, key, value, relationshipId1);
        helper.addRelationshipToIndex(indexName, key, value, relationshipId2);
        Response response = service.getIndexedRelationships(indexName, key, value);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Collection items = (Collection)JsonHelper.jsonToSingleValue((String)RestfulGraphDatabaseTest.entityAsString(response));
        int counter = 0;
        for (Object item : items) {
            Map map = (Map)item;
            Assert.assertNotNull(map.get("self"));
            String indexedUri = (String)map.get("indexed");
            Assert.assertThat((Object)indexedUri, (Matcher)Matchers.containsString((String)key));
            Assert.assertThat((Object)indexedUri, (Matcher)Matchers.containsString((String)value));
            Assert.assertTrue((indexedUri.endsWith(Long.toString(relationshipId1)) || indexedUri.endsWith(Long.toString(relationshipId2)) ? 1 : 0) != 0);
            ++counter;
        }
        Assert.assertEquals((long)2L, (long)counter);
    }

    @Test
    public void shouldBeAbleToGetListOfRelationshipRepresentationsFromIndexQuery() throws Exception {
        String key = "key_get";
        String value = "value";
        long startNodeId = helper.createNode(new Label[0]);
        long endNodeId = helper.createNode(new Label[0]);
        String relationshipType1 = "KNOWS";
        long relationshipId1 = helper.createRelationship(relationshipType1, startNodeId, endNodeId);
        String relationshipType2 = "PLAYS-NICE-WITH";
        long relationshipId2 = helper.createRelationship(relationshipType2, startNodeId, endNodeId);
        String indexName = "matrixal-relationships";
        helper.createRelationshipIndex(indexName);
        helper.addRelationshipToIndex(indexName, key, value, relationshipId1);
        helper.addRelationshipToIndex(indexName, key, value, relationshipId2);
        Response response = service.getIndexedRelationshipsByQuery(indexName, key + ":" + value.substring(0, 1) + "*", "");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Collection items = (Collection)JsonHelper.jsonToSingleValue((String)RestfulGraphDatabaseTest.entityAsString(response));
        int counter = 0;
        for (Object item : items) {
            Map map = (Map)item;
            String indexedUri = (String)map.get("indexed");
            Assert.assertNull((Object)indexedUri);
            String selfUri = (String)map.get("self");
            Assert.assertNotNull((Object)selfUri);
            Assert.assertTrue((selfUri.endsWith(Long.toString(relationshipId1)) || selfUri.endsWith(Long.toString(relationshipId2)) ? 1 : 0) != 0);
            ++counter;
        }
        Assert.assertThat((Object)counter, (Matcher)Is.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2))));
    }

    @Test
    public void shouldBeAbleToGetListOfRelationshipRepresentationsFromIndexQueryWithDefaultKey() throws Exception {
        String key = "key_get";
        String value = "value";
        long startNodeId = helper.createNode(new Label[0]);
        long endNodeId = helper.createNode(new Label[0]);
        String relationshipType1 = "KNOWS";
        long relationshipId1 = helper.createRelationship(relationshipType1, startNodeId, endNodeId);
        String relationshipType2 = "PLAYS-NICE-WITH";
        long relationshipId2 = helper.createRelationship(relationshipType2, startNodeId, endNodeId);
        String indexName = "matrixal-relationships";
        helper.createRelationshipIndex(indexName);
        helper.addRelationshipToIndex(indexName, key, value, relationshipId1);
        helper.addRelationshipToIndex(indexName, key, value, relationshipId2);
        Response response = service.getIndexedRelationshipsByQuery(indexName, key, value.substring(0, 1) + "*", "");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Collection items = (Collection)JsonHelper.jsonToSingleValue((String)RestfulGraphDatabaseTest.entityAsString(response));
        int counter = 0;
        for (Object item : items) {
            Map map = (Map)item;
            String indexedUri = (String)map.get("indexed");
            Assert.assertNull((Object)indexedUri);
            String selfUri = (String)map.get("self");
            Assert.assertNotNull((Object)selfUri);
            Assert.assertTrue((selfUri.endsWith(Long.toString(relationshipId1)) || selfUri.endsWith(Long.toString(relationshipId2)) ? 1 : 0) != 0);
            ++counter;
        }
        Assert.assertThat((Object)counter, (Matcher)Is.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2))));
    }

    @Test
    public void shouldGet200AndEmptyListWhenNothingFoundInIndexLookup() throws Exception {
        String indexName = "nothing-in-this-index";
        helper.createNodeIndex(indexName);
        Response response = service.getIndexedNodes(indexName, "fooo", "baaar");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        this.checkContentTypeCharsetUtf8(response);
        String entity = RestfulGraphDatabaseTest.entityAsString(response);
        Object parsedJson = JsonHelper.jsonToSingleValue((String)entity);
        Assert.assertTrue((boolean)(parsedJson instanceof Collection));
        Assert.assertTrue((boolean)((Collection)parsedJson).isEmpty());
    }

    @Test
    public void shouldBeAbleToRemoveNodeFromIndex() {
        long nodeId = helper.createNode(new Label[0]);
        String key = "key_remove";
        String value = "value";
        helper.addNodeToIndex("node", key, value, nodeId);
        Assert.assertEquals((long)1L, (long)helper.getIndexedNodes("node", key, value).size());
        Response response = service.deleteFromNodeIndex(FORCE, "node", key, value, nodeId);
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((long)0L, (long)helper.getIndexedNodes("node", key, value).size());
    }

    @Test
    public void shouldBeAbleToRemoveRelationshipFromIndex() {
        long startNodeId = helper.createNode(new Label[0]);
        long endNodeId = helper.createNode(new Label[0]);
        String relationshipType = "related-to";
        long relationshipId = helper.createRelationship(relationshipType, startNodeId, endNodeId);
        String key = "key_remove";
        String value = "value";
        String indexName = "relationships";
        helper.addRelationshipToIndex(indexName, key, value, relationshipId);
        Assert.assertEquals((long)1L, (long)helper.getIndexedRelationships(indexName, key, value).size());
        Response response = service.deleteFromRelationshipIndex(FORCE, indexName, key, value, relationshipId);
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((long)0L, (long)helper.getIndexedRelationships(indexName, key, value).size());
    }

    @Test
    public void shouldGet404IfRemovingNonExistentNodeIndexing() {
        Response response = service.deleteFromNodeIndex(FORCE, "nodes", "bogus", "bogus", 999999L);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGet404IfRemovingNonExistentRelationshipIndexing() {
        Response response = service.deleteFromRelationshipIndex(FORCE, "relationships", "bogus", "bogus", 999999L);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGet404WhenTraversingFromNonExistentNode() {
        Response response = service.traverse(9999999L, TraverserReturnType.node, "{}");
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldGet200WhenNoHitsReturnedFromTraverse() {
        long startNode = helper.createNode(new Label[0]);
        Transaction transaction = graph.beginTx();
        try {
            Response response = service.traverse(startNode, TraverserReturnType.node, "");
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
            Assert.assertThat((Object)output.getResultAsList().size(), (Matcher)Is.is((Object)0));
        }
        finally {
            transaction.finish();
        }
    }

    @Test
    public void shouldGetSomeHitsWhenTraversingWithDefaultDescription() {
        long startNode = helper.createNode(new Label[0]);
        long child1_l1 = helper.createNode(new Label[0]);
        helper.createRelationship("knows", startNode, child1_l1);
        long child2_l1 = helper.createNode(new Label[0]);
        helper.createRelationship("knows", startNode, child2_l1);
        long child1_l2 = helper.createNode(new Label[0]);
        helper.createRelationship("knows", child2_l1, child1_l2);
        Response response = service.traverse(startNode, TraverserReturnType.node, "");
        String entity = RestfulGraphDatabaseTest.entityAsString(response);
        Assert.assertTrue((boolean)entity.contains("/node/" + child1_l1));
        Assert.assertTrue((boolean)entity.contains("/node/" + child2_l1));
        Assert.assertFalse((boolean)entity.contains("/node/" + child1_l2));
        this.checkContentTypeCharsetUtf8(response);
    }

    @Test
    public void shouldBeAbleToDescribeTraverser() {
        long startNode = helper.createNode(MapUtil.map((Object[])new Object[]{"name", "Mattias"}), new Label[0]);
        long node1 = helper.createNode(MapUtil.map((Object[])new Object[]{"name", "Emil"}), new Label[0]);
        long node2 = helper.createNode(MapUtil.map((Object[])new Object[]{"name", "Johan"}), new Label[0]);
        long node3 = helper.createNode(MapUtil.map((Object[])new Object[]{"name", "Tobias"}), new Label[0]);
        helper.createRelationship("knows", startNode, node1);
        helper.createRelationship("knows", startNode, node2);
        helper.createRelationship("knows", node1, node3);
        String description = "{\"prune_evaluator\":{\"language\":\"builtin\",\"name\":\"none\"},\"return_filter\":{\"language\":\"javascript\",\"body\":\"position.endNode().getProperty('name').toLowerCase().contains('t');\"},\"order\":\"depth_first\",\"relationships\":{\"type\":\"knows\",\"direction\":\"all\"}}";
        Response response = service.traverse(startNode, TraverserReturnType.node, description);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        String entity = RestfulGraphDatabaseTest.entityAsString(response);
        Assert.assertTrue((boolean)entity.contains(NODE_SUBPATH + startNode));
        Assert.assertFalse((boolean)entity.contains(NODE_SUBPATH + node1));
        Assert.assertFalse((boolean)entity.contains(NODE_SUBPATH + node2));
        Assert.assertTrue((boolean)entity.contains(NODE_SUBPATH + node3));
    }

    @Test
    public void shouldBeAbleToGetOtherResultTypesWhenTraversing() {
        long startNode = helper.createNode(MapUtil.map((Object[])new Object[]{"name", "Mattias"}), new Label[0]);
        long node1 = helper.createNode(MapUtil.map((Object[])new Object[]{"name", "Emil"}), new Label[0]);
        long node2 = helper.createNode(MapUtil.map((Object[])new Object[]{"name", "Johan"}), new Label[0]);
        long node3 = helper.createNode(MapUtil.map((Object[])new Object[]{"name", "Tobias"}), new Label[0]);
        long rel1 = helper.createRelationship("knows", startNode, node1);
        long rel2 = helper.createRelationship("knows", startNode, node2);
        long rel3 = helper.createRelationship("knows", node1, node3);
        Response response = service.traverse(startNode, TraverserReturnType.relationship, "");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        String entity = RestfulGraphDatabaseTest.entityAsString(response);
        Assert.assertTrue((boolean)entity.contains("/relationship/" + rel1));
        Assert.assertTrue((boolean)entity.contains("/relationship/" + rel2));
        Assert.assertFalse((boolean)entity.contains("/relationship/" + rel3));
        response = service.traverse(startNode, TraverserReturnType.path, "");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        entity = RestfulGraphDatabaseTest.entityAsString(response);
        Assert.assertTrue((boolean)entity.contains("nodes"));
        Assert.assertTrue((boolean)entity.contains("relationships"));
        Assert.assertTrue((boolean)entity.contains("length"));
        response = service.traverse(startNode, TraverserReturnType.fullpath, "");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        entity = RestfulGraphDatabaseTest.entityAsString(response);
        Assert.assertTrue((boolean)entity.contains("nodes"));
        Assert.assertTrue((boolean)entity.contains("data"));
        Assert.assertTrue((boolean)entity.contains("type"));
        Assert.assertTrue((boolean)entity.contains("self"));
        Assert.assertTrue((boolean)entity.contains("outgoing_relationships"));
        Assert.assertTrue((boolean)entity.contains("incoming_relationships"));
        Assert.assertTrue((boolean)entity.contains("relationships"));
        Assert.assertTrue((boolean)entity.contains("length"));
    }

    private static String markWithUnicodeMarker(String string) {
        return String.valueOf('\ufeff') + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToFindSinglePathBetweenTwoNodes() throws Exception {
        long n1 = helper.createNode(new Label[0]);
        long n2 = helper.createNode(new Label[0]);
        helper.createRelationship("knows", n1, n2);
        Map config = MapUtil.map((Object[])new Object[]{"max depth", 3, "algorithm", "shortestPath", "to", Long.toString(n2), "relationships", MapUtil.map((Object[])new Object[]{"type", "knows", "direction", "out"})});
        String payload = JsonHelper.createJsonFrom((Object)config);
        Response response = service.singlePath(n1, payload);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Is.is((Object)200));
        Transaction transaction = graph.beginTx();
        try {
            Map<String, Object> resultAsMap = output.getResultAsMap();
            Assert.assertThat((Object)((Integer)resultAsMap.get("length")), (Matcher)Is.is((Object)1));
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToFindSinglePathBetweenTwoNodesEvenWhenAskingForAllPaths() throws Exception {
        long n1 = helper.createNode(new Label[0]);
        long n2 = helper.createNode(new Label[0]);
        helper.createRelationship("knows", n1, n2);
        Map config = MapUtil.map((Object[])new Object[]{"max depth", 3, "algorithm", "shortestPath", "to", Long.toString(n2), "relationships", MapUtil.map((Object[])new Object[]{"type", "knows", "direction", "out"})});
        String payload = JsonHelper.createJsonFrom((Object)config);
        Response response = service.allPaths(n1, payload);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Is.is((Object)200));
        Transaction transaction = graph.beginTx();
        try {
            List<Object> resultAsList = output.getResultAsList();
            Assert.assertThat((Object)resultAsList.size(), (Matcher)Is.is((Object)1));
        }
        finally {
            transaction.finish();
        }
    }

    @Test
    public void shouldBeAbleToParseJsonEvenWithUnicodeMarkerAtTheStart() throws Exception {
        Response response = service.createNode(FORCE, RestfulGraphDatabaseTest.markWithUnicodeMarker("{\"name\":\"Mattias\"}"));
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)response.getStatus());
        String nodeLocation = response.getMetadata().getFirst((Object)"Location").toString();
        long node = helper.createNode(new Label[0]);
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)service.setNodeProperty(FORCE, node, "foo", RestfulGraphDatabaseTest.markWithUnicodeMarker("\"bar\"")).getStatus());
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)service.setNodeProperty(FORCE, node, "foo", RestfulGraphDatabaseTest.markWithUnicodeMarker("10")).getStatus());
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)service.setAllNodeProperties(FORCE, node, RestfulGraphDatabaseTest.markWithUnicodeMarker("{\"name\":\"Something\",\"number\":10}")).getStatus());
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)service.createRelationship(FORCE, node, RestfulGraphDatabaseTest.markWithUnicodeMarker("{\"to\":\"" + nodeLocation + "\",\"type\":\"knows\"}")).getStatus());
        long relationship = helper.createRelationship("knows");
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)service.setRelationshipProperty(FORCE, relationship, "foo", RestfulGraphDatabaseTest.markWithUnicodeMarker("\"bar\"")).getStatus());
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)service.setRelationshipProperty(FORCE, relationship, "foo", RestfulGraphDatabaseTest.markWithUnicodeMarker("10")).getStatus());
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)service.setAllRelationshipProperties(FORCE, relationship, RestfulGraphDatabaseTest.markWithUnicodeMarker("{\"name\":\"Something\",\"number\":10}")).getStatus());
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)service.addToNodeIndex(FORCE, "node", null, null, RestfulGraphDatabaseTest.markWithUnicodeMarker("{\"key\":\"foo\", \"value\":\"bar\", \"uri\": \"" + nodeLocation + "\"}")).getStatus());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)service.traverse(node, TraverserReturnType.node, RestfulGraphDatabaseTest.markWithUnicodeMarker("{\"max depth\":2}")).getStatus());
    }

    @Test
    public void shouldAdvertiseUriForQueringAllRelationsInTheDatabase() {
        Response response = service.getRoot();
        Assert.assertThat((Object)new String((byte[])response.getEntity()), (Matcher)Matchers.containsString((String)"\"relationship_types\" : \"http://neo4j.org/relationship/types\""));
    }

    @Test
    public void nodeAutoIndexerEnabling() {
        this.testAutoIndexEnableForType("node");
    }

    @Test
    public void relationshipAutoIndexerEnabling() {
        this.testAutoIndexEnableForType("relationship");
    }

    @Test
    public void addRemoveAutoindexPropertiesOnNodes() throws JsonParseException {
        this.addRemoveAutoindexProperties("node");
    }

    @Test
    public void addRemoveAutoindexPropertiesOnRelationships() throws JsonParseException {
        this.addRemoveAutoindexProperties("relationship");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void nodeAutoindexingSupposedToWork() throws JsonParseException {
        String type = "node";
        Response response = service.startAutoIndexingProperty(type, "myAutoIndexedProperty");
        Assert.assertEquals((long)204L, (long)response.getStatus());
        response = service.setAutoIndexerEnabled(type, "true");
        Assert.assertEquals((long)204L, (long)response.getStatus());
        service.createNode(FORCE, "{\"myAutoIndexedProperty\" : \"value\"}");
        Transaction transaction = graph.beginTx();
        try {
            IndexHits indexResult = database.getIndexManager().getNodeAutoIndexer().getAutoIndex().get("myAutoIndexedProperty", (Object)"value");
            Assert.assertEquals((long)1L, (long)indexResult.size());
        }
        finally {
            transaction.finish();
        }
    }

    private void addRemoveAutoindexProperties(String type) throws JsonParseException {
        Response response = service.getAutoIndexedProperties(type);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        String entity = RestfulGraphDatabaseTest.entityAsString(response);
        List properties = (List)JsonHelper.readJson((String)entity);
        Assert.assertEquals((long)0L, (long)properties.size());
        response = service.startAutoIndexingProperty(type, "myAutoIndexedProperty1");
        Assert.assertEquals((long)204L, (long)response.getStatus());
        response = service.startAutoIndexingProperty(type, "myAutoIndexedProperty2");
        Assert.assertEquals((long)204L, (long)response.getStatus());
        response = service.getAutoIndexedProperties(type);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        entity = RestfulGraphDatabaseTest.entityAsString(response);
        properties = (List)JsonHelper.readJson((String)entity);
        Assert.assertEquals((long)2L, (long)properties.size());
        Assert.assertTrue((boolean)properties.contains("myAutoIndexedProperty1"));
        Assert.assertTrue((boolean)properties.contains("myAutoIndexedProperty2"));
        response = service.stopAutoIndexingProperty(type, "myAutoIndexedProperty2");
        Assert.assertEquals((long)204L, (long)response.getStatus());
        response = service.getAutoIndexedProperties(type);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        entity = RestfulGraphDatabaseTest.entityAsString(response);
        properties = (List)JsonHelper.readJson((String)entity);
        Assert.assertEquals((long)1L, (long)properties.size());
        Assert.assertTrue((boolean)properties.contains("myAutoIndexedProperty1"));
    }

    private void testAutoIndexEnableForType(String type) {
        Response response = service.isAutoIndexerEnabled(type);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertFalse((boolean)Boolean.parseBoolean(RestfulGraphDatabaseTest.entityAsString(response)));
        response = service.setAutoIndexerEnabled(type, "true");
        Assert.assertEquals((long)204L, (long)response.getStatus());
        response = service.isAutoIndexerEnabled(type);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertTrue((boolean)Boolean.parseBoolean(RestfulGraphDatabaseTest.entityAsString(response)));
        response = service.setAutoIndexerEnabled(type, "false");
        Assert.assertEquals((long)204L, (long)response.getStatus());
        response = service.isAutoIndexerEnabled(type);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertFalse((boolean)Boolean.parseBoolean(RestfulGraphDatabaseTest.entityAsString(response)));
    }

    static {
        FORCE = ForceMode.forced;
    }
}

