/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;

public class XForwardFilterIT
extends AbstractRestFunctionalTestBase {
    public static final String X_FORWARDED_HOST = "X-Forwarded-Host";
    public static final String X_FORWARDED_PROTO = "X-Forwarded-Proto";
    private Client client = Client.create();

    @Test
    public void shouldUseXForwardedHostHeaderWhenPresent() throws Exception {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.client.resource("http://localhost:7474/db/manage").accept(new String[]{"application/json"}).header(X_FORWARDED_HOST, (Object)"jimwebber.org")).get(ClientResponse.class);
        String entity = (String)response.getEntity(String.class);
        Assert.assertTrue((boolean)entity.contains("http://jimwebber.org"));
        Assert.assertFalse((boolean)entity.contains("http://localhost"));
    }

    @Test
    public void shouldUseXForwardedProtoHeaderWhenPresent() throws Exception {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.client.resource("http://localhost:7474/db/manage").accept(new String[]{"application/json"}).header(X_FORWARDED_PROTO, (Object)"https")).get(ClientResponse.class);
        String entity = (String)response.getEntity(String.class);
        Assert.assertTrue((boolean)entity.contains("https://localhost"));
        Assert.assertFalse((boolean)entity.contains("http://localhost"));
    }

    @Test
    public void shouldPickFirstXForwardedHostHeaderValueFromCommaOrCommaAndSpaceSeparatedList() throws Exception {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.client.resource("http://localhost:7474/db/manage").accept(new String[]{"application/json"}).header(X_FORWARDED_HOST, (Object)"jimwebber.org, kathwebber.com,neo4j.org")).get(ClientResponse.class);
        String entity = (String)response.getEntity(String.class);
        Assert.assertTrue((boolean)entity.contains("http://jimwebber.org"));
        Assert.assertFalse((boolean)entity.contains("http://localhost"));
    }

    @Test
    public void shouldUseBaseUriOnBadXForwardedHostHeader() throws Exception {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.client.resource("http://localhost:7474/db/manage").accept(new String[]{"application/json"}).header(X_FORWARDED_HOST, (Object)":bad_URI")).get(ClientResponse.class);
        String entity = (String)response.getEntity(String.class);
        Assert.assertTrue((boolean)entity.contains("http://localhost:7474"));
    }

    @Test
    public void shouldUseBaseUriIfFirstAddressInXForwardedHostHeaderIsBad() throws Exception {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.client.resource("http://localhost:7474/db/manage").accept(new String[]{"application/json"}).header(X_FORWARDED_HOST, (Object)":bad_URI,good-host")).get(ClientResponse.class);
        String entity = (String)response.getEntity(String.class);
        Assert.assertTrue((boolean)entity.contains("http://localhost:7474"));
    }

    @Test
    public void shouldUseBaseUriOnBadXForwardedProtoHeader() throws Exception {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.client.resource("http://localhost:7474/db/manage").accept(new String[]{"application/json"}).header(X_FORWARDED_PROTO, (Object)"%%%DEFINITELY-NOT-A-PROTO!")).get(ClientResponse.class);
        String entity = (String)response.getEntity(String.class);
        Assert.assertTrue((boolean)entity.contains("http://localhost:7474"));
    }

    @Test
    public void shouldUseXForwardedHostAndXForwardedProtoHeadersWhenPresent() throws Exception {
        ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)this.client.resource("http://localhost:7474/db/manage").accept(new String[]{"application/json"}).header(X_FORWARDED_HOST, (Object)"jimwebber.org")).header(X_FORWARDED_PROTO, (Object)"https")).get(ClientResponse.class);
        String entity = (String)response.getEntity(String.class);
        Assert.assertTrue((boolean)entity.contains("https://jimwebber.org"));
        Assert.assertFalse((boolean)entity.contains("http://localhost:7474"));
    }
}

