/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security;

import java.io.File;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.server.security.SslCertificateFactory;

public class TestSslCertificateFactory {
    private File cPath;
    private File pkPath;

    @Test
    public void shouldCreateASelfSignedCertificate() throws Exception {
        SslCertificateFactory sslFactory = new SslCertificateFactory();
        sslFactory.createSelfSignedCertificate(this.cPath, this.pkPath, "myhost");
        Certificate[] certificates = sslFactory.loadCertificates(this.cPath);
        Assert.assertThat((Object)certificates.length, (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        PrivateKey pk = sslFactory.loadPrivateKey(this.pkPath);
        Assert.assertThat((Object)pk, (Matcher)Matchers.notNullValue());
    }

    @Before
    public void createFiles() throws Exception {
        this.cPath = File.createTempFile("cert", "test");
        this.pkPath = File.createTempFile("privatekey", "test");
    }

    @After
    public void deleteFiles() throws Exception {
        this.pkPath.delete();
        this.cPath.delete();
    }
}

