/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest;

import java.net.URI;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;
import org.neo4j.server.webadmin.rest.RootService;
import org.neo4j.test.server.EntityOutputFormat;

public class RootServiceDocTest {
    @Test
    public void shouldAdvertiseServicesWhenAsked() throws Exception {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        URI uri = new URI("http://example.org:7474/");
        Mockito.when((Object)uriInfo.getBaseUri()).thenReturn((Object)uri);
        RootService svc = new RootService((NeoServer)new CommunityNeoServer(DevNullLoggingService.DEV_NULL));
        EntityOutputFormat output = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), null, null);
        Response serviceDefinition = svc.getServiceDefinition(uriInfo, (OutputFormat)output);
        Assert.assertEquals((long)200L, (long)serviceDefinition.getStatus());
        Map result = (Map)output.getResultAsMap().get("services");
        Assert.assertThat((Object)result.get("console").toString(), (Matcher)Matchers.containsString((String)String.format("%sserver/console", uri.toString())));
        Assert.assertThat((Object)result.get("jmx").toString(), (Matcher)Matchers.containsString((String)String.format("%sserver/jmx", uri.toString())));
        Assert.assertThat((Object)result.get("monitor").toString(), (Matcher)Matchers.containsString((String)String.format("%sserver/monitor", uri.toString())));
    }
}

