/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest.representations;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.server.database.Database;
import org.neo4j.server.webadmin.rest.console.ConsoleService;
import org.neo4j.server.webadmin.rest.representations.ServerRootRepresentation;

public class ServerRootRepresentationTest {
    @Test
    public void shouldProvideAListOfServiceUris() throws Exception {
        ConsoleService consoleService = new ConsoleService(null, this.mockDatabase(), DevNullLoggingService.DEV_NULL, null);
        ServerRootRepresentation srr = new ServerRootRepresentation(new URI("http://example.org:9999"), Collections.singletonList(consoleService));
        Map map = srr.serialize();
        Assert.assertNotNull(map.get("services"));
        Assert.assertThat(((Map)map.get("services")).get(consoleService.getName()), (Matcher)Matchers.containsString((String)consoleService.getServerPath()));
    }

    private Database mockDatabase() {
        Database db = (Database)Mockito.mock(Database.class);
        Mockito.when((Object)db.getLogging()).thenReturn((Object)DevNullLoggingService.DEV_NULL);
        return db;
    }
}

