/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.test.TestData;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.HTTP;

public class HttpsEnabledDocIT
extends ExclusiveServerTestBase {
    private CommunityNeoServer server;
    @Rule
    public TestData<RESTDocsGenerator> gen = TestData.producedThrough(RESTDocsGenerator.PRODUCER);

    @After
    public void stopTheServer() {
        this.server.stop();
    }

    @Test
    public void serverShouldSupportSsl() throws Exception {
        this.server = CommunityServerBuilder.server().withHttpsEnabled().usingDatabaseDir(this.folder.getRoot().getAbsolutePath()).build();
        this.server.start();
        Assert.assertThat((Object)this.server.getHttpsEnabled(), (Matcher)Matchers.is((Object)true));
        this.trustAllSslCerts();
        Assert.assertThat((Object)HTTP.GET(this.server.httpsUri().toASCIIString()).status(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void webadminShouldBeRetrievableViaSsl() throws Exception {
        this.server = CommunityServerBuilder.server().withHttpsEnabled().usingDatabaseDir(this.folder.getRoot().getAbsolutePath()).build();
        this.server.start();
        Assert.assertThat((Object)this.server.getHttpsEnabled(), (Matcher)Matchers.is((Object)true));
        this.trustAllSslCerts();
        Assert.assertThat((Object)HTTP.GET(this.server.httpsUri().toASCIIString() + "webadmin/").status(), (Matcher)Matchers.is((Object)200));
    }

    private void trustAllSslCerts() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

