/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellLobby;
import org.neo4j.shell.ShellSettings;
import org.neo4j.test.TargetDirectory;

public class NeoServerShellConfigIT {
    @Rule
    public TargetDirectory.TestDirectory testDir = TargetDirectory.cleanTestDirForTest(this.getClass());

    @Test
    public void shouldBeAbleToOverrideShellConfig() throws Throwable {
        final int customPort = this.findFreeShellPortToUse(8881);
        CommunityNeoServer server = new CommunityNeoServer((Configurator)new Configurator.Adapter(){

            public Configuration configuration() {
                return new MapConfiguration(MapUtil.stringMap((String[])new String[]{"org.neo4j.server.database.location", NeoServerShellConfigIT.this.testDir.absolutePath()}));
            }

            public Map<String, String> getDatabaseTuningProperties() {
                return MapUtil.stringMap((String[])new String[]{ShellSettings.remote_shell_enabled.name(), "true", ShellSettings.remote_shell_port.name(), "" + customPort});
            }
        });
        server.start();
        ShellLobby.newClient((int)customPort).shutdown();
        server.stop();
    }

    @Test
    public void connectWithShellOnDefaultPortWhenNoShellConfigSupplied() throws Throwable {
        CommunityNeoServer server = new CommunityNeoServer((Configurator)new Configurator.Adapter(){

            public Configuration configuration() {
                return new MapConfiguration(MapUtil.stringMap((String[])new String[]{"org.neo4j.server.database.location", NeoServerShellConfigIT.this.testDir.absolutePath()}));
            }

            public Map<String, String> getDatabaseTuningProperties() {
                return MapUtil.stringMap((String[])new String[0]);
            }
        });
        server.start();
        ShellLobby.newClient().shutdown();
        server.stop();
    }

    private int findFreeShellPortToUse(int startingPort) {
        try {
            while (true) {
                ShellLobby.newClient((int)startingPort++).shutdown();
            }
        }
        catch (ShellException e) {
            return startingPort;
        }
    }
}

