/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Random;

public class ServerTestUtils {
    public static File createTempDir() throws IOException {
        File d = File.createTempFile("neo4j-test", "dir");
        if (!d.delete()) {
            throw new RuntimeException("temp config directory pre-delete failed");
        }
        if (!d.mkdirs()) {
            throw new RuntimeException("temp config directory not created");
        }
        d.deleteOnExit();
        return d;
    }

    public static File createTempPropertyFile() throws IOException {
        File file = File.createTempFile("neo4j", "properties");
        file.delete();
        return file;
    }

    public static void writePropertiesToFile(String outerPropertyName, Map<String, String> properties, File propertyFile) {
        ServerTestUtils.writePropertyToFile(outerPropertyName, ServerTestUtils.asOneLine(properties), propertyFile);
    }

    public static void writePropertiesToFile(Map<String, String> properties, File propertyFile) {
        Properties props = ServerTestUtils.loadProperties(propertyFile);
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            props.setProperty(entry.getKey(), entry.getValue());
        }
        ServerTestUtils.storeProperties(propertyFile, props);
    }

    public static String asOneLine(Map<String, String> properties) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> property : properties.entrySet()) {
            builder.append(builder.length() > 0 ? "," : "");
            builder.append(property.getKey() + "=" + property.getValue());
        }
        return builder.toString();
    }

    public static void writePropertyToFile(String name, String value, File propertyFile) {
        Properties properties = ServerTestUtils.loadProperties(propertyFile);
        properties.setProperty(name, value);
        ServerTestUtils.storeProperties(propertyFile, properties);
    }

    private static void storeProperties(File propertyFile, Properties properties) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(propertyFile);
            properties.store(out, "");
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ServerTestUtils.safeClose(out);
                throw throwable;
            }
        }
        ServerTestUtils.safeClose(out);
    }

    private static Properties loadProperties(File propertyFile) {
        Properties properties = new Properties();
        if (propertyFile.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(propertyFile);
                properties.load(in);
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    ServerTestUtils.safeClose(in);
                    throw throwable;
                }
            }
            ServerTestUtils.safeClose(in);
        }
        return properties;
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static File createTempPropertyFile(File parentDir) throws IOException {
        File file = new File(parentDir, "test-" + new Random().nextInt() + ".properties");
        file.deleteOnExit();
        return file;
    }
}

