/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.server.configuration.DatabaseTuningPropertyFileBuilder;
import org.neo4j.server.configuration.PropertyFileBuilder;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.server.logging.InMemoryAppender;
import org.neo4j.test.Mute;

public class PropertyFileConfiguratorTest {
    @Rule
    public Mute mute = Mute.muteAll();
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void whenDatabaseTuningFilePresentInDefaultLocationShouldLoadItEvenIfNotSpecified() throws IOException {
        File emptyPropertyFile = PropertyFileBuilder.builder(this.folder.getRoot()).build();
        DatabaseTuningPropertyFileBuilder.builder(this.folder.getRoot()).build();
        PropertyFileConfigurator configurator = new PropertyFileConfigurator(emptyPropertyFile);
        Assert.assertNotNull(configurator.getDatabaseTuningProperties().get("neostore.nodestore.db.mapped_memory"));
        Assert.assertEquals((Object)"25M", configurator.getDatabaseTuningProperties().get("neostore.nodestore.db.mapped_memory"));
    }

    @Test
    public void whenDatabaseTuningFilePresentInDefaultLocationShouldNotLoadIfAnotherSpecified() throws IOException {
        int unlikelyDefaultMemoryMappedValue = 8351;
        File databaseTuningPropertyFileWeWantToUse = DatabaseTuningPropertyFileBuilder.builder(this.folder.getRoot()).mappedMemory(unlikelyDefaultMemoryMappedValue).build();
        File emptyPropertyFile = PropertyFileBuilder.builder(this.folder.getRoot()).withDbTuningPropertyFile(databaseTuningPropertyFileWeWantToUse).build();
        DatabaseTuningPropertyFileBuilder.builder(this.folder.newFolder()).build();
        PropertyFileConfigurator configurator = new PropertyFileConfigurator(emptyPropertyFile);
        Assert.assertNotNull(configurator.getDatabaseTuningProperties().get("neostore.nodestore.db.mapped_memory"));
        Assert.assertEquals((Object)(String.valueOf(unlikelyDefaultMemoryMappedValue) + "M"), configurator.getDatabaseTuningProperties().get("neostore.nodestore.db.mapped_memory"));
    }

    @Test
    public void shouldLogInfoWhenDefaultingToTuningPropertiesFileInTheSameDirectoryAsTheNeoServerPropertiesFile() throws IOException {
        File emptyPropertyFile = PropertyFileBuilder.builder(this.folder.getRoot()).build();
        File tuningPropertiesFile = DatabaseTuningPropertyFileBuilder.builder(this.folder.getRoot()).build();
        InMemoryAppender appender = new InMemoryAppender(PropertyFileConfigurator.log);
        new PropertyFileConfigurator(emptyPropertyFile);
        String actual = appender.toString();
        String content = String.format(": No database tuning file explicitly set, defaulting to [%s]", tuningPropertiesFile.getAbsolutePath());
        Assert.assertTrue((String)"Expected log message to contain hint about missing tuning file being replaced with defaults", (actual.contains("INFO" + content) || actual.contains("Information" + content) || actual.contains("Info" + content) ? 1 : 0) != 0);
    }

    @Test
    public void shouldRetainRegistrationOrderOfThirdPartyJaxRsPackages() throws IOException {
        File propertyFile = PropertyFileBuilder.builder(this.folder.getRoot()).withNameValue("org.neo4j.server.thirdparty_jaxrs_classes", "org.neo4j.extension.extension1=/extension1,org.neo4j.extension.extension2=/extension2,org.neo4j.extension.extension3=/extension3").build();
        PropertyFileConfigurator propertyFileConfigurator = new PropertyFileConfigurator(propertyFile);
        List thirdpartyJaxRsPackages = propertyFileConfigurator.getThirdpartyJaxRsPackages();
        Assert.assertEquals((long)3L, (long)thirdpartyJaxRsPackages.size());
        Assert.assertEquals((Object)"/extension1", (Object)((ThirdPartyJaxRsPackage)thirdpartyJaxRsPackages.get(0)).getMountPoint());
        Assert.assertEquals((Object)"/extension2", (Object)((ThirdPartyJaxRsPackage)thirdpartyJaxRsPackages.get(1)).getMountPoint());
        Assert.assertEquals((Object)"/extension3", (Object)((ThirdPartyJaxRsPackage)thirdpartyJaxRsPackages.get(2)).getMountPoint());
    }
}

