/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.database;

import java.io.File;
import java.util.Map;
import junit.framework.TestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Functions;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.impl.util.TestLogger;
import org.neo4j.kernel.impl.util.TestLogging;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.server.NeoServerSettings;
import org.neo4j.server.configuration.ConfigDatabase;
import org.neo4j.server.database.DatabaseDefinition;
import org.neo4j.server.database.DatabaseHosting;
import org.neo4j.server.database.DatabaseRegistry;
import org.neo4j.server.database.LifecycleManagingDatabase;
import org.neo4j.test.TargetDirectory;

public class DatabaseHostingIT {
    @Rule
    public TargetDirectory.TestDirectory testDir = TargetDirectory.cleanTestDirForTest(this.getClass());
    private LifeSupport life = new LifeSupport();
    private TestLogging logging = new TestLogging();
    private DatabaseRegistry registry;
    private DatabaseHosting host;
    private ConfigDatabase configDb;
    private Config serverConfig;

    @Test
    public void shouldLoadDatabasesFromConfigDb() throws Throwable {
        this.createHosting();
        this.host.newDatabase("somekey", "single", DatabaseHosting.Mode.EXTERNAL, new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.store_dir.name(), this.testDir.absolutePath() + "/nomatter"})));
        TestCase.assertTrue((boolean)this.registry.contains("somekey"));
        TestCase.assertTrue((boolean)new File(this.testDir.directory(), "nomatter").exists());
        this.restartHosting();
        TestCase.assertTrue((boolean)this.registry.contains("somekey"));
    }

    @Test
    public void shouldDeleteManagedDatabases() throws Exception {
        this.createHosting();
        this.host.newDatabase("somekey", "single", DatabaseHosting.Mode.MANAGED, new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.store_dir.name(), this.testDir.absolutePath() + "/nomatter"})));
        this.host.dropDatabase("somekey");
        TestCase.assertFalse((boolean)this.registry.contains("somekey"));
        TestCase.assertFalse((boolean)new File(this.testDir.directory(), "nomatter").exists());
        this.restartHosting();
        TestCase.assertFalse((boolean)this.registry.contains("somekey"));
        TestCase.assertFalse((boolean)new File(this.testDir.directory(), "nomatter").exists());
    }

    @Test
    public void shouldKeepFilesForExternalDatabases() throws Exception {
        this.createHosting();
        this.host.newDatabase("somekey", "single", DatabaseHosting.Mode.EXTERNAL, new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.store_dir.name(), this.testDir.absolutePath() + "/nomatter"})));
        this.host.dropDatabase("somekey");
        TestCase.assertFalse((boolean)this.registry.contains("somekey"));
        TestCase.assertTrue((boolean)new File(this.testDir.directory(), "nomatter").exists());
        this.restartHosting();
        TestCase.assertFalse((boolean)this.registry.contains("somekey"));
        TestCase.assertTrue((boolean)new File(this.testDir.directory(), "nomatter").exists());
    }

    @Test
    public void shouldCreateADatabaseNamedDBOnFreshSlateStartup() throws Exception {
        this.createHosting();
        DatabaseDefinition db = (DatabaseDefinition)Iterables.single((Iterable)this.configDb.listDatabases());
        junit.framework.Assert.assertEquals((String)"db", (String)db.key());
        junit.framework.Assert.assertEquals((String)new File(this.testDir.directory(), "data/graph.db").getAbsolutePath(), (String)db.path().getAbsolutePath());
        this.host.dropDatabase("db");
        this.restartHosting();
        Assert.assertThat((Object)Iterables.count((Iterable)this.configDb.listDatabases()), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void legacyDbConfigOverridesRuntimeConfig() throws Exception {
        Map cfg = this.serverConfig.getParams();
        File propertiesFile = new File(this.testDir.directory(), "cfg.properties");
        cfg.put(NeoServerSettings.legacy_db_config.name(), propertiesFile.getAbsolutePath());
        this.serverConfig.applyChanges(cfg);
        MapUtil.store((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.cache_type.name(), "none"}), (File)propertiesFile);
        this.restartHosting();
        junit.framework.Assert.assertEquals((String)"none", (String)((String)((DatabaseDefinition)Iterables.single((Iterable)this.configDb.listDatabases())).config().get(GraphDatabaseSettings.cache_type)));
    }

    @Test
    public void shouldNotClearLegacyRuntimeConfigIfNoConfigFileExists() throws Exception {
        Map cfg = this.serverConfig.getParams();
        File propertiesFile = new File(this.testDir.directory(), "cfg.properties");
        cfg.put(NeoServerSettings.legacy_db_config.name(), propertiesFile.getAbsolutePath());
        this.serverConfig.applyChanges(cfg);
        this.createHosting();
        this.host.reconfigureDatabase("db", new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.cache_type.name(), "weak"})));
        this.restartHosting();
        junit.framework.Assert.assertEquals((String)"weak", (String)((String)((DatabaseDefinition)Iterables.single((Iterable)this.configDb.listDatabases())).config().get(GraphDatabaseSettings.cache_type)));
    }

    @Test
    public void shouldBeAbleToSetDatabaseProvider() throws Exception {
        this.createHosting();
        this.host.newDatabase("mydb", "single", DatabaseHosting.Mode.EXTERNAL, new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.store_dir.name(), this.testDir.absolutePath() + "/nomatter"})));
        this.host.changeDatabaseProvider("mydb", "someOtherProvider");
        junit.framework.Assert.assertEquals((String)"someOtherProvider", (String)this.configDb.getDatabase("mydb").provider());
    }

    @Test
    public void dbWithUnknownProviderShouldNotStopServerFromStarting() throws Exception {
        this.createHosting();
        this.configDb.newDatabase("lol", "doesntexist", DatabaseHosting.Mode.EXTERNAL, new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.store_dir.name(), this.testDir.absolutePath() + "/nomatter"})));
        this.restartHosting();
        this.logging.getMessagesLog(DatabaseHosting.class).assertExactly(new TestLogger.LogCall[]{TestLogger.LogCall.error((String)"Unable to start database 'lol', because there is no database provider called 'doesntexist', which this database has been configured to use.")});
    }

    private void restartHosting() {
        this.life.shutdown();
        this.life = new LifeSupport();
        this.createHosting();
    }

    private void createHosting() {
        this.registry = (DatabaseRegistry)this.life.add((Object)this.registry());
        this.configDb = (ConfigDatabase)this.life.add((Object)new ConfigDatabase(this.registry, this.serverConfig));
        this.host = (DatabaseHosting)this.life.add((Object)new DatabaseHosting(this.registry, this.configDb, (StringLogger)this.logging.getMessagesLog(DatabaseHosting.class)));
        this.life.start();
    }

    @Before
    public void setup() {
        this.serverConfig = new Config(MapUtil.stringMap((String[])new String[]{NeoServerSettings.config_db_path.name(), new File(this.testDir.directory(), "/__config__.db").getAbsolutePath(), NeoServerSettings.legacy_db_location.name(), new File(this.testDir.directory(), "/data/graph.db").getAbsolutePath()}));
    }

    @After
    public void shutdown() {
        this.life.shutdown();
        this.life = new LifeSupport();
    }

    private DatabaseRegistry registry() {
        DatabaseRegistry registry = new DatabaseRegistry(Functions.constant((Object)this.logging));
        registry.addProvider("single", LifecycleManagingDatabase.lifecycleManagingDatabase((LifecycleManagingDatabase.GraphFactory)LifecycleManagingDatabase.EMBEDDED));
        registry.addProvider("someOtherProvider", LifecycleManagingDatabase.lifecycleManagingDatabase((LifecycleManagingDatabase.GraphFactory)LifecycleManagingDatabase.EMBEDDED));
        return registry;
    }
}

