/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.database;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Functions;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.TestLogging;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.DatabaseDefinition;
import org.neo4j.server.database.DatabaseHosting;
import org.neo4j.server.database.DatabaseRegistry;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.OtherThreadRule;

public class DatabaseRegistryTest {
    private static final String EMBEDDED = "embedded";
    private final Database northwind = (Database)Mockito.mock(Database.class);
    @Rule
    public OtherThreadRule<Object> threadOne = new OtherThreadRule();
    @Rule
    public OtherThreadRule<Object> threadTwo = new OtherThreadRule();

    @Test
    public void shouldAllowCreatingAndVisitingDatabase() throws Throwable {
        DatabaseRegistry registry = this.newRegistryWithEmbeddedProvider();
        final AtomicReference dbProvidedToVisitor = new AtomicReference();
        registry.create(new DatabaseDefinition("northwind", EMBEDDED, DatabaseHosting.Mode.EXTERNAL, new Config()));
        registry.visit("northwind", new DatabaseRegistry.Visitor(){

            public void visit(Database db) {
                dbProvidedToVisitor.set(db);
            }
        });
        Assert.assertThat(dbProvidedToVisitor.get(), (Matcher)CoreMatchers.equalTo((Object)this.northwind));
        ((Database)Mockito.verify((Object)this.northwind)).init();
        ((Database)Mockito.verify((Object)this.northwind)).start();
    }

    @Test
    public void shouldShutdownDatabaseOnDrop() throws Throwable {
        DatabaseRegistry registry = this.newRegistryWithEmbeddedProvider();
        registry.create(new DatabaseDefinition("northwind", EMBEDDED, DatabaseHosting.Mode.EXTERNAL, new Config()));
        registry.drop("northwind");
        ((Database)Mockito.verify((Object)this.northwind)).init();
        ((Database)Mockito.verify((Object)this.northwind)).start();
        ((Database)Mockito.verify((Object)this.northwind)).stop();
        ((Database)Mockito.verify((Object)this.northwind)).shutdown();
    }

    @Test
    public void shouldAwaitRunningQueriesBeforeDropping() throws Throwable {
        DatabaseRegistry registry = this.newRegistryWithEmbeddedProvider();
        registry.create(new DatabaseDefinition("northwind", EMBEDDED, DatabaseHosting.Mode.EXTERNAL, new Config()));
        CountDownLatch visitingDbLatch = new CountDownLatch(1);
        this.threadOne.execute(this.visitAndAwaitLatch("northwind", registry, visitingDbLatch));
        Future threadTwoCompletion = this.threadTwo.execute(this.drop("northwind", registry));
        Thread.sleep(100L);
        ((Database)Mockito.verify((Object)this.northwind, (VerificationMode)Mockito.never())).stop();
        ((Database)Mockito.verify((Object)this.northwind, (VerificationMode)Mockito.never())).shutdown();
        visitingDbLatch.countDown();
        threadTwoCompletion.get(10L, TimeUnit.SECONDS);
        ((Database)Mockito.verify((Object)this.northwind)).stop();
        ((Database)Mockito.verify((Object)this.northwind)).shutdown();
    }

    private OtherThreadExecutor.WorkerCommand<Object, Object> drop(final String dbKey, final DatabaseRegistry registry) {
        return new OtherThreadExecutor.WorkerCommand<Object, Object>(){

            public Object doWork(Object state) throws Exception {
                registry.drop(dbKey);
                return null;
            }
        };
    }

    private OtherThreadExecutor.WorkerCommand<Object, Object> visitAndAwaitLatch(final String dbKey, final DatabaseRegistry registry, final CountDownLatch latchToAwait) {
        return new OtherThreadExecutor.WorkerCommand<Object, Object>(){

            public Object doWork(Object state) throws Exception {
                registry.visit(dbKey, new DatabaseRegistry.Visitor(){

                    public void visit(Database db) {
                        try {
                            latchToAwait.await(10L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                return null;
            }
        };
    }

    private DatabaseRegistry newRegistryWithEmbeddedProvider() {
        DatabaseRegistry registry = new DatabaseRegistry(Functions.constant((Object)new TestLogging()));
        registry.addProvider(EMBEDDED, DatabaseRegistryTest.singletonDatabase(this.northwind));
        registry.init();
        registry.start();
        return registry;
    }

    public static Database.Factory singletonDatabase(final Database db) {
        return new Database.Factory(){

            public Database newDatabase(Config config, Function<Config, Logging> loggingProvider) {
                return db;
            }
        };
    }
}

