/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.database;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Functions;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.TestLogging;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.LifecycleManagingDatabase;
import org.neo4j.server.logging.InMemoryAppender;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.test.Mute;

public class TestLifecycleManagedDatabase {
    @Rule
    public Mute mute = Mute.muteAll();
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();
    private File databaseDirectory;
    private Database theDatabase;
    private boolean deletionFailureOk;
    private LifecycleManagingDatabase.GraphFactory dbFactory;

    @Before
    public void setup() throws Exception {
        this.databaseDirectory = ServerTestUtils.createTempDir();
        this.dbFactory = (LifecycleManagingDatabase.GraphFactory)Mockito.mock(LifecycleManagingDatabase.GraphFactory.class);
        Mockito.when((Object)this.dbFactory.newGraphDatabase((Config)Mockito.any(Config.class), (Function)Mockito.any(Function.class), (Iterable)Mockito.any(Iterable.class), (Iterable)Mockito.any(Iterable.class), (Iterable)Mockito.any(Iterable.class))).thenReturn((Object)this.dbRule.getGraphDatabaseAPI());
        this.theDatabase = this.newDatabase();
    }

    private LifecycleManagingDatabase newDatabase() {
        Config dbConfig = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.store_dir.name(), this.databaseDirectory.getAbsolutePath()}));
        return new LifecycleManagingDatabase(dbConfig, this.dbFactory, Functions.constant((Object)new TestLogging()));
    }

    @After
    public void shutdownDatabase() throws Throwable {
        block2: {
            this.theDatabase.stop();
            try {
                FileUtils.forceDelete((File)this.databaseDirectory);
            }
            catch (IOException e) {
                if (this.deletionFailureOk) break block2;
                throw e;
            }
        }
    }

    @Test
    public void shouldLogOnSuccessfulStartup() throws Throwable {
        InMemoryAppender appender = new InMemoryAppender(LifecycleManagingDatabase.log);
        this.theDatabase.start();
        Assert.assertThat((Object)appender.toString(), (Matcher)Matchers.containsString((String)"Successfully started database"));
    }

    @Test
    public void shouldShutdownCleanly() throws Throwable {
        InMemoryAppender appender = new InMemoryAppender(LifecycleManagingDatabase.log);
        this.theDatabase.start();
        this.theDatabase.stop();
        Assert.assertThat((Object)appender.toString(), (Matcher)Matchers.containsString((String)"Successfully stopped database"));
    }

    @Test
    public void shouldComplainIfDatabaseLocationIsAlreadyInUse() throws Throwable {
        this.deletionFailureOk = true;
        this.theDatabase.start();
        LifecycleManagingDatabase db = this.newDatabase();
        try {
            db.start();
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)e.getCause().getCause(), (Matcher)IsInstanceOf.instanceOf(StoreLockException.class));
        }
    }

    @Test
    public void shouldBeAbleToGetLocation() throws Throwable {
        this.theDatabase.start();
        Assert.assertThat((Object)this.theDatabase.getLocation(), (Matcher)Matchers.is((Object)this.databaseDirectory.getAbsolutePath()));
    }
}

