/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional.integration;

import java.util.HashSet;
import java.util.Iterator;
import org.codehaus.jackson.JsonNode;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.transactional.integration.TransactionMatchers;
import org.neo4j.test.server.HTTP;
import org.neo4j.tooling.GlobalGraphOperations;

public class TransactionIT
extends AbstractRestFunctionalTestBase {
    private final HTTP.Builder http = HTTP.withBaseUri("http://localhost:7474");

    @Test
    public void begin__execute__commit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response begin = this.http.POST("/db/data/transaction");
        MatcherAssert.assertThat((Object)begin.status(), (Matcher)CoreMatchers.equalTo((Object)201));
        MatcherAssert.assertThat((Object)begin.location(), TransactionMatchers.matches("http://localhost:\\d+/db/data/transaction/\\d+"));
        String commitResource = begin.stringFromContent("commit");
        MatcherAssert.assertThat((Object)commitResource, TransactionMatchers.matches("http://localhost:\\d+/db/data/transaction/\\d+/commit"));
        MatcherAssert.assertThat((Object)begin.get("transaction").get("expires").asText(), TransactionMatchers.isValidRFCTimestamp());
        HTTP.Response execute = this.http.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE n' } ] }"));
        MatcherAssert.assertThat((Object)execute.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)execute.get("transaction").get("expires").asText(), TransactionMatchers.isValidRFCTimestamp());
        HTTP.Response commit = this.http.POST(commitResource);
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.countNodes(), (Matcher)CoreMatchers.equalTo((Object)(nodesInDatabaseBeforeTransaction + 1L)));
    }

    @Test
    public void begin__execute__rollback() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response begin = this.http.POST("/db/data/transaction");
        MatcherAssert.assertThat((Object)begin.status(), (Matcher)CoreMatchers.equalTo((Object)201));
        MatcherAssert.assertThat((Object)begin.location(), TransactionMatchers.matches("http://localhost:\\d+/db/data/transaction/\\d+"));
        this.http.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE n' } ] }"));
        HTTP.Response commit = this.http.DELETE(begin.location());
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.countNodes(), (Matcher)CoreMatchers.equalTo((Object)nodesInDatabaseBeforeTransaction));
    }

    @Test
    public void begin__execute_and_commit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response begin = this.http.POST("/db/data/transaction");
        MatcherAssert.assertThat((Object)begin.status(), (Matcher)CoreMatchers.equalTo((Object)201));
        MatcherAssert.assertThat((Object)begin.location(), (Matcher)CoreMatchers.containsString((String)"/db/data/transaction"));
        String commitResource = begin.stringFromContent("commit");
        MatcherAssert.assertThat((Object)commitResource, (Matcher)CoreMatchers.equalTo((Object)(begin.location() + "/commit")));
        HTTP.Response commit = this.http.POST(commitResource, HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE n' } ] }"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.countNodes(), (Matcher)CoreMatchers.equalTo((Object)(nodesInDatabaseBeforeTransaction + 1L)));
    }

    @Test
    public void begin_and_execute__commit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response begin = this.http.POST("/db/data/transaction", HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE n' } ] }"));
        String commitResource = begin.stringFromContent("commit");
        HTTP.Response commit = this.http.POST(commitResource);
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.countNodes(), (Matcher)CoreMatchers.equalTo((Object)(nodesInDatabaseBeforeTransaction + 1L)));
    }

    @Test
    public void begin__execute__commit__execute() throws Exception {
        HTTP.Response begin = this.http.POST("/db/data/transaction");
        String commitResource = begin.stringFromContent("commit");
        this.http.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE n' } ] }"));
        this.http.POST(commitResource);
        HTTP.Response execute = this.http.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE n' } ] }"));
        MatcherAssert.assertThat((Object)execute.status(), (Matcher)CoreMatchers.equalTo((Object)404));
        MatcherAssert.assertThat((Object)execute, TransactionMatchers.hasErrors(new Status[]{Status.Transaction.UnknownId}));
    }

    @Test
    public void begin_and_execute_and_commit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response begin = this.http.POST("/db/data/transaction/commit", HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE n' } ] }"));
        MatcherAssert.assertThat((Object)begin.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.countNodes(), (Matcher)CoreMatchers.equalTo((Object)(nodesInDatabaseBeforeTransaction + 1L)));
    }

    @Test
    public void begin_and_execute_periodic_commit_and_commit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response response = this.http.POST("/db/data/transaction/commit", HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'USING PERIODIC COMMIT CREATE ()' } ] }"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)this.countNodes(), (Matcher)CoreMatchers.equalTo((Object)(nodesInDatabaseBeforeTransaction + 1L)));
    }

    @Test
    public void begin_and_execute_periodic_commit_that_returns_data_and_commit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response response = this.http.POST("/db/data/transaction/commit", HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'USING PERIODIC COMMIT CREATE (n {id: 23}) RETURN n' } ] }"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response, TransactionMatchers.containsNoErrors());
        JsonNode columns = response.get("results").get(0).get("columns");
        MatcherAssert.assertThat((Object)columns.toString(), (Matcher)CoreMatchers.equalTo((Object)"[\"n\"]"));
        MatcherAssert.assertThat((Object)this.countNodes(), (Matcher)CoreMatchers.equalTo((Object)(nodesInDatabaseBeforeTransaction + 1L)));
    }

    @Test
    public void begin_and_execute_periodic_commit_followed_by_another_statement_and_commit() throws Exception {
        HTTP.Response response = this.http.POST("/db/data/transaction/commit", HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'USING PERIODIC COMMIT CREATE (n {id: 23}) RETURN n' }, { 'statement': 'RETURN 1' } ] }"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response, TransactionMatchers.hasErrors(new Status[]{Status.Statement.InvalidSemantics}));
    }

    @Test
    public void begin_and_execute_invalid_query_and_commit() throws Exception {
        HTTP.Response response = this.http.POST("/db/data/transaction/commit", HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'MATCH n RETURN m' } ] }"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response, TransactionMatchers.hasErrors(new Status[]{Status.Statement.InvalidSyntax}));
    }

    @Test
    public void begin_and_execute_multiple_periodic_commit_last_and_commit() throws Exception {
        HTTP.Response response = this.http.POST("/db/data/transaction/commit", HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE ()' }, { 'statement': 'USING PERIODIC COMMIT CREATE ()' } ] }"));
        MatcherAssert.assertThat((Object)response, TransactionMatchers.hasErrors(new Status[]{Status.Statement.InvalidSemantics}));
    }

    @Test
    public void begin__execute__execute_and_periodic_commit() throws Exception {
        HTTP.Response begin = this.http.POST("/db/data/transaction");
        this.http.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE ()' } ] }"));
        HTTP.Response response = this.http.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'USING PERIODIC COMMIT CREATE ()' } ] }"));
        MatcherAssert.assertThat((Object)response, TransactionMatchers.hasErrors(new Status[]{Status.Statement.InvalidSemantics}));
    }

    @Test
    public void begin_and_execute_periodic_commit__commit() throws Exception {
        HTTP.Response begin = this.http.POST("/db/data/transaction", HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'USING PERIODIC COMMIT CREATE ()' } ] }"));
        MatcherAssert.assertThat((Object)begin, TransactionMatchers.hasErrors(new Status[]{Status.Statement.InvalidSemantics}));
    }

    @Test
    public void begin__execute_multiple__commit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response begin = this.http.POST("/db/data/transaction");
        String commitResource = begin.stringFromContent("commit");
        this.http.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE n' }, { 'statement': 'CREATE n' } ] }"));
        MatcherAssert.assertThat((Object)this.http.POST(commitResource), TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)this.countNodes(), (Matcher)CoreMatchers.equalTo((Object)(nodesInDatabaseBeforeTransaction + 2L)));
    }

    @Test
    public void begin__execute__execute__commit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response begin = this.http.POST("/db/data/transaction");
        String commitResource = begin.stringFromContent("commit");
        this.http.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE n' } ] }"));
        this.http.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE n' } ] }"));
        this.http.POST(commitResource);
        MatcherAssert.assertThat((Object)this.countNodes(), (Matcher)CoreMatchers.equalTo((Object)(nodesInDatabaseBeforeTransaction + 2L)));
    }

    @Test
    public void begin_create_two_nodes_delete_one() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response response = this.http.POST("/db/data/transaction/commit", HTTP.RawPayload.rawPayload("{ \"statements\" : [{\"statement\" : \"CREATE (n0:DecibelEntity :AlbumGroup{DecibelID : '34a2201b-f4a9-420f-87ae-00a9c691cc5c', Title : 'Dance With Me', ArtistString : 'Ra Ra Riot', MainArtistAlias : 'Ra Ra Riot', OriginalReleaseDate : '2013-01-08', IsCanon : 'False'}) return id(n0)\"}, {\"statement\" : \"CREATE (n1:DecibelEntity :AlbumRelease{DecibelID : '9ed529fa-7c19-11e2-be78-bcaec5bea3c3', Title : 'Dance With Me', ArtistString : 'Ra Ra Riot', MainArtistAlias : 'Ra Ra Riot', LabelName : 'Barsuk Records', FormatNames : 'File', TrackCount : '3', MediaCount : '1', Duration : '460.000000', ReleaseDate : '2013-01-08', ReleaseYear : '2013', ReleaseRegion : 'USA', Cline : 'Barsuk Records', Pline : 'Barsuk Records', CYear : '2013', PYear : '2013', ParentalAdvisory : 'False', IsLimitedEdition : 'False'}) return id(n1)\"}]}"));
        Assert.assertEquals((long)200L, (long)response.status());
        JsonNode everything = JsonHelper.jsonNode((String)response.rawContent());
        JsonNode result = everything.get("results").get(0);
        long id = result.get("data").get(0).get("row").get(0).getLongValue();
        this.http.POST("/db/data/cypher", HTTP.RawPayload.rawPayload("{\"query\":\"start n = node(" + id + ") delete n\"}"));
        MatcherAssert.assertThat((Object)this.countNodes(), (Matcher)CoreMatchers.equalTo((Object)(nodesInDatabaseBeforeTransaction + 1L)));
    }

    @Test
    public void should_include_graph_format_when_requested() throws Exception {
        this.http.POST("/db/data/transaction/commit", this.singleStatement("CREATE (n:Foo:Bar)"));
        HTTP.Response response = this.http.POST("/db/data/transaction/commit", HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'MATCH (n:Foo) RETURN n', 'resultDataContents':['row','graph'] } ] }"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        JsonNode data = response.get("results").get(0).get("data");
        Assert.assertTrue((String)"data is a list", (boolean)data.isArray());
        Assert.assertEquals((String)"one entry", (long)1L, (long)data.size());
        JsonNode entry = data.get(0);
        Assert.assertTrue((String)"entry has row", (boolean)entry.has("row"));
        Assert.assertTrue((String)"entry has graph", (boolean)entry.has("graph"));
        JsonNode nodes = entry.get("graph").get("nodes");
        JsonNode rels = entry.get("graph").get("relationships");
        Assert.assertTrue((String)"nodes is a list", (boolean)nodes.isArray());
        Assert.assertTrue((String)"relationships is a list", (boolean)rels.isArray());
        Assert.assertEquals((String)"one node", (long)1L, (long)nodes.size());
        Assert.assertEquals((String)"no relationships", (long)0L, (long)rels.size());
        HashSet<String> labels = new HashSet<String>();
        for (JsonNode node : nodes.get(0).get("labels")) {
            labels.add(node.getTextValue());
        }
        Assert.assertEquals((String)"labels", (Object)IteratorUtil.asSet((Object[])new String[]{"Foo", "Bar"}), labels);
    }

    @Test
    public void should_serialize_collect_correctly() throws Exception {
        this.http.POST("/db/data/transaction/commit", this.singleStatement("CREATE (n:Foo)"));
        HTTP.Response response = this.http.POST("/db/data/transaction/commit", HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'MATCH (n:Foo) RETURN COLLECT(n)' } ] }"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        JsonNode data = response.get("results").get(0);
        MatcherAssert.assertThat((Object)data.get("columns").get(0).asText(), (Matcher)CoreMatchers.equalTo((Object)"COLLECT(n)"));
        MatcherAssert.assertThat((Object)data.get("data").get(0).get("row").size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)data.get("data").get(0).get("row").get(0).get(0).size(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)response.get("errors").size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void shouldSerializeMapsCorrectlyInRowsFormat() throws Exception {
        HTTP.Response response = this.http.POST("/db/data/transaction/commit", HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'RETURN {one:{two:[true, {three: 42}]}}' } ] }"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        JsonNode data = response.get("results").get(0);
        JsonNode row = data.get("data").get(0).get("row");
        MatcherAssert.assertThat((Object)row.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        JsonNode firstCell = row.get(0);
        MatcherAssert.assertThat((Object)firstCell.get("one").get("two").size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)firstCell.get("one").get("two").get(0).asBoolean(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)firstCell.get("one").get("two").get(1).get("three").asInt(), (Matcher)CoreMatchers.is((Object)42));
        MatcherAssert.assertThat((Object)response.get("errors").size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void shouldSerializeMapsCorrectlyInRestFormat() throws Exception {
        HTTP.Response response = this.http.POST("/db/data/transaction/commit", HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'RETURN {one:{two:[true, {three: 42}]}}', 'resultDataContents':['rest'] } ] }"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        JsonNode data = response.get("results").get(0);
        JsonNode rest = data.get("data").get(0).get("rest");
        MatcherAssert.assertThat((Object)rest.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        JsonNode firstCell = rest.get(0);
        MatcherAssert.assertThat((Object)firstCell.get("one").get("two").size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)firstCell.get("one").get("two").get(0).asBoolean(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)firstCell.get("one").get("two").get(1).get("three").asInt(), (Matcher)CoreMatchers.is((Object)42));
        MatcherAssert.assertThat((Object)response.get("errors").size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    private HTTP.RawPayload singleStatement(String statement) {
        return HTTP.RawPayload.rawPayload("{\"statements\":[{\"statement\":\"" + statement + "\"}]}");
    }

    private long countNodes() {
        try (Transaction transaction = this.graphdb().beginTx();){
            long count = 0L;
            Iterator allNodes = GlobalGraphOperations.at((GraphDatabaseService)this.graphdb()).getAllNodes().iterator();
            while (allNodes.hasNext()) {
                ++count;
                allNodes.next();
            }
            transaction.failure();
            long l = count;
            return l;
        }
    }
}

