/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.WrappingNeoServer;
import org.neo4j.server.WrappingNeoServerBootstrapper;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.ServerConfigurator;
import org.neo4j.server.web.WebServer;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.Mute;

@Path(value="/")
public class TestJetty9WebServer {
    @Rule
    public Mute mute = Mute.muteAll();
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();

    @GET
    public Response index() {
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToRestart() throws Throwable {
        WrappingNeoServer neoServer = new WrappingNeoServer(this.dbRule.getGraphDatabaseAPI());
        WebServer server = neoServer.getWebServer();
        try {
            server.setAddress("127.0.0.1");
            server.setPort(7878);
            server.start();
            server.stop();
            server.start();
        }
        finally {
            try {
                server.stop();
            }
            catch (Throwable throwable) {}
        }
    }

    @Test
    public void shouldBeAbleToSetExecutionLimit() throws Throwable {
        Guard dummyGuard = new Guard(StringLogger.DEV_NULL);
        ImpermanentGraphDatabase db = new ImpermanentGraphDatabase(){};
        ServerConfigurator config = new ServerConfigurator((GraphDatabaseAPI)db);
        config.configuration().setProperty("org.neo4j.server.webserver.port", (Object)7476);
        config.configuration().setProperty("org.neo4j.server.webserver.limit.executiontime", (Object)1000);
        WrappingNeoServerBootstrapper testBootstrapper = new WrappingNeoServerBootstrapper((GraphDatabaseAPI)db, (Configurator)config);
        testBootstrapper.start();
        testBootstrapper.stop();
    }
}

