/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.preflight;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.preflight.PreFlightTasks;
import org.neo4j.server.preflight.PreflightTask;
import org.neo4j.test.BufferingLogging;
import org.neo4j.test.Mute;

public class TestPreflightTasks {
    @Rule
    public Mute mute = Mute.muteAll();

    @Test
    public void shouldPassWithNoRules() {
        PreFlightTasks check = new PreFlightTasks(DevNullLoggingService.DEV_NULL, new PreflightTask[0]);
        Assert.assertTrue((boolean)check.run());
    }

    @Test
    public void shouldRunAllHealthChecksToCompletionIfNonFail() {
        PreFlightTasks check = new PreFlightTasks(DevNullLoggingService.DEV_NULL, this.getPassingRules());
        Assert.assertTrue((boolean)check.run());
    }

    @Test
    public void shouldFailIfOneOrMoreHealthChecksFail() {
        PreFlightTasks check = new PreFlightTasks(DevNullLoggingService.DEV_NULL, this.getWithOneFailingRule());
        Assert.assertFalse((boolean)check.run());
    }

    @Test
    public void shouldLogFailedRule() {
        BufferingLogging logging = new BufferingLogging();
        PreFlightTasks check = new PreFlightTasks((Logging)logging, this.getWithOneFailingRule());
        check.run();
        Assert.assertThat((Object)logging.toString(), (Matcher)Matchers.containsString((String)"blah blah"));
    }

    @Test
    public void shouldAdvertiseFailedRule() {
        PreFlightTasks check = new PreFlightTasks(DevNullLoggingService.DEV_NULL, this.getWithOneFailingRule());
        check.run();
        Assert.assertNotNull((Object)check.failedTask());
    }

    private PreflightTask[] getWithOneFailingRule() {
        PreflightTask[] rules = new PreflightTask[5];
        for (int i = 0; i < rules.length; ++i) {
            rules[i] = new PreflightTask(){

                public boolean run() {
                    return true;
                }

                public String getFailureMessage() {
                    return "blah blah";
                }
            };
        }
        rules[rules.length / 2] = new PreflightTask(){

            public boolean run() {
                return false;
            }

            public String getFailureMessage() {
                return "blah blah";
            }
        };
        return rules;
    }

    private PreflightTask[] getPassingRules() {
        PreflightTask[] rules = new PreflightTask[5];
        for (int i = 0; i < rules.length; ++i) {
            rules[i] = new PreflightTask(){

                public boolean run() {
                    return true;
                }

                public String getFailureMessage() {
                    return "blah blah";
                }
            };
        }
        return rules;
    }
}

