/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.repr.MapRepresentation;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;

public class MapRepresentationTest {
    @Test
    public void shouldSerializeMapWithSimpleTypes() throws Exception {
        MapRepresentation rep = new MapRepresentation(MapUtil.map((Object[])new Object[]{"nulls", null, "strings", "a string", "numbers", 42, "booleans", true}));
        OutputFormat format = new OutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://localhost/"), null);
        String serializedMap = format.assemble((Representation)rep);
        Map map = JsonHelper.jsonToMap((String)serializedMap);
        Assert.assertThat(map.get("nulls"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)((String)map.get("strings")), (Matcher)Is.is((Object)"a string"));
        Assert.assertThat((Object)((Integer)map.get("numbers")), (Matcher)Is.is((Object)42));
        Assert.assertThat((Object)((Boolean)map.get("booleans")), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldSerializeMapWithArrayTypes() throws Exception {
        MapRepresentation rep = new MapRepresentation(MapUtil.map((Object[])new Object[]{"strings", new String[]{"a string", "another string"}, "numbers", new int[]{42, 87}, "booleans", new boolean[]{true, false}, "Booleans", new Boolean[]{Boolean.TRUE, Boolean.FALSE}}));
        OutputFormat format = new OutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://localhost/"), null);
        String serializedMap = format.assemble((Representation)rep);
        Map map = JsonHelper.jsonToMap((String)serializedMap);
        Assert.assertThat((Object)((List)map.get("strings")), (Matcher)Is.is(Arrays.asList("a string", "another string")));
        Assert.assertThat((Object)((List)map.get("numbers")), (Matcher)Is.is(Arrays.asList(42, 87)));
        Assert.assertThat((Object)((List)map.get("booleans")), (Matcher)Is.is(Arrays.asList(true, false)));
        Assert.assertThat((Object)((List)map.get("Booleans")), (Matcher)Is.is(Arrays.asList(true, false)));
    }

    @Test
    public void shouldSerializeMapWithListsOfSimpleTypes() throws Exception {
        MapRepresentation rep = new MapRepresentation(MapUtil.map((Object[])new Object[]{"lists of nulls", Arrays.asList(null, null), "lists of strings", Arrays.asList("a string", "another string"), "lists of numbers", Arrays.asList(23, 87, 42), "lists of booleans", Arrays.asList(true, false, true)}));
        OutputFormat format = new OutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://localhost/"), null);
        String serializedMap = format.assemble((Representation)rep);
        Map map = JsonHelper.jsonToMap((String)serializedMap);
        Assert.assertThat((Object)((List)map.get("lists of nulls")), (Matcher)Is.is(Arrays.asList(null, null)));
        Assert.assertThat((Object)((List)map.get("lists of strings")), (Matcher)Is.is(Arrays.asList("a string", "another string")));
        Assert.assertThat((Object)((List)map.get("lists of numbers")), (Matcher)Is.is(Arrays.asList(23, 87, 42)));
        Assert.assertThat((Object)((List)map.get("lists of booleans")), (Matcher)Is.is(Arrays.asList(true, false, true)));
    }

    @Test
    public void shouldSerializeMapWithMapsOfSimpleTypes() throws Exception {
        MapRepresentation rep = new MapRepresentation(MapUtil.map((Object[])new Object[]{"maps with nulls", MapUtil.map((Object[])new Object[]{"nulls", null}), "maps with strings", MapUtil.map((Object[])new Object[]{"strings", "a string"}), "maps with numbers", MapUtil.map((Object[])new Object[]{"numbers", 42}), "maps with booleans", MapUtil.map((Object[])new Object[]{"booleans", true})}));
        OutputFormat format = new OutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://localhost/"), null);
        String serializedMap = format.assemble((Representation)rep);
        Map map = JsonHelper.jsonToMap((String)serializedMap);
        Assert.assertThat(((Map)map.get("maps with nulls")).get("nulls"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)((String)((Map)map.get("maps with strings")).get("strings")), (Matcher)Is.is((Object)"a string"));
        Assert.assertThat((Object)((Integer)((Map)map.get("maps with numbers")).get("numbers")), (Matcher)Is.is((Object)42));
        Assert.assertThat((Object)((Boolean)((Map)map.get("maps with booleans")).get("booleans")), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldSerializeArbitrarilyNestedMapsAndLists() throws Exception {
        MapRepresentation rep = new MapRepresentation(MapUtil.map((Object[])new Object[]{"a map with a list in it", MapUtil.map((Object[])new Object[]{"a list", Arrays.asList(42, 87)}), "a list with a map in it", Arrays.asList(MapUtil.map((Object[])new Object[]{"foo", "bar", "baz", false}))}));
        OutputFormat format = new OutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://localhost/"), null);
        String serializedMap = format.assemble((Representation)rep);
        Map map = JsonHelper.jsonToMap((String)serializedMap);
        Assert.assertThat((Object)((List)((Map)map.get("a map with a list in it")).get("a list")), (Matcher)Is.is(Arrays.asList(42, 87)));
        Assert.assertThat((Object)((String)((Map)((List)map.get("a list with a map in it")).get(0)).get("foo")), (Matcher)Is.is((Object)"bar"));
        Assert.assertThat((Object)((Boolean)((Map)((List)map.get("a list with a map in it")).get(0)).get("baz")), (Matcher)Is.is((Object)false));
    }
}

