/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.cypher.SyntaxException;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.cypher.javacompat.internal.ServerExecutionEngine;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.rest.transactional.ExecutionResultSerializer;
import org.neo4j.server.rest.transactional.ResultDataContent;
import org.neo4j.server.rest.transactional.Statement;
import org.neo4j.server.rest.transactional.StatementDeserializer;
import org.neo4j.server.rest.transactional.StubStatementDeserializer;
import org.neo4j.server.rest.transactional.TransactionHandle;
import org.neo4j.server.rest.transactional.TransactionRegistry;
import org.neo4j.server.rest.transactional.TransitionalPeriodTransactionMessContainer;
import org.neo4j.server.rest.transactional.TransitionalTxManagementKernelTransaction;
import org.neo4j.server.rest.transactional.error.Neo4jError;
import org.neo4j.server.rest.web.TransactionUriScheme;

public class TransactionHandleTest {
    private static final TransactionUriScheme uriScheme = new TransactionUriScheme(){

        public URI txUri(long id) {
            return URI.create("transaction/" + id);
        }

        public URI txCommitUri(long id) {
            return URI.create("transaction/" + id + "/commit");
        }
    };

    @Test
    public void shouldExecuteStatements() throws Exception {
        TransitionalPeriodTransactionMessContainer kernel = this.mockKernel();
        ServerExecutionEngine executionEngine = (ServerExecutionEngine)Mockito.mock(ServerExecutionEngine.class);
        ExecutionResult executionResult = (ExecutionResult)Mockito.mock(ExecutionResult.class);
        Mockito.when((Object)executionEngine.execute("query", MapUtil.map((Object[])new Object[0]))).thenReturn((Object)executionResult);
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin()).thenReturn((Object)1337L);
        TransactionHandle handle = new TransactionHandle(kernel, executionEngine, registry, uriScheme, StringLogger.DEV_NULL);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        handle.execute((StatementDeserializer)StubStatementDeserializer.statements(new Statement("query", MapUtil.map((Object[])new Object[0]), false, (ResultDataContent[])null)), output);
        ((ServerExecutionEngine)Mockito.verify((Object)executionEngine)).execute("query", MapUtil.map((Object[])new Object[0]));
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionCommitUri(uriScheme.txCommitUri(1337L));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).statementResult(executionResult, false, (ResultDataContent[])null);
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionStatus(Mockito.anyLong());
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Mockito.argThat(TransactionHandleTest.hasNoErrors()));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldSuspendTransactionAndReleaseForOtherRequestsAfterExecutingStatements() throws Exception {
        TransitionalPeriodTransactionMessContainer kernel = this.mockKernel();
        TransitionalTxManagementKernelTransaction transactionContext = kernel.newTransaction();
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin()).thenReturn((Object)1337L);
        ServerExecutionEngine executionEngine = (ServerExecutionEngine)Mockito.mock(ServerExecutionEngine.class);
        ExecutionResult executionResult = (ExecutionResult)Mockito.mock(ExecutionResult.class);
        Mockito.when((Object)executionEngine.execute("query", MapUtil.map((Object[])new Object[0]))).thenReturn((Object)executionResult);
        TransactionHandle handle = new TransactionHandle(kernel, executionEngine, registry, uriScheme, StringLogger.DEV_NULL);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        handle.execute((StatementDeserializer)StubStatementDeserializer.statements(new Statement("query", MapUtil.map((Object[])new Object[0]), false, (ResultDataContent[])null)), output);
        InOrder transactionOrder = Mockito.inOrder((Object[])new Object[]{transactionContext, registry});
        ((TransitionalTxManagementKernelTransaction)transactionOrder.verify((Object)transactionContext)).suspendSinceTransactionsAreStillThreadBound();
        ((TransactionRegistry)transactionOrder.verify((Object)registry)).release(1337L, handle);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionCommitUri(uriScheme.txCommitUri(1337L));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).statementResult(executionResult, false, (ResultDataContent[])null);
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionStatus(Mockito.anyLong());
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Mockito.argThat(TransactionHandleTest.hasNoErrors()));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldResumeTransactionWhenExecutingStatementsOnSecondRequest() throws Exception {
        TransitionalPeriodTransactionMessContainer kernel = this.mockKernel();
        TransitionalTxManagementKernelTransaction transactionContext = kernel.newTransaction();
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin()).thenReturn((Object)1337L);
        ServerExecutionEngine executionEngine = (ServerExecutionEngine)Mockito.mock(ServerExecutionEngine.class);
        TransactionHandle handle = new TransactionHandle(kernel, executionEngine, registry, uriScheme, StringLogger.DEV_NULL);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        handle.execute((StatementDeserializer)StubStatementDeserializer.statements(new Statement("query", MapUtil.map((Object[])new Object[0]), false, (ResultDataContent[])null)), output);
        Mockito.reset((Object[])new Object[]{transactionContext, registry, executionEngine, output});
        ExecutionResult executionResult = (ExecutionResult)Mockito.mock(ExecutionResult.class);
        Mockito.when((Object)executionEngine.execute("query", MapUtil.map((Object[])new Object[0]))).thenReturn((Object)executionResult);
        handle.execute((StatementDeserializer)StubStatementDeserializer.statements(new Statement("query", MapUtil.map((Object[])new Object[0]), false, (ResultDataContent[])null)), output);
        InOrder order = Mockito.inOrder((Object[])new Object[]{transactionContext, registry, executionEngine});
        ((TransitionalTxManagementKernelTransaction)order.verify((Object)transactionContext)).resumeSinceTransactionsAreStillThreadBound();
        ((ServerExecutionEngine)order.verify((Object)executionEngine)).execute("query", MapUtil.map((Object[])new Object[0]));
        ((TransitionalTxManagementKernelTransaction)order.verify((Object)transactionContext)).suspendSinceTransactionsAreStillThreadBound();
        ((TransactionRegistry)order.verify((Object)registry)).release(1337L, handle);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionCommitUri(uriScheme.txCommitUri(1337L));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).statementResult(executionResult, false, (ResultDataContent[])null);
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionStatus(Mockito.anyLong());
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Mockito.argThat(TransactionHandleTest.hasNoErrors()));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldCommitSinglePeriodicCommitStatement() throws Exception {
        String queryText = "USING PERIODIC COMMIT CREATE()";
        TransitionalPeriodTransactionMessContainer kernel = this.mockKernel();
        ServerExecutionEngine executionEngine = (ServerExecutionEngine)Mockito.mock(ServerExecutionEngine.class);
        ExecutionResult executionResult = (ExecutionResult)Mockito.mock(ExecutionResult.class);
        Mockito.when((Object)executionEngine.isPeriodicCommitQuery(queryText)).thenReturn((Object)true);
        Mockito.when((Object)executionEngine.execute(queryText)).thenReturn((Object)executionResult);
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin()).thenReturn((Object)1337L);
        TransactionHandle handle = new TransactionHandle(kernel, executionEngine, registry, uriScheme, StringLogger.DEV_NULL);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        Statement statement = new Statement(queryText, MapUtil.map((Object[])new Object[0]), false, (ResultDataContent[])null);
        handle.commit((StatementDeserializer)StubStatementDeserializer.statements(statement), output, true);
        ((ServerExecutionEngine)Mockito.verify((Object)executionEngine)).isPeriodicCommitQuery(queryText);
        ((ServerExecutionEngine)Mockito.verify((Object)executionEngine)).execute(queryText, MapUtil.map((Object[])new Object[0]));
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).statementResult(null, false, (ResultDataContent[])null);
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Mockito.argThat(TransactionHandleTest.hasNoErrors()));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldCommitTransactionAndTellRegistryToForgetItsHandle() throws Exception {
        TransitionalPeriodTransactionMessContainer kernel = this.mockKernel();
        TransitionalTxManagementKernelTransaction transactionContext = kernel.newTransaction();
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin()).thenReturn((Object)1337L);
        ServerExecutionEngine engine = (ServerExecutionEngine)Mockito.mock(ServerExecutionEngine.class);
        ExecutionResult result = (ExecutionResult)Mockito.mock(ExecutionResult.class);
        Mockito.when((Object)engine.execute("query", MapUtil.map((Object[])new Object[0]))).thenReturn((Object)result);
        TransactionHandle handle = new TransactionHandle(kernel, engine, registry, uriScheme, StringLogger.DEV_NULL);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]), false, (ResultDataContent[])null);
        handle.commit((StatementDeserializer)StubStatementDeserializer.statements(statement), output, false);
        InOrder transactionOrder = Mockito.inOrder((Object[])new Object[]{transactionContext, registry});
        ((TransitionalTxManagementKernelTransaction)transactionOrder.verify((Object)transactionContext)).commit();
        ((TransactionRegistry)transactionOrder.verify((Object)registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).statementResult(result, false, (ResultDataContent[])null);
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Mockito.argThat(TransactionHandleTest.hasNoErrors()));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldRollbackTransactionAndTellRegistryToForgetItsHandle() throws Exception {
        TransitionalPeriodTransactionMessContainer kernel = this.mockKernel();
        TransitionalTxManagementKernelTransaction transactionContext = kernel.newTransaction();
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin()).thenReturn((Object)1337L);
        TransactionHandle handle = new TransactionHandle(kernel, (ServerExecutionEngine)Mockito.mock(ServerExecutionEngine.class), registry, uriScheme, StringLogger.DEV_NULL);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        handle.rollback(output);
        InOrder transactionOrder = Mockito.inOrder((Object[])new Object[]{transactionContext, registry});
        ((TransitionalTxManagementKernelTransaction)transactionOrder.verify((Object)transactionContext)).rollback();
        ((TransactionRegistry)transactionOrder.verify((Object)registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Mockito.argThat(TransactionHandleTest.hasNoErrors()));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldCreateTransactionContextOnlyWhenFirstNeeded() throws Exception {
        TransitionalPeriodTransactionMessContainer kernel = this.mockKernel();
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin()).thenReturn((Object)1337L);
        ServerExecutionEngine engine = (ServerExecutionEngine)Mockito.mock(ServerExecutionEngine.class);
        ExecutionResult executionResult = (ExecutionResult)Mockito.mock(ExecutionResult.class);
        Mockito.when((Object)engine.execute("query", MapUtil.map((Object[])new Object[0]))).thenReturn((Object)executionResult);
        TransactionHandle handle = new TransactionHandle(kernel, engine, registry, uriScheme, StringLogger.DEV_NULL);
        Mockito.verifyZeroInteractions((Object[])new Object[]{kernel});
        handle.execute((StatementDeserializer)StubStatementDeserializer.statements(new Statement("query", MapUtil.map((Object[])new Object[0]), false, (ResultDataContent[])null)), output);
        ((TransitionalPeriodTransactionMessContainer)Mockito.verify((Object)kernel)).newTransaction();
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionCommitUri(uriScheme.txCommitUri(1337L));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).statementResult(executionResult, false, (ResultDataContent[])null);
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionStatus(Mockito.anyLong());
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Mockito.argThat(TransactionHandleTest.hasNoErrors()));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldRollbackTransactionIfExecutionErrorOccurs() throws Exception {
        TransitionalPeriodTransactionMessContainer kernel = this.mockKernel();
        TransitionalTxManagementKernelTransaction transactionContext = kernel.newTransaction();
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin()).thenReturn((Object)1337L);
        ServerExecutionEngine executionEngine = (ServerExecutionEngine)Mockito.mock(ServerExecutionEngine.class);
        Mockito.when((Object)executionEngine.execute("query", MapUtil.map((Object[])new Object[0]))).thenThrow(new Throwable[]{new NullPointerException()});
        TransactionHandle handle = new TransactionHandle(kernel, executionEngine, registry, uriScheme, StringLogger.DEV_NULL);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        handle.execute((StatementDeserializer)StubStatementDeserializer.statements(new Statement("query", MapUtil.map((Object[])new Object[0]), false, (ResultDataContent[])null)), output);
        ((TransitionalTxManagementKernelTransaction)Mockito.verify((Object)transactionContext)).rollback();
        ((TransactionRegistry)Mockito.verify((Object)registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionCommitUri(uriScheme.txCommitUri(1337L));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Mockito.argThat(TransactionHandleTest.hasErrors(new Status[]{Status.Statement.ExecutionFailure})));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldLogMessageIfCommitErrorOccurs() throws Exception {
        TransitionalPeriodTransactionMessContainer kernel = this.mockKernel();
        TransitionalTxManagementKernelTransaction transactionContext = kernel.newTransaction();
        ((TransitionalTxManagementKernelTransaction)Mockito.doThrow((Throwable)new NullPointerException()).when((Object)transactionContext)).commit();
        StringLogger log = (StringLogger)Mockito.mock(StringLogger.class);
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin()).thenReturn((Object)1337L);
        ServerExecutionEngine engine = (ServerExecutionEngine)Mockito.mock(ServerExecutionEngine.class);
        ExecutionResult executionResult = (ExecutionResult)Mockito.mock(ExecutionResult.class);
        Mockito.when((Object)engine.execute("query", MapUtil.map((Object[])new Object[0]))).thenReturn((Object)executionResult);
        TransactionHandle handle = new TransactionHandle(kernel, engine, registry, uriScheme, log);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]), false, (ResultDataContent[])null);
        handle.commit((StatementDeserializer)StubStatementDeserializer.statements(statement), output, false);
        ((StringLogger)Mockito.verify((Object)log)).error((String)Mockito.eq((Object)"Failed to commit transaction."), (Throwable)Mockito.any(NullPointerException.class));
        ((TransactionRegistry)Mockito.verify((Object)registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).statementResult(executionResult, false, (ResultDataContent[])null);
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Mockito.argThat(TransactionHandleTest.hasErrors(new Status[]{Status.Transaction.CouldNotCommit})));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldLogMessageIfCypherSyntaxErrorOccurs() throws Exception {
        TransitionalPeriodTransactionMessContainer kernel = this.mockKernel();
        ServerExecutionEngine executionEngine = (ServerExecutionEngine)Mockito.mock(ServerExecutionEngine.class);
        Mockito.when((Object)executionEngine.execute("matsch (n) return n", MapUtil.map((Object[])new Object[0]))).thenThrow(new Throwable[]{new SyntaxException("did you mean MATCH?")});
        StringLogger log = (StringLogger)Mockito.mock(StringLogger.class);
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin()).thenReturn((Object)1337L);
        TransactionHandle handle = new TransactionHandle(kernel, executionEngine, registry, uriScheme, log);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        Statement statement = new Statement("matsch (n) return n", MapUtil.map((Object[])new Object[0]), false, (ResultDataContent[])null);
        handle.commit((StatementDeserializer)StubStatementDeserializer.statements(statement), output, false);
        ((TransactionRegistry)Mockito.verify((Object)registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Mockito.argThat(TransactionHandleTest.hasErrors(new Status[]{Status.Statement.InvalidSyntax})));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldHandleExecutionEngineThrowingUndeclaredCheckedExceptions() throws Exception {
        ServerExecutionEngine executionEngine = (ServerExecutionEngine)Mockito.mock(ServerExecutionEngine.class);
        Mockito.when((Object)executionEngine.execute("match (n) return n", MapUtil.map((Object[])new Object[0]))).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                throw new Exception("BOO");
            }
        });
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin()).thenReturn((Object)1337L);
        TransactionHandle handle = new TransactionHandle(this.mockKernel(), executionEngine, registry, uriScheme, (StringLogger)Mockito.mock(StringLogger.class));
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        Statement statement = new Statement("match (n) return n", MapUtil.map((Object[])new Object[0]), false, (ResultDataContent[])null);
        handle.commit((StatementDeserializer)StubStatementDeserializer.statements(statement), output, false);
        ((TransactionRegistry)Mockito.verify((Object)registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Mockito.argThat(TransactionHandleTest.hasErrors(new Status[]{Status.Statement.ExecutionFailure})));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    private TransitionalPeriodTransactionMessContainer mockKernel() {
        TransitionalTxManagementKernelTransaction context = (TransitionalTxManagementKernelTransaction)Mockito.mock(TransitionalTxManagementKernelTransaction.class);
        TransitionalPeriodTransactionMessContainer kernel = (TransitionalPeriodTransactionMessContainer)Mockito.mock(TransitionalPeriodTransactionMessContainer.class);
        Mockito.when((Object)kernel.newTransaction()).thenReturn((Object)context);
        return kernel;
    }

    private static Matcher<Iterable<Neo4jError>> hasNoErrors() {
        return TransactionHandleTest.hasErrors(new Status[0]);
    }

    private static Matcher<Iterable<Neo4jError>> hasErrors(Status ... codes) {
        final HashSet<Status> expectedErrorsCodes = new HashSet<Status>(Arrays.asList(codes));
        return new TypeSafeMatcher<Iterable<Neo4jError>>(){

            protected boolean matchesSafely(Iterable<Neo4jError> item) {
                HashSet<Status> actualErrorCodes = new HashSet<Status>();
                for (Neo4jError neo4jError : item) {
                    actualErrorCodes.add(neo4jError.status());
                }
                return expectedErrorsCodes.equals(actualErrorCodes);
            }

            public void describeTo(Description description) {
                description.appendText("Errors with set of codes").appendValue((Object)expectedErrorsCodes);
            }
        };
    }
}

