/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.server.web.Jetty9WebServer;
import org.neo4j.test.Mute;

public class JettyThreadLimitTest {
    @Rule
    public Mute mute = Mute.muteAll();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldHaveConfigurableJettyThreadPoolSize() throws Exception {
        Jetty9WebServer server = new Jetty9WebServer(DevNullLoggingService.DEV_NULL);
        int maxThreads = 7;
        server.setMaxThreads(7);
        server.setPort(7480);
        try {
            server.start();
            QueuedThreadPool threadPool = (QueuedThreadPool)server.getJetty().getThreadPool();
            threadPool.start();
            int configuredMaxThreads = 7 * Runtime.getRuntime().availableProcessors();
            this.loadThreadPool(threadPool, configuredMaxThreads + 1);
            int threads = threadPool.getThreads();
            Assert.assertTrue((threads <= 7 ? 1 : 0) != 0);
        }
        finally {
            server.stop();
        }
    }

    private void loadThreadPool(QueuedThreadPool threadPool, int tasksToSubmit) {
        final CyclicBarrier cb = new CyclicBarrier(tasksToSubmit);
        for (int i = 0; i < tasksToSubmit; ++i) {
            threadPool.dispatch(new Runnable(){

                @Override
                public void run() {
                    try {
                        cb.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (BrokenBarrierException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }
}

