/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webdriver;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.neo4j.server.webdriver.Condition;
import org.neo4j.server.webdriver.ElementAttributeIs;
import org.neo4j.server.webdriver.ElementTextIs;
import org.neo4j.server.webdriver.WebdriverCondition;
import org.neo4j.server.webdriver.WebdriverLibrary;
import org.openqa.selenium.By;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;

public class ElementReference {
    protected By selector;
    protected WebdriverLibrary wl;
    protected boolean matchLast;

    public ElementReference(WebdriverLibrary wl, By selector) {
        this(wl, selector, false);
    }

    public ElementReference(WebdriverLibrary wl, By selector, boolean matchLast) {
        this.wl = wl;
        this.selector = selector;
        this.matchLast = matchLast;
    }

    public WebElement getElement() {
        return this.wl.getWebElement(this.selector);
    }

    public WebElement findElement(By by) {
        try {
            return this.getElement().findElement(by);
        }
        catch (StaleElementReferenceException e) {
            return this.findElement(by);
        }
    }

    public List<WebElement> findElements(By by) {
        try {
            return this.getElement().findElements(by);
        }
        catch (StaleElementReferenceException e) {
            return this.findElements(by);
        }
    }

    public String getAttribute(String attributeName) {
        try {
            return this.getElement().getAttribute(attributeName);
        }
        catch (StaleElementReferenceException e) {
            return this.getAttribute(attributeName);
        }
    }

    public void click() {
        try {
            this.getElement().click();
        }
        catch (StaleElementReferenceException e) {
            this.click();
        }
    }

    public String getValueOfCssProperty(String cssProperty) {
        try {
            return this.getElement().getCssValue(cssProperty);
        }
        catch (StaleElementReferenceException e) {
            return this.getValueOfCssProperty(cssProperty);
        }
    }

    public void sendKeys(CharSequence ... keysToSend) {
        try {
            this.waitUntilVisible();
            this.getElement().sendKeys(keysToSend);
        }
        catch (StaleElementReferenceException e) {
            this.sendKeys(keysToSend);
        }
    }

    public String getValue() {
        try {
            return this.getElement().getAttribute("value");
        }
        catch (StaleElementReferenceException e) {
            return this.getValue();
        }
    }

    public String getText() {
        try {
            this.waitUntilVisible();
            return this.getElement().getText();
        }
        catch (StaleElementReferenceException e) {
            return this.getText();
        }
    }

    public void clear() {
        try {
            this.getElement().clear();
        }
        catch (StaleElementReferenceException e) {
            this.clear();
        }
    }

    public void waitUntilVisible() {
        this.wl.waitForElementToAppear(this.selector);
    }

    public void waitUntilNotVisible() {
        this.wl.waitForElementToDisappear(this.selector);
    }

    public void waitForAttributeToBe(String attr, String value) {
        WebdriverCondition<ElementReference> cond = new WebdriverCondition<ElementReference>(this.wl.getWebDriver(), (Matcher<ElementReference>)ElementAttributeIs.elementAttributeIs(attr, value), this);
        ((Condition)cond).waitUntilFulfilled(10000L, "Attribute " + attr + " did not change to " + value + " within a reasonable time.");
    }

    public void waitForAttributeToChangeFrom(String attr, String value) {
        WebdriverCondition<ElementReference> cond = new WebdriverCondition<ElementReference>(this.wl.getWebDriver(), Matchers.not((Matcher)ElementAttributeIs.elementAttributeIs(attr, value)), this);
        ((Condition)cond).waitUntilFulfilled(10000L, "Attribute " + attr + " did not change from " + value + " within a reasonable time.");
    }

    public void waitForTextToChangeFrom(String value) {
        WebdriverCondition<ElementReference> cond = new WebdriverCondition<ElementReference>(this.wl.getWebDriver(), Matchers.not((Matcher)ElementTextIs.elementTextIs(value)), this);
        ((Condition)cond).waitUntilFulfilled(10000L, "Element text did not change from " + value + " within a reasonable time.");
    }

    public void waitForTextToChangeTo(String value) {
        WebdriverCondition<ElementReference> cond = new WebdriverCondition<ElementReference>(this.wl.getWebDriver(), (Matcher<ElementReference>)ElementTextIs.elementTextIs(value), this);
        ((Condition)cond).waitUntilFulfilled(10000L, String.format("Element text did not change to [%s] within a reasonable time - is still [%s]", value, this.getText()));
    }
}

