/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.web.CollectUserAgentFilter;

public class CollectUserAgentFilterIT
extends AbstractRestFunctionalTestBase {
    private static FunctionalTestHelper functionalTestHelper;

    @BeforeClass
    public static void setupServer() throws IOException {
        functionalTestHelper = new FunctionalTestHelper(CollectUserAgentFilterIT.server());
    }

    @Test
    public void shouldRecordUserAgent() throws Exception {
        this.sendRequest("test/1.0");
        MatcherAssert.assertThat((Object)CollectUserAgentFilter.instance().getUserAgents(), (Matcher)CoreMatchers.hasItem((Object)"test/1.0"));
    }

    private void sendRequest(String userAgent) {
        String url = functionalTestHelper.baseUri().toString();
        JaxRsResponse resp = RestRequest.req().header("User-Agent", userAgent).get(url);
        String json = resp.getEntity();
        resp.close();
        Assert.assertEquals((String)json, (long)200L, (long)resp.getStatus());
    }
}

