/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.preflight;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.server.configuration.MapBasedConfiguration;
import org.neo4j.server.preflight.PerformUpgradeIfNecessary;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.Unzip;

public class TestPerformUpgradeIfNecessary {
    public static final File HOME_DIRECTORY = TargetDirectory.forTest(TestPerformUpgradeIfNecessary.class).cleanDirectory("home");
    public static final File STORE_DIRECTORY = new File(new File(HOME_DIRECTORY, "data"), "graph.db");

    @Test
    public void shouldExitImmediatelyIfStoreIsAlreadyAtLatestVersion() throws IOException {
        Configuration serverConfig = this.buildProperties(false);
        new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(STORE_DIRECTORY.getPath()).newGraphDatabase().shutdown();
        StoreUpgrader.Monitor monitor = (StoreUpgrader.Monitor)Mockito.mock(StoreUpgrader.Monitor.class);
        PerformUpgradeIfNecessary upgrader = new PerformUpgradeIfNecessary(serverConfig, this.loadNeo4jProperties(), DevNullLoggingService.DEV_NULL, monitor);
        boolean exit = upgrader.run();
        Assert.assertEquals((Object)true, (Object)exit);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{monitor});
    }

    @Test
    public void shouldGiveHelpfulMessageIfAutoUpgradeParameterNotSet() throws IOException {
        Configuration serverProperties = this.buildProperties(false);
        TestPerformUpgradeIfNecessary.prepareSampleLegacyDatabase(STORE_DIRECTORY);
        StoreUpgrader.Monitor monitor = (StoreUpgrader.Monitor)Mockito.mock(StoreUpgrader.Monitor.class);
        PerformUpgradeIfNecessary upgrader = new PerformUpgradeIfNecessary(serverProperties, this.loadNeo4jProperties(), DevNullLoggingService.DEV_NULL, monitor);
        boolean exit = upgrader.run();
        Assert.assertEquals((Object)false, (Object)exit);
        ((StoreUpgrader.Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.times((int)1))).migrationNeeded();
        ((StoreUpgrader.Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.times((int)1))).migrationNotAllowed();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{monitor});
    }

    @Test
    public void shouldExitCleanlyIfDatabaseMissingSoThatDatabaseCreationIsLeftToMainProcess() throws IOException {
        StoreUpgrader.Monitor monitor = (StoreUpgrader.Monitor)Mockito.mock(StoreUpgrader.Monitor.class);
        PerformUpgradeIfNecessary upgrader = new PerformUpgradeIfNecessary(this.buildProperties(true), this.loadNeo4jProperties(), DevNullLoggingService.DEV_NULL, monitor);
        boolean exit = upgrader.run();
        Assert.assertEquals((Object)true, (Object)exit);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{monitor});
    }

    @Test
    public void shouldUpgradeDatabase() throws IOException {
        Configuration serverConfig = this.buildProperties(true);
        TestPerformUpgradeIfNecessary.prepareSampleLegacyDatabase(STORE_DIRECTORY);
        StoreUpgrader.Monitor monitor = (StoreUpgrader.Monitor)Mockito.mock(StoreUpgrader.Monitor.class);
        PerformUpgradeIfNecessary upgrader = new PerformUpgradeIfNecessary(serverConfig, this.loadNeo4jProperties(), DevNullLoggingService.DEV_NULL, monitor);
        boolean exit = upgrader.run();
        Assert.assertEquals((Object)true, (Object)exit);
        InOrder order = Mockito.inOrder((Object[])new Object[]{monitor});
        ((StoreUpgrader.Monitor)order.verify((Object)monitor, Mockito.times((int)1))).migrationNeeded();
        ((StoreUpgrader.Monitor)order.verify((Object)monitor, Mockito.times((int)1))).migrationCompleted();
        order.verifyNoMoreInteractions();
    }

    private Configuration buildProperties(boolean allowStoreUpgrade) throws IOException {
        FileUtils.deleteRecursively((File)HOME_DIRECTORY);
        File confDir = new File(HOME_DIRECTORY, "conf");
        confDir.mkdirs();
        Properties databaseProperties = new Properties();
        if (allowStoreUpgrade) {
            databaseProperties.setProperty(GraphDatabaseSettings.allow_store_upgrade.name(), "true");
        }
        String databasePropertiesFileName = new File(confDir, "neo4j.properties").getAbsolutePath();
        databaseProperties.store(new FileWriter(databasePropertiesFileName), null);
        MapBasedConfiguration serverProperties = new MapBasedConfiguration();
        serverProperties.setProperty("org.neo4j.server.database.location", (Object)STORE_DIRECTORY.getPath());
        serverProperties.setProperty("org.neo4j.server.db.tuning.properties", (Object)databasePropertiesFileName);
        return serverProperties;
    }

    private Map<String, String> loadNeo4jProperties() throws IOException {
        String databasePropertiesFileName = new File(new File(HOME_DIRECTORY, "conf"), "neo4j.properties").getAbsolutePath();
        return MapUtil.load((File)new File(databasePropertiesFileName));
    }

    public static void prepareSampleLegacyDatabase(File workingDirectory) throws IOException {
        File resourceDirectory = TestPerformUpgradeIfNecessary.findOldFormatStoreDirectory();
        FileUtils.deleteRecursively((File)workingDirectory);
        Assert.assertTrue((boolean)workingDirectory.mkdirs());
        FileUtils.copyRecursively((File)resourceDirectory, (File)workingDirectory);
    }

    public static File findOldFormatStoreDirectory() throws IOException {
        return Unzip.unzip(TestPerformUpgradeIfNecessary.class, (String)"exampledb.zip");
    }

    private String dots(int count) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            builder.append(".");
        }
        return builder.toString();
    }
}

