/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.TestData;

public class CypherDocIT
extends AbstractRestFunctionalTestBase {
    @Test
    @Documented(value=" A simple query returning all nodes connected to some node, returning the\n node and the name property, if it exists, otherwise `NULL`:\n")
    @TestData.Title(value="Send a query")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true), @GraphDescription.NODE(name="you", setNameProperty=true), @GraphDescription.NODE(name="him", setNameProperty=true, properties={@GraphDescription.PROP(key="age", value="25", type=GraphDescription.PropType.INTEGER)})}, relationships={@GraphDescription.REL(start="I", end="him", type="know", properties={}), @GraphDescription.REL(start="I", end="you", type="know", properties={})})
    public void testPropertyColumn() throws UnsupportedEncodingException {
        String script = this.createScript("MATCH (x {name: 'I'})-[r]->(n) RETURN type(r), n.name, n.age");
        String response = this.cypherRestCall(script, Response.Status.OK, new Pair[0]);
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"you"));
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"him"));
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"25"));
        Assert.assertThat((Object)response, (Matcher)IsNot.not((Matcher)CoreMatchers.containsString((String)"\"x\"")));
    }

    @Test
    @Documented(value=" By passing in an additional GET parameter when you execute Cypher queries, metadata about the query will\n be returned, such as how many labels were added or removed by the query.\n")
    @TestData.Title(value="Retrieve query metadata")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true, labels={@GraphDescription.LABEL(value="Director")})})
    public void testQueryStatistics() throws JsonParseException {
        String script = this.createScript("MATCH (n {name: 'I'}) SET n:Actor REMOVE n:Director RETURN labels(n)");
        Map output = JsonHelper.jsonToMap((String)this.doCypherRestCall(this.cypherUri() + "?includeStats=true", script, Response.Status.OK, new Pair[0]));
        Map stats = (Map)output.get("stats");
        Assert.assertThat((Object)stats, (Matcher)CoreMatchers.isA(Map.class));
        Assert.assertThat((Object)((Boolean)stats.get("contains_updates")), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((Integer)stats.get("labels_added")), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Integer)stats.get("labels_removed")), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Integer)stats.get("nodes_created")), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)((Integer)stats.get("nodes_deleted")), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)((Integer)stats.get("properties_set")), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)((Integer)stats.get("relationships_created")), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)((Integer)stats.get("relationship_deleted")), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true), @GraphDescription.NODE(name="you", setNameProperty=true), @GraphDescription.NODE(name="him", setNameProperty=true, properties={@GraphDescription.PROP(key="age", value="25", type=GraphDescription.PropType.INTEGER)})}, relationships={@GraphDescription.REL(start="I", end="him", type="know", properties={}), @GraphDescription.REL(start="I", end="you", type="know", properties={})})
    public void testDataColumnOrder() throws UnsupportedEncodingException {
        String script = this.createScript("START x  = node(%I%) MATCH x -[r]-> n RETURN type(r), n.name, n.age");
        String response = this.cypherRestCall(script, Response.Status.OK, new Pair[0]);
        Assert.assertThat((Object)(response.indexOf("columns") < response.indexOf("data") ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @Documented(value=" Errors on the server will be reported as a JSON-formatted message,\n exception name and stacktrace.\n")
    @TestData.Title(value="Errors")
    @GraphDescription.Graph(value={"I know you"})
    public void error_gets_returned_as_json() throws Exception {
        String response = this.cypherRestCall("MATCH (x {name: 'I'}) RETURN x.dummy/0", Response.Status.BAD_REQUEST, new Pair[0]);
        Map output = JsonHelper.jsonToMap((String)response);
        Assert.assertTrue((boolean)output.containsKey("message"));
        Assert.assertTrue((boolean)output.containsKey("exception"));
        Assert.assertTrue((boolean)output.containsKey("stacktrace"));
    }

    @Test
    @Documented(value=" Paths can be returned just like other return types.\n")
    @TestData.Title(value="Return paths")
    @GraphDescription.Graph(value={"I know you"})
    public void return_paths() throws Exception {
        String script = "MATCH path = (x {name: 'I'})--(friend) RETURN path, friend.name";
        String response = this.cypherRestCall(script, Response.Status.OK, new Pair[0]);
        Assert.assertEquals((long)2L, (long)JsonHelper.jsonToMap((String)response).size());
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"data"));
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"you"));
    }

    @Test
    @Documented(value=" Cypher supports queries with parameters\n which are submitted as JSON.\n")
    @TestData.Title(value="Use parameters")
    @GraphDescription.Graph(value={"I know you"}, autoIndexNodes=true)
    public void send_queries_with_parameters() throws Exception {
        this.data.get();
        String script = "MATCH (x {name: {startName}})-[r]-(friend) WHERE friend.name = {name} RETURN TYPE(r)";
        String response = this.cypherRestCall(script, Response.Status.OK, Pair.of((Object)"startName", (Object)"I"), Pair.of((Object)"name", (Object)"you"));
        Assert.assertEquals((long)2L, (long)JsonHelper.jsonToMap((String)response).size());
        Assert.assertTrue((boolean)response.contains("know"));
        Assert.assertTrue((boolean)response.contains("data"));
    }

    @Test
    @Documented(value=" Create a node with a label and a property using Cypher.\n See the request for the parameter sent with the query.\n")
    @TestData.Title(value="Create a node")
    @GraphDescription.Graph
    public void send_query_to_create_a_node() throws Exception {
        this.data.get();
        String script = "CREATE (n:Person { name : {name} }) RETURN n";
        String response = this.cypherRestCall(script, Response.Status.OK, Pair.of((Object)"name", (Object)"Andres"));
        Assert.assertTrue((boolean)response.contains("name"));
        Assert.assertTrue((boolean)response.contains("Andres"));
    }

    @Test
    @Documented(value=" Create a node with a label and multiple properties using Cypher.\n See the request for the parameter sent with the query.\n")
    @TestData.Title(value="Create a node with multiple properties")
    @GraphDescription.Graph
    public void send_query_to_create_a_node_from_a_map() throws Exception {
        this.data.get();
        String script = "CREATE (n:Person { props } ) RETURN n";
        String params = "\"props\" : { \"position\" : \"Developer\", \"name\" : \"Michael\", \"awesome\" : true, \"children\" : 3 }";
        String response = this.cypherRestCall(script, Response.Status.OK, params);
        Assert.assertTrue((boolean)response.contains("name"));
        Assert.assertTrue((boolean)response.contains("Michael"));
    }

    @Test
    @Documented(value=" Create multiple nodes with properties using Cypher. See the request for\n the parameter sent with the query.\n")
    @TestData.Title(value="Create mutiple nodes with properties")
    @GraphDescription.Graph
    public void send_query_to_create_multipe_nodes_from_a_map() throws Exception {
        this.data.get();
        String script = "CREATE (n:Person { props } ) RETURN n";
        String params = "\"props\" : [ { \"name\" : \"Andres\", \"position\" : \"Developer\" }, { \"name\" : \"Michael\", \"position\" : \"Developer\" } ]";
        String response = this.cypherRestCall(script, Response.Status.OK, params);
        Assert.assertTrue((boolean)response.contains("name"));
        Assert.assertTrue((boolean)response.contains("Michael"));
        Assert.assertTrue((boolean)response.contains("Andres"));
    }

    @Test
    @Documented(value=" Set all properties on a node.\n")
    @TestData.Title(value="Set all properties on a node using Cypher")
    @GraphDescription.Graph
    public void setAllPropertiesUsingMap() throws Exception {
        this.data.get();
        String script = "CREATE (n:Person { name: 'this property is to be deleted' } ) SET n = { props } RETURN n";
        String params = "\"props\" : { \"position\" : \"Developer\", \"firstName\" : \"Michael\", \"awesome\" : true, \"children\" : 3 }";
        String response = this.cypherRestCall(script, Response.Status.OK, params);
        Assert.assertTrue((boolean)response.contains("firstName"));
        Assert.assertTrue((boolean)response.contains("Michael"));
        Assert.assertTrue((!response.contains("name") ? 1 : 0) != 0);
        Assert.assertTrue((!response.contains("deleted") ? 1 : 0) != 0);
    }

    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", properties={@GraphDescription.PROP(key="prop", value="Hello", type=GraphDescription.PropType.STRING)}), @GraphDescription.NODE(name="you")}, relationships={@GraphDescription.REL(start="I", end="him", type="know", properties={@GraphDescription.PROP(key="prop", value="World", type=GraphDescription.PropType.STRING)})})
    public void nodes_are_represented_as_nodes() throws Exception {
        this.data.get();
        String script = "START n = node(%I%) MATCH n-[r]->() RETURN n, r";
        String response = this.cypherRestCall(script, Response.Status.OK, new Pair[0]);
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"Hello"));
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"World"));
    }

    @Test
    @Documented(value=" Sending a query with syntax errors will give a bad request (HTTP 400)\n response together with an error message.\n")
    @TestData.Title(value="Syntax errors")
    @GraphDescription.Graph(value={"I know you"}, autoIndexNodes=true)
    public void send_queries_with_syntax_errors() throws Exception {
        this.data.get();
        String script = "START x  = node:node_auto_index(name={startName}) MATC path = (x-[r]-friend) WHERE friend.name = {name} RETURN TYPE(r)";
        String response = this.cypherRestCall(script, Response.Status.BAD_REQUEST, Pair.of((Object)"startName", (Object)"I"), Pair.of((Object)"name", (Object)"you"));
        Map output = JsonHelper.jsonToMap((String)response);
        Assert.assertTrue((boolean)output.containsKey("message"));
        Assert.assertTrue((boolean)output.containsKey("stacktrace"));
    }

    @Test
    @Documented(value=" When sending queries that\n return nested results like list and maps,\n these will get serialized into nested JSON representations\n according to their types.\n")
    @GraphDescription.Graph(value={"I know you"}, autoIndexNodes=true)
    public void nested_results() throws Exception {
        this.data.get();
        String script = "MATCH (n) WHERE n.name in ['I', 'you'] RETURN collect(n.name)";
        String response = this.cypherRestCall(script, Response.Status.OK, new Pair[0]);
        System.out.println();
        Map resultMap = JsonHelper.jsonToMap((String)response);
        Assert.assertEquals((long)2L, (long)resultMap.size());
        Assert.assertThat((Object)response, (Matcher)Matchers.anyOf((Matcher)CoreMatchers.containsString((String)"\"I\",\"you\""), (Matcher)CoreMatchers.containsString((String)"\"you\",\"I\""), (Matcher)CoreMatchers.containsString((String)"\"I\", \"you\""), (Matcher)CoreMatchers.containsString((String)"\"you\", \"I\"")));
    }

    @Test
    @Documented(value=" By passing in an extra parameter, you can ask the cypher executor to return a profile of the query\n as it is executed. This can help in locating bottlenecks.\n")
    @TestData.Title(value="Profile a query")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true), @GraphDescription.NODE(name="you", setNameProperty=true), @GraphDescription.NODE(name="him", setNameProperty=true, properties={@GraphDescription.PROP(key="age", value="25", type=GraphDescription.PropType.INTEGER)})}, relationships={@GraphDescription.REL(start="I", end="him", type="know", properties={}), @GraphDescription.REL(start="I", end="you", type="know", properties={})})
    public void testProfiling() throws Exception {
        String script = this.createScript("START x = node(%I%) MATCH x -[r]-> n RETURN type(r), n.name, n.age");
        String response = this.doCypherRestCall(this.cypherUri() + "?profile=true", script, Response.Status.OK, new Pair[0]);
        Map des = JsonHelper.jsonToMap((String)response);
        Assert.assertThat(des.get("plan"), (Matcher)IsInstanceOf.instanceOf(Map.class));
        Map plan = (Map)des.get("plan");
        Assert.assertThat(plan.get("name"), (Matcher)IsInstanceOf.instanceOf(String.class));
        Assert.assertThat(plan.get("children"), (Matcher)IsInstanceOf.instanceOf(Collection.class));
        Assert.assertThat(plan.get("rows"), (Matcher)IsInstanceOf.instanceOf(Number.class));
        Assert.assertThat(plan.get("dbHits"), (Matcher)IsInstanceOf.instanceOf(Number.class));
    }

    @Test
    @GraphDescription.Graph(value={"I know you"}, autoIndexNodes=false)
    public void array_property() throws Exception {
        this.setProperty("I", "array1", new int[]{1, 2, 3});
        this.setProperty("I", "array2", new String[]{"a", "b", "c"});
        String script = "START n = node(%I%) RETURN n.array1, n.array2";
        String response = this.cypherRestCall(script, Response.Status.OK, new Pair[0]);
        Assert.assertThat((Object)response, (Matcher)Matchers.anyOf((Matcher)CoreMatchers.containsString((String)"[ 1, 2, 3 ]"), (Matcher)CoreMatchers.containsString((String)"[1,2,3]")));
        Assert.assertThat((Object)response, (Matcher)Matchers.anyOf((Matcher)CoreMatchers.containsString((String)"[ \"a\", \"b\", \"c\" ]"), (Matcher)CoreMatchers.containsString((String)"[\"a\",\"b\",\"c\"]")));
    }

    void setProperty(String nodeName, String propertyName, Object propertyValue) {
        Node i = this.getNode(nodeName);
        GraphDatabaseService db = i.getGraphDatabase();
        try (Transaction tx = db.beginTx();){
            i.setProperty(propertyName, propertyValue);
            tx.success();
        }
    }

    @Test
    @Documented(value=" This example shows what happens if you misspell\n an identifier.\n")
    @TestData.Title(value="Send queries with errors")
    @GraphDescription.Graph(value={"I know you"}, autoIndexNodes=true)
    public void send_queries_with_errors() throws Exception {
        this.data.get();
        String script = "START x = node:node_auto_index(name={startName}) MATCH path = (x-[r]-friend) WHERE frien.name = {name} RETURN type(r)";
        String response = this.cypherRestCall(script, Response.Status.BAD_REQUEST, Pair.of((Object)"startName", (Object)"I"), Pair.of((Object)"name", (Object)"you"));
        Map responseMap = JsonHelper.jsonToMap((String)response);
        Assert.assertEquals((long)4L, (long)responseMap.size());
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"message"));
        Assert.assertThat((Object)((String)responseMap.get("message")), (Matcher)CoreMatchers.containsString((String)"frien not defined"));
    }

    @SafeVarargs
    private final String cypherRestCall(String script, Response.Status status, Pair<String, String> ... params) {
        return this.doCypherRestCall(this.cypherUri(), script, status, params);
    }

    private String cypherRestCall(String script, Response.Status status, String paramString) {
        return this.doCypherRestCall(this.cypherUri(), script, status, paramString);
    }

    private String cypherUri() {
        return this.getDataUri() + "cypher";
    }
}

