/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.server.rest.domain.TraverserReturnType;
import org.neo4j.server.rest.web.DatabaseActions;
import org.neo4j.server.rest.web.RestfulGraphDatabase;

public class TransactionWrappingRestfulGraphDatabase
extends RestfulGraphDatabase {
    private final AbstractGraphDatabase graph;
    private final RestfulGraphDatabase restfulGraphDatabase;

    public TransactionWrappingRestfulGraphDatabase(AbstractGraphDatabase graph, RestfulGraphDatabase restfulGraphDatabase) {
        super(null, null, null);
        this.graph = graph;
        this.restfulGraphDatabase = restfulGraphDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response addToNodeIndex(ForceMode force, String indexName, String unique, String uniqueness, String postBody) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.addToNodeIndex(force, indexName, unique, uniqueness, postBody);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response createRelationship(ForceMode force, long startNodeId, String body) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.createRelationship(force, startNodeId, body);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response deleteNodeIndex(ForceMode force, String indexName) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.deleteNodeIndex(force, indexName);
            transaction.success();
            Response response2 = response;
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getNodeRelationships(long nodeId, DatabaseActions.RelationshipDirection direction, RestfulGraphDatabase.AmpersandSeparatedCollection types) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response;
            Response response2 = response = this.restfulGraphDatabase.getNodeRelationships(nodeId, direction, types);
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response deleteAllNodeProperties(ForceMode force, long nodeId) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.deleteAllNodeProperties(force, nodeId);
            transaction.success();
            Response response2 = response;
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getAllNodeProperties(long nodeId) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response;
            Response response2 = response = this.restfulGraphDatabase.getAllNodeProperties(nodeId);
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response traverse(long startNode, TraverserReturnType returnType, String body) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response;
            Response response2 = response = this.restfulGraphDatabase.traverse(startNode, returnType, body);
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response createNode(ForceMode force, String body) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.createNode(force, body);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response deleteAllRelationshipProperties(ForceMode force, long relationshipId) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.deleteAllRelationshipProperties(force, relationshipId);
            transaction.success();
            Response response2 = response;
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response addToRelationshipIndex(ForceMode force, String indexName, String unique, String uniqueness, String postBody) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.addToRelationshipIndex(force, indexName, unique, uniqueness, postBody);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getIndexedNodes(String indexName, String key, String value) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response;
            Response response2 = response = this.restfulGraphDatabase.getIndexedNodes(indexName, key, value);
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getRelationshipIndexRoot() {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response;
            Response response2 = response = this.restfulGraphDatabase.getRelationshipIndexRoot();
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response setRelationshipProperty(ForceMode force, long relationshipId, String key, String body) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.setRelationshipProperty(force, relationshipId, key, body);
            transaction.success();
            Response response2 = response;
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    public Response getSchemaConstraintsForLabelAndPropertyUniqueness(String labelName, RestfulGraphDatabase.AmpersandSeparatedCollection propertyKeys) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response getSchemaConstraintsForLabelAndUniqueness(String labelName) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response getSchemaConstraintsForLabel(String labelName) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response getSchemaConstraints() {
        throw new UnsupportedOperationException("TODO");
    }

    public Response dropPropertyUniquenessConstraint(String labelName, RestfulGraphDatabase.AmpersandSeparatedCollection properties) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response createPropertyUniquenessConstraint(String labelName, String body) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.createPropertyUniquenessConstraint(labelName, body);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
    }

    public Response getSchemaIndexesForLabel(String labelName) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response dropSchemaIndex(String labelName, RestfulGraphDatabase.AmpersandSeparatedCollection properties) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response createSchemaIndex(String labelName, String body) {
        throw new UnsupportedOperationException("TODO");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response allPaths(long startNode, String body) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.allPaths(startNode, body);
            return response;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response singlePath(long startNode, String body) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.singlePath(startNode, body);
            return response;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response createPagedTraverser(long startNode, TraverserReturnType returnType, int pageSize, int leaseTimeInSeconds, String body) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.createPagedTraverser(startNode, returnType, pageSize, leaseTimeInSeconds, body);
            transaction.success();
            Response response2 = response;
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response pagedTraverse(String traverserId, TraverserReturnType returnType) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.pagedTraverse(traverserId, returnType);
            return response;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response removePagedTraverser(String traverserId) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.removePagedTraverser(traverserId);
            transaction.success();
            Response response2 = response;
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    public Response deleteFromRelationshipIndex(ForceMode force, String indexName, long id) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response deleteFromRelationshipIndexNoValue(ForceMode force, String indexName, String key, long id) {
        throw new UnsupportedOperationException("TODO");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response deleteFromRelationshipIndex(ForceMode force, String indexName, String key, String value, long id) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.deleteFromRelationshipIndex(force, indexName, key, value, id);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    public Response deleteFromNodeIndexNoKeyValue(ForceMode force, String indexName, long id) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response deleteFromNodeIndexNoValue(ForceMode force, String indexName, String key, long id) {
        throw new UnsupportedOperationException("TODO");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response deleteFromNodeIndex(ForceMode force, String indexName, String key, String value, long id) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.deleteFromNodeIndex(force, indexName, key, value, id);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getIndexedRelationshipsByQuery(String indexName, String key, String query, String order) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.getIndexedRelationshipsByQuery(indexName, key, query, order);
            return response;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getIndexedRelationshipsByQuery(String indexName, String query, String order) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.getIndexedRelationshipsByQuery(indexName, query, order);
            return response;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response stopAutoIndexingProperty(String type, String property) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.stopAutoIndexingProperty(type, property);
            transaction.success();
            Response response2 = response;
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response startAutoIndexingProperty(String type, String property) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.startAutoIndexingProperty(type, property);
            transaction.success();
            Response response2 = response;
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getAutoIndexedProperties(String type) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.getAutoIndexedProperties(type);
            return response;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response setAutoIndexerEnabled(String type, String enable) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.setAutoIndexerEnabled(type, enable);
            transaction.success();
            Response response2 = response;
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response isAutoIndexerEnabled(String type) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.isAutoIndexerEnabled(type);
            return response;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getIndexedRelationships(String indexName, String key, String value) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.getIndexedRelationships(indexName, key, value);
            return response;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getIndexedNodesByQuery(String indexName, String key, String query, String order) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.getIndexedNodesByQuery(indexName, key, query, order);
            return response;
        }
        finally {
            transaction.finish();
        }
    }

    public Response getAutoIndexedNodes(String type, String key, String value) {
        throw new UnsupportedOperationException("TODO");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getRelationshipFromIndexUri(String indexName, String key, String value, long id) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.getRelationshipFromIndexUri(indexName, key, value, id);
            return response;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getNodeFromIndexUri(String indexName, String key, String value, long id) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.getNodeFromIndexUri(indexName, key, value, id);
            return response;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response deleteRelationshipIndex(ForceMode force, String indexName) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.deleteRelationshipIndex(force, indexName);
            transaction.success();
            Response response2 = response;
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    public Response getAutoIndexedNodesByQuery(String type, String query) {
        throw new UnsupportedOperationException("TODO");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getIndexedNodesByQuery(String indexName, String query, String order) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.getIndexedNodesByQuery(indexName, query, order);
            return response;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response jsonCreateRelationshipIndex(ForceMode force, String json) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.jsonCreateRelationshipIndex(force, json);
            transaction.success();
            Response response2 = response;
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response jsonCreateNodeIndex(ForceMode force, String json) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.jsonCreateNodeIndex(force, json);
            transaction.success();
            Response response2 = response;
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getNodeIndexRoot() {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.getNodeIndexRoot();
            return response;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response deleteRelationshipProperty(ForceMode force, long relationshipId, String key) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.deleteRelationshipProperty(force, relationshipId, key);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response setAllRelationshipProperties(ForceMode force, long relationshipId, String body) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.setAllRelationshipProperties(force, relationshipId, body);
            transaction.success();
            Response response2 = response;
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getRelationshipProperty(long relationshipId, String key) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.getRelationshipProperty(relationshipId, key);
            return response;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getAllRelationshipProperties(long relationshipId) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.getAllRelationshipProperties(relationshipId);
            return response;
        }
        finally {
            transaction.finish();
        }
    }

    public Response getNodeRelationships(long nodeId, DatabaseActions.RelationshipDirection direction) {
        throw new UnsupportedOperationException("TODO");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response deleteRelationship(ForceMode force, long relationshipId) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.deleteRelationship(force, relationshipId);
            transaction.success();
            Response response2 = response;
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getRelationship(long relationshipId) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.getRelationship(relationshipId);
            return response;
        }
        finally {
            transaction.finish();
        }
    }

    public Response getAllLabels() {
        throw new UnsupportedOperationException("TODO");
    }

    public Response getNodesWithLabelAndProperty(String labelName, UriInfo uriInfo) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response getNodeLabels(ForceMode force, long nodeId) {
        try (Transaction ignored = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.getNodeLabels(force, nodeId);
            return response;
        }
    }

    public Response removeNodeLabel(ForceMode force, long nodeId, String labelName) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response setNodeLabels(ForceMode force, long nodeId, String body) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response addNodeLabel(ForceMode force, long nodeId, String body) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.addNodeLabel(force, nodeId, body);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response deleteNodeProperty(ForceMode force, long nodeId, String key) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.deleteNodeProperty(force, nodeId, key);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getNodeProperty(ForceMode force, long nodeId, String key) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.getNodeProperty(force, nodeId, key);
            return response;
        }
        finally {
            transaction.finish();
        }
    }

    public Response setNodeProperty(ForceMode force, long nodeId, String key, String body) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.setNodeProperty(force, nodeId, key, body);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response setAllNodeProperties(ForceMode force, long nodeId, String body) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.setAllNodeProperties(force, nodeId, body);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response deleteNode(ForceMode force, long nodeId) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.deleteNode(force, nodeId);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getNode(long nodeId) {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.getNode(nodeId);
            return response;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getRoot() {
        Transaction transaction = this.graph.beginTx();
        try {
            Response response = this.restfulGraphDatabase.getRoot();
            return response;
        }
        finally {
            transaction.finish();
        }
    }
}

