/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration.validation;

import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.configuration.validation.RuleFailedException;
import org.neo4j.server.configuration.validation.WebadminConfigurationRule;

public class WebadminConfigurationRuleTest {
    private static final boolean theValidatorHasPassed = true;

    @Test(expected=RuleFailedException.class)
    public void shouldFailIfNoWebadminConfigSpecified() throws RuleFailedException {
        WebadminConfigurationRule rule = new WebadminConfigurationRule();
        BaseConfiguration emptyConfig = new BaseConfiguration();
        rule.validate((Configuration)emptyConfig);
        Assert.assertFalse((boolean)true);
    }

    @Test(expected=RuleFailedException.class)
    public void shouldFailIfOnlyRestApiKeySpecified() throws RuleFailedException {
        WebadminConfigurationRule rule = new WebadminConfigurationRule();
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty("org.neo4j.server.webadmin.data.uri", (Object)"http://localhost:7474/db/data");
        rule.validate((Configuration)config);
        Assert.assertFalse((boolean)true);
    }

    @Test(expected=RuleFailedException.class)
    public void shouldFailIfOnlyAdminApiKeySpecified() throws RuleFailedException {
        WebadminConfigurationRule rule = new WebadminConfigurationRule();
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty("org.neo4j.server.webadmin.management.uri", (Object)"http://localhost:7474/db/manage");
        rule.validate((Configuration)config);
        Assert.assertFalse((boolean)true);
    }

    @Test
    public void shouldAllowAbsoluteUris() throws RuleFailedException {
        WebadminConfigurationRule rule = new WebadminConfigurationRule();
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty("org.neo4j.server.webadmin.data.uri", (Object)"http://localhost:7474/db/data");
        config.addProperty("org.neo4j.server.webadmin.management.uri", (Object)"http://localhost:7474/db/manage");
        rule.validate((Configuration)config);
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void shouldAllowRelativeUris() throws RuleFailedException {
        WebadminConfigurationRule rule = new WebadminConfigurationRule();
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty("org.neo4j.server.webadmin.data.uri", (Object)"/db/data");
        config.addProperty("org.neo4j.server.webadmin.management.uri", (Object)"/db/manage");
        rule.validate((Configuration)config);
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void shouldNormaliseUris() throws RuleFailedException {
        WebadminConfigurationRule rule = new WebadminConfigurationRule();
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty("org.neo4j.server.webadmin.data.uri", (Object)"http://localhost:7474///db///data///");
        config.addProperty("org.neo4j.server.webadmin.management.uri", (Object)"http://localhost:7474////db///manage");
        rule.validate((Configuration)config);
        Assert.assertThat((Object)((String)config.getProperty("org.neo4j.server.webadmin.management.uri")), (Matcher)CoreMatchers.not((Matcher)Matchers.containsString((String)"///")));
        Assert.assertFalse((boolean)((String)config.getProperty("org.neo4j.server.webadmin.management.uri")).endsWith("//"));
        Assert.assertFalse((boolean)((String)config.getProperty("org.neo4j.server.webadmin.management.uri")).endsWith("/"));
        Assert.assertThat((Object)((String)config.getProperty("org.neo4j.server.webadmin.data.uri")), (Matcher)CoreMatchers.not((Matcher)Matchers.containsString((String)"///")));
        Assert.assertFalse((boolean)((String)config.getProperty("org.neo4j.server.webadmin.data.uri")).endsWith("//"));
        Assert.assertFalse((boolean)((String)config.getProperty("org.neo4j.server.webadmin.data.uri")).endsWith("/"));
    }
}

