/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.preflight;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.kernel.impl.recovery.StoreRecoverer;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.TestLogging;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.configuration.MapBasedConfiguration;
import org.neo4j.server.preflight.PerformRecoveryIfNecessary;
import org.neo4j.test.TargetDirectory;

public class TestPerformRecoveryIfNecessary {
    @Rule
    public TargetDirectory.TestDirectory testDir = TargetDirectory.testDirForTest(this.getClass());
    public String homeDirectory;
    public String storeDirectory;
    private static final String LINEBREAK = System.getProperty("line.separator");

    @Before
    public void createDirs() {
        this.homeDirectory = this.testDir.directory().getAbsolutePath();
        this.storeDirectory = new File(this.homeDirectory, "data" + File.separator + "graph.db").getAbsolutePath();
    }

    @Test
    public void shouldNotDoAnythingIfNoDBPresent() throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Configuration config = this.buildProperties();
        PerformRecoveryIfNecessary task = new PerformRecoveryIfNecessary(config, new HashMap(), new PrintStream(outputStream), DevNullLoggingService.DEV_NULL);
        Assert.assertThat((String)"Recovery task runs successfully.", (Object)task.run(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)"No database should have been created.", (Object)new File(this.storeDirectory).exists(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((String)"Recovery task should not print anything.", (Object)outputStream.toString(), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void doesNotPrintAnythingIfDatabaseWasCorrectlyShutdown() throws Exception {
        Configuration config = this.buildProperties();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        new GraphDatabaseFactory().newEmbeddedDatabase(this.storeDirectory).shutdown();
        PerformRecoveryIfNecessary task = new PerformRecoveryIfNecessary(config, new HashMap(), new PrintStream(outputStream), DevNullLoggingService.DEV_NULL);
        Assert.assertThat((String)"Recovery task should run successfully.", (Object)task.run(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)"Database should exist.", (Object)new File(this.storeDirectory).exists(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)"Recovery should not print anything.", (Object)outputStream.toString(), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void shouldPerformRecoveryIfNecessary() throws Exception {
        TestLogging logging = new TestLogging();
        StoreRecoverer recoverer = new StoreRecoverer();
        Configuration config = this.buildProperties();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        new GraphDatabaseFactory().newEmbeddedDatabase(this.storeDirectory).shutdown();
        new File(this.storeDirectory, "nioneo_logical.log.active").delete();
        Assert.assertThat((String)"Store should not be recovered", (Object)recoverer.recoveryNeededAt(new File(this.storeDirectory), new HashMap()), (Matcher)CoreMatchers.is((Object)true));
        PerformRecoveryIfNecessary task = new PerformRecoveryIfNecessary(config, new HashMap(), new PrintStream(outputStream), (Logging)logging);
        Assert.assertThat((String)"Recovery task should run successfully.", (Object)task.run(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)"Database should exist.", (Object)new File(this.storeDirectory).exists(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)"Recovery should print status message.", (Object)outputStream.toString(), (Matcher)CoreMatchers.is((Object)("Detected incorrectly shut down database, performing recovery.." + LINEBREAK)));
        Assert.assertThat((String)"Store should be recovered", (Object)recoverer.recoveryNeededAt(new File(this.storeDirectory), new HashMap()), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldNotPerformRecoveryIfNoNeostorePresent() throws Exception {
        new File(this.storeDirectory).mkdirs();
        new File(this.storeDirectory, "unrelated_file").createNewFile();
        boolean actual = new StoreRecoverer().recoveryNeededAt(new File(this.storeDirectory), new HashMap());
        Assert.assertThat((String)"Recovery should not be needed", (Object)actual, (Matcher)CoreMatchers.is((Object)false));
    }

    private Configuration buildProperties() throws IOException {
        FileUtils.deleteRecursively((File)new File(this.homeDirectory));
        new File(this.homeDirectory + "/conf").mkdirs();
        Properties databaseProperties = new Properties();
        String databasePropertiesFileName = this.homeDirectory + "/conf/neo4j.properties";
        databaseProperties.store(new FileWriter(databasePropertiesFileName), null);
        MapBasedConfiguration serverProperties = new MapBasedConfiguration();
        serverProperties.setProperty("org.neo4j.server.database.location", (Object)this.storeDirectory);
        serverProperties.setProperty("org.neo4j.server.db.tuning.properties", (Object)databasePropertiesFileName);
        return serverProperties;
    }
}

