/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest;

import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.Version;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.database.Database;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.preflight.PreFlightTasks;
import org.neo4j.server.web.WebServer;
import org.neo4j.server.webadmin.rest.AdvertisableService;
import org.neo4j.server.webadmin.rest.VersionAndEditionService;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class VersionAndEditionServiceTest {
    @Test
    public void shouldReturnReadableStringForServiceName() throws Exception {
        VersionAndEditionService service = new VersionAndEditionService((NeoServer)Mockito.mock(CommunityNeoServer.class));
        String serviceName = service.getName();
        Assert.assertEquals((Object)"version", (Object)serviceName);
    }

    @Test
    public void shouldReturnSensiblePathWhereServiceIsHosted() throws Exception {
        VersionAndEditionService service = new VersionAndEditionService((NeoServer)Mockito.mock(CommunityNeoServer.class));
        String serverPath = service.getServerPath();
        Assert.assertEquals((Object)"server/version", (Object)serverPath);
    }

    @Test
    public void shouldReturnDatabaseCommunityEditionAndVersion() throws Exception {
        AbstractNeoServer neoServer = this.setUpMocksAndStub(CommunityNeoServer.class);
        VersionAndEditionService service = new VersionAndEditionService((NeoServer)neoServer);
        Response response = service.getVersionAndEditionData();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"{version: \"2.0.0\", edition: \"community\"}", (Object)response.getEntity().toString());
    }

    @Test
    public void shouldReturnDatabaseAdvancedEditionAndVersion() throws Exception {
        AbstractNeoServer neoServer = this.setUpMocksAndStub(FakeAdvancedNeoServer.class);
        VersionAndEditionService service = new VersionAndEditionService((NeoServer)neoServer);
        Response response = service.getVersionAndEditionData();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"{version: \"2.0.0\", edition: \"advanced\"}", (Object)response.getEntity().toString());
    }

    @Test
    public void shouldReturnDatabaseEnterpriseEditionAndVersion() throws Exception {
        AbstractNeoServer neoServer = this.setUpMocksAndStub(FakeEnterpriseNeoServer.class);
        VersionAndEditionService service = new VersionAndEditionService((NeoServer)neoServer);
        Response response = service.getVersionAndEditionData();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"{version: \"2.0.0\", edition: \"enterprise\"}", (Object)response.getEntity().toString());
    }

    private AbstractNeoServer setUpMocksAndStub(Class<? extends AbstractNeoServer> serverClass) {
        AbstractNeoServer neoServer = (AbstractNeoServer)Mockito.mock(serverClass);
        Database database = (Database)Mockito.mock(Database.class);
        GraphDatabaseAPI graphDatabaseAPI = (GraphDatabaseAPI)Mockito.mock(GraphDatabaseAPI.class);
        Version version = (Version)Mockito.mock(Version.class);
        KernelData kernelData = this.stubKernelData(graphDatabaseAPI, version);
        Mockito.when((Object)version.getReleaseVersion()).thenReturn((Object)"2.0.0");
        DependencyResolver dependencyResolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        Mockito.when((Object)graphDatabaseAPI.getDependencyResolver()).thenReturn((Object)dependencyResolver);
        Mockito.when((Object)dependencyResolver.resolveDependency(KernelData.class)).thenReturn((Object)kernelData);
        Mockito.when((Object)database.getGraph()).thenReturn((Object)graphDatabaseAPI);
        Mockito.when((Object)neoServer.getDatabase()).thenReturn((Object)database);
        return neoServer;
    }

    private KernelData stubKernelData(final GraphDatabaseAPI graphDatabaseAPI, final Version version) {
        return new KernelData(new Config()){

            public Version version() {
                return version;
            }

            public GraphDatabaseAPI graphDatabase() {
                return graphDatabaseAPI;
            }
        };
    }

    private class FakeEnterpriseNeoServer
    extends FakeAdvancedNeoServer {
        public FakeEnterpriseNeoServer(Configurator configurator, Database.Factory dbFactory) {
            super(configurator, dbFactory);
        }
    }

    private class FakeAdvancedNeoServer
    extends AbstractNeoServer {
        public FakeAdvancedNeoServer(Configurator configurator, Database.Factory dbFactory) {
            super(configurator, dbFactory, DevNullLoggingService.DEV_NULL);
        }

        protected PreFlightTasks createPreflightTasks() {
            throw new NotImplementedException();
        }

        protected Iterable<ServerModule> createServerModules() {
            throw new NotImplementedException();
        }

        protected WebServer createWebServer() {
            throw new NotImplementedException();
        }

        public Iterable<AdvertisableService> getServices() {
            throw new NotImplementedException();
        }
    }
}

