/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webdriver;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;

public class ElementVisible
extends BaseMatcher<WebDriver> {
    private final By by;

    public static ElementVisible elementVisible(By by) {
        return new ElementVisible(by);
    }

    public ElementVisible(By by) {
        this.by = by;
    }

    public boolean matches(Object item) {
        if (item instanceof WebDriver) {
            WebDriver d = (WebDriver)item;
            try {
                return !d.findElement(this.by).getCssValue("display").equals("none");
            }
            catch (NoSuchElementException e) {
                return false;
            }
            catch (StaleElementReferenceException e) {
                return false;
            }
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("Element should be visible.");
    }
}

