/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rrd;

import java.io.IOException;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.server.rrd.RrdSamplerImpl;
import org.neo4j.server.rrd.Sampleable;
import org.neo4j.server.rrd.UnableToSampleException;
import org.rrd4j.DsType;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.Sample;

public class RrdSamplerTest {
    @Test
    public void canSampleADatabase() throws IOException {
        TestSamplable testSamplable = new TestSamplable("myTest", 15.0);
        RrdDb rrd = (RrdDb)Mockito.mock(RrdDb.class);
        Sample sample = (Sample)Mockito.mock(Sample.class);
        Mockito.when((Object)rrd.createSample(Matchers.anyLong())).thenReturn((Object)sample);
        RrdSamplerImpl sampler = new RrdSamplerImpl(rrd, new Sampleable[]{testSamplable});
        sampler.updateSample();
        ((Sample)Mockito.verify((Object)sample)).setValue("myTest", 15.0);
    }

    @Test
    public void shouldIgnoreUnableToSampleExceptions() throws IOException {
        FailingSamplable failingSampleable = new FailingSamplable("myTest");
        RrdDb rrd = (RrdDb)Mockito.mock(RrdDb.class);
        Sample sample = (Sample)Mockito.mock(Sample.class);
        Mockito.when((Object)rrd.createSample(Matchers.anyLong())).thenReturn((Object)sample);
        RrdSamplerImpl sampler = new RrdSamplerImpl(rrd, new Sampleable[]{failingSampleable});
        sampler.updateSample();
        ((Sample)Mockito.verify((Object)sample, (VerificationMode)Mockito.never())).setValue("myTest", 15.0);
    }

    private class FailingSamplable
    implements Sampleable {
        private String name;

        private FailingSamplable(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public double getValue() {
            throw new UnableToSampleException();
        }

        public DsType getType() {
            return DsType.GAUGE;
        }
    }

    private class TestSamplable
    implements Sampleable {
        private String name;
        private double value;

        private TestSamplable(String name, double value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public double getValue() {
            return this.value;
        }

        public DsType getType() {
            return DsType.GAUGE;
        }
    }
}

