/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import com.sun.jersey.api.client.Client;
import java.net.URI;
import javax.ws.rs.core.MediaType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.ServerHelper;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class RedirectToBrowserTest
extends ExclusiveServerTestBase {
    private NeoServer server;

    @After
    public void stopServer() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void shouldRedirectToBrowser() throws Exception {
        this.server = ServerHelper.createNonPersistentServer();
        Client nonRedirectingClient = Client.create();
        nonRedirectingClient.setFollowRedirects(Boolean.valueOf(false));
        JaxRsResponse response = new RestRequest(this.server.baseUri(), nonRedirectingClient).accept(MediaType.TEXT_HTML_TYPE).get(this.server.baseUri().toString());
        Assert.assertEquals((long)303L, (long)response.getStatus());
        Assert.assertEquals((Object)new URI("http://localhost:7474/browser"), (Object)response.getLocation());
        response.close();
    }

    @Test
    public void shouldRedirectToBrowserUsingXForwardedHeaders() throws Exception {
        this.server = ServerHelper.createNonPersistentServer();
        Client nonRedirectingClient = Client.create();
        nonRedirectingClient.setFollowRedirects(Boolean.valueOf(false));
        JaxRsResponse response = new RestRequest(this.server.baseUri(), nonRedirectingClient).accept(MediaType.TEXT_HTML_TYPE).header("X-Forwarded-Host", "foo.bar:8734").header("X-Forwarded-Proto", "https").get(this.server.baseUri().toString());
        Assert.assertEquals((long)303L, (long)response.getStatus());
        Assert.assertEquals((Object)new URI("https://foo.bar:8734/browser"), (Object)response.getLocation());
        response.close();
    }
}

