/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.logging.BufferingConsoleLogger;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.server.configuration.DatabaseTuningPropertyFileBuilder;
import org.neo4j.server.configuration.PropertyFileBuilder;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.server.configuration.validation.Validator;
import org.neo4j.test.Mute;

public class PropertyFileConfiguratorTest {
    @Rule
    public Mute mute = Mute.muteAll();
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void whenDatabaseTuningFilePresentInDefaultLocationShouldLoadItEvenIfNotSpecified() throws IOException {
        File emptyPropertyFile = PropertyFileBuilder.builder(this.folder.getRoot()).build();
        DatabaseTuningPropertyFileBuilder.builder(this.folder.getRoot()).build();
        PropertyFileConfigurator configurator = new PropertyFileConfigurator(emptyPropertyFile);
        Assert.assertNotNull(configurator.getDatabaseTuningProperties().get("neostore.nodestore.db.mapped_memory"));
        Assert.assertEquals((Object)"25M", configurator.getDatabaseTuningProperties().get("neostore.nodestore.db.mapped_memory"));
    }

    @Test
    public void whenDatabaseTuningFilePresentInDefaultLocationShouldNotLoadIfAnotherSpecified() throws IOException {
        int unlikelyDefaultMemoryMappedValue = 8351;
        File databaseTuningPropertyFileWeWantToUse = DatabaseTuningPropertyFileBuilder.builder(this.folder.getRoot()).mappedMemory(unlikelyDefaultMemoryMappedValue).build();
        File emptyPropertyFile = PropertyFileBuilder.builder(this.folder.getRoot()).withDbTuningPropertyFile(databaseTuningPropertyFileWeWantToUse).build();
        DatabaseTuningPropertyFileBuilder.builder(this.folder.newFolder()).build();
        PropertyFileConfigurator configurator = new PropertyFileConfigurator(emptyPropertyFile);
        Assert.assertNotNull(configurator.getDatabaseTuningProperties().get("neostore.nodestore.db.mapped_memory"));
        Assert.assertEquals((Object)(String.valueOf(unlikelyDefaultMemoryMappedValue) + "M"), configurator.getDatabaseTuningProperties().get("neostore.nodestore.db.mapped_memory"));
    }

    @Test
    public void shouldLogInfoWhenDefaultingToTuningPropertiesFileInTheSameDirectoryAsTheNeoServerPropertiesFile() throws IOException {
        File emptyPropertyFile = PropertyFileBuilder.builder(this.folder.getRoot()).build();
        File tuningPropertiesFile = DatabaseTuningPropertyFileBuilder.builder(this.folder.getRoot()).build();
        BufferingConsoleLogger logger = new BufferingConsoleLogger();
        new PropertyFileConfigurator(Validator.NO_VALIDATION, emptyPropertyFile, (ConsoleLogger)logger);
        Assert.assertThat((Object)logger.toString(), (Matcher)Matchers.containsString((String)String.format("No database tuning file explicitly set, defaulting to [%s]", tuningPropertiesFile.getAbsolutePath())));
    }

    @Test
    public void shouldRetainRegistrationOrderOfThirdPartyJaxRsPackages() throws IOException {
        File propertyFile = PropertyFileBuilder.builder(this.folder.getRoot()).withNameValue("org.neo4j.server.thirdparty_jaxrs_classes", "org.neo4j.extension.extension1=/extension1,org.neo4j.extension.extension2=/extension2,org.neo4j.extension.extension3=/extension3").build();
        PropertyFileConfigurator propertyFileConfigurator = new PropertyFileConfigurator(propertyFile);
        List thirdpartyJaxRsPackages = propertyFileConfigurator.getThirdpartyJaxRsPackages();
        Assert.assertEquals((long)3L, (long)thirdpartyJaxRsPackages.size());
        Assert.assertEquals((Object)"/extension1", (Object)((ThirdPartyJaxRsPackage)thirdpartyJaxRsPackages.get(0)).getMountPoint());
        Assert.assertEquals((Object)"/extension2", (Object)((ThirdPartyJaxRsPackage)thirdpartyJaxRsPackages.get(1)).getMountPoint());
        Assert.assertEquals((Object)"/extension3", (Object)((ThirdPartyJaxRsPackage)thirdpartyJaxRsPackages.get(2)).getMountPoint());
    }

    @Test
    public void shouldSetStoreDirSetting() throws Exception {
        String dbLocation = "/tmp/deosntmatter";
        File propertyFile = PropertyFileBuilder.builder(this.folder.getRoot()).withNameValue("org.neo4j.server.database.location", dbLocation).build();
        PropertyFileConfigurator serverConfig = new PropertyFileConfigurator(propertyFile);
        Map properties = serverConfig.getDatabaseTuningProperties();
        Assert.assertThat(properties.get(GraphDatabaseSettings.store_dir.name()), (Matcher)CoreMatchers.equalTo((Object)dbLocation));
    }
}

