/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import com.sun.jersey.spi.container.ContainerRequest;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.server.rest.web.CollectUserAgentFilter;
import org.neo4j.test.Mute;

public class CollectUserAgentFilterTest {
    private final CollectUserAgentFilter filter = new CollectUserAgentFilter();
    @Rule
    public Mute mute = Mute.muteAll();

    @Test
    public void shouldRecordASingleUserAgent() {
        this.filter.filter(CollectUserAgentFilterTest.request("the-agent"));
        Assert.assertThat((Object)this.filter.getUserAgents(), (Matcher)org.hamcrest.Matchers.hasItem((Object)"the-agent"));
    }

    @Test
    public void shouldOnlyRecordTheFirstFieldOfTheUserAgentString() {
        this.filter.filter(CollectUserAgentFilterTest.request("the-agent other-info"));
        Assert.assertThat((Object)this.filter.getUserAgents(), (Matcher)org.hamcrest.Matchers.hasItem((Object)"the-agent"));
    }

    @Test
    public void shouldRecordMultipleUserAgents() {
        this.filter.filter(CollectUserAgentFilterTest.request("agent1"));
        this.filter.filter(CollectUserAgentFilterTest.request("agent2"));
        Assert.assertThat((Object)this.filter.getUserAgents(), (Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"agent1", "agent2"}));
    }

    @Test
    public void shouldNotReportDuplicates() {
        this.filter.filter(CollectUserAgentFilterTest.request("the-agent"));
        this.filter.filter(CollectUserAgentFilterTest.request("the-agent"));
        Assert.assertThat((Object)this.filter.getUserAgents(), (Matcher)org.hamcrest.Matchers.hasSize((int)1));
    }

    @Test
    public void shouldClearRecordedValues() {
        this.filter.filter(CollectUserAgentFilterTest.request("the-agent"));
        this.filter.reset();
        Assert.assertThat((Object)this.filter.getUserAgents(), (Matcher)org.hamcrest.Matchers.hasSize((int)0));
    }

    @Test
    public void shouldCopeIfThereIsNoUserAgentHeader() {
        this.filter.filter(CollectUserAgentFilterTest.request(new String[0]));
        Assert.assertThat((Object)this.filter.getUserAgents(), (Matcher)org.hamcrest.Matchers.hasSize((int)0));
    }

    @Test
    public void shouldCopeIfThereIsMoreThanOneUserAgentHeader() {
        this.filter.filter(CollectUserAgentFilterTest.request("agent1", "agent2"));
        Assert.assertThat((Object)this.filter.getUserAgents(), (Matcher)org.hamcrest.Matchers.hasSize((int)1));
    }

    @Test
    public void shouldSwallowAnyExceptionsThrownByTheRequest() {
        ContainerRequest request = (ContainerRequest)Mockito.mock(ContainerRequest.class);
        Mockito.stub((Object)request.getRequestHeader(Matchers.anyString())).toThrow((Throwable)new RuntimeException());
        this.filter.filter(request);
    }

    @Test
    public void shouldReturnTheRequest() {
        ContainerRequest original = CollectUserAgentFilterTest.request("the-agent");
        ContainerRequest returned = this.filter.filter(original);
        Assert.assertSame((Object)original, (Object)returned);
    }

    private static ContainerRequest request(String ... userAgent) {
        ContainerRequest request = (ContainerRequest)Mockito.mock(ContainerRequest.class);
        List<String> headers = Arrays.asList(userAgent);
        Mockito.stub((Object)request.getRequestHeader("User-Agent")).toReturn(headers);
        return request;
    }
}

