/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.codehaus.jackson.JsonGenerator;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.server.rest.transactional.Neo4jJsonCodec;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={JsonGenerator.class})
public class Neo4jJsonCodecTest {
    private Neo4jJsonCodec jsonCodec;
    private JsonGenerator jsonGenerator;

    @Before
    public void init() throws IOException {
        this.jsonCodec = new Neo4jJsonCodec();
        this.jsonGenerator = (JsonGenerator)PowerMockito.mock(JsonGenerator.class);
    }

    @Test
    public void testPropertyContainerWriting() throws IOException {
        PropertyContainer propertyContainer = (PropertyContainer)PowerMockito.mock(PropertyContainer.class);
        PowerMockito.when((Object)propertyContainer.getPropertyKeys()).thenThrow(new Class[]{RuntimeException.class});
        try {
            this.jsonCodec.writeValue(this.jsonGenerator, (Object)propertyContainer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)1))).writeEndObject();
    }

    @Test
    public void testPathWriting() throws IOException {
        Path path = (Path)PowerMockito.mock(Path.class);
        PropertyContainer propertyContainer = (PropertyContainer)PowerMockito.mock(PropertyContainer.class);
        PowerMockito.when((Object)propertyContainer.getPropertyKeys()).thenThrow(new Class[]{RuntimeException.class});
        PowerMockito.when((Object)path.iterator()).thenReturn(Arrays.asList(propertyContainer).listIterator());
        try {
            this.jsonCodec.writeValue(this.jsonGenerator, (Object)path);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)1))).writeEndArray();
    }

    @Test
    public void testIteratorWriting() throws IOException {
        PropertyContainer propertyContainer = (PropertyContainer)PowerMockito.mock(PropertyContainer.class);
        PowerMockito.when((Object)propertyContainer.getPropertyKeys()).thenThrow(new Class[]{RuntimeException.class});
        try {
            this.jsonCodec.writeValue(this.jsonGenerator, Arrays.asList(propertyContainer));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)1))).writeEndArray();
    }

    @Test
    public void testByteArrayWriting() throws IOException {
        ((JsonGenerator)PowerMockito.doThrow((Throwable)new RuntimeException()).when((Object)this.jsonGenerator)).writeNumber(Matchers.anyInt());
        byte[] byteArray = new byte[]{1, 2, 3};
        try {
            this.jsonCodec.writeValue(this.jsonGenerator, (Object)byteArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)1))).writeEndArray();
    }

    @Test
    public void testMapWriting() throws IOException {
        ((JsonGenerator)PowerMockito.doThrow((Throwable)new RuntimeException()).when((Object)this.jsonGenerator)).writeFieldName(Matchers.anyString());
        try {
            this.jsonCodec.writeValue(this.jsonGenerator, new HashMap());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)1))).writeEndObject();
    }
}

