/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.FakeClock;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.WrappedDatabase;
import org.neo4j.server.helpers.ServerHelper;
import org.neo4j.server.rest.domain.EndNodeNotFoundException;
import org.neo4j.server.rest.domain.GraphDbHelper;
import org.neo4j.server.rest.domain.StartNodeNotFoundException;
import org.neo4j.server.rest.domain.TraverserReturnType;
import org.neo4j.server.rest.paging.LeaseManager;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.NodeRepresentationTest;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentationTest;
import org.neo4j.server.rest.repr.RepresentationTestAccess;
import org.neo4j.server.rest.web.DatabaseActions;
import org.neo4j.server.rest.web.NoSuchPropertyException;
import org.neo4j.server.rest.web.NodeNotFoundException;
import org.neo4j.server.rest.web.OperationFailureException;
import org.neo4j.server.rest.web.PropertyValueException;
import org.neo4j.server.rest.web.TransactionWrappedDatabaseActions;
import org.neo4j.test.TestGraphDatabaseFactory;

public class DatabaseActionsTest {
    private static final Label LABEL = DynamicLabel.label((String)"Label");
    private static GraphDbHelper graphdbHelper;
    private static Database database;
    private static AbstractGraphDatabase graph;
    private static DatabaseActions actions;

    @BeforeClass
    public static void createDb() throws IOException {
        graph = (AbstractGraphDatabase)new TestGraphDatabaseFactory().newImpermanentDatabase();
        database = new WrappedDatabase((GraphDatabaseAPI)graph);
        graphdbHelper = new GraphDbHelper(database);
        actions = new TransactionWrappedDatabaseActions(new LeaseManager((Clock)new FakeClock()), ForceMode.forced, database.getGraph());
    }

    @AfterClass
    public static void shutdownDatabase() throws Throwable {
        graph.shutdown();
    }

    @After
    public void clearDb() {
        ServerHelper.cleanTheDatabase((GraphDatabaseAPI)graph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createNode(Map<String, Object> properties) {
        long nodeId;
        Transaction tx = database.getGraph().beginTx();
        try {
            Node node = database.getGraph().createNode(new Label[]{LABEL});
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                node.setProperty(entry.getKey(), entry.getValue());
            }
            nodeId = node.getId();
            tx.success();
        }
        finally {
            tx.finish();
        }
        return nodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createdNodeShouldBeInDatabase() throws Exception {
        NodeRepresentation noderep = actions.createNode(Collections.emptyMap(), new Label[0]);
        Transaction tx = database.getGraph().beginTx();
        try {
            Assert.assertNotNull((Object)database.getGraph().getNodeById(noderep.getId()));
        }
        finally {
            tx.finish();
        }
    }

    @Test
    public void nodeInDatabaseShouldBeRetrievable() throws NodeNotFoundException {
        long nodeId = new GraphDbHelper(database).createNode(new Label[0]);
        Assert.assertNotNull((Object)actions.getNode(nodeId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToStorePropertiesInAnExistingNode() throws PropertyValueException, NodeNotFoundException {
        long nodeId = graphdbHelper.createNode(new Label[0]);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("foo", "bar");
        properties.put("baz", 17);
        actions.setAllNodeProperties(nodeId, properties);
        Transaction tx = database.getGraph().beginTx();
        try {
            Node node = database.getGraph().getNodeById(nodeId);
            this.assertHasProperties((PropertyContainer)node, properties);
        }
        finally {
            tx.finish();
        }
    }

    @Test(expected=PropertyValueException.class)
    public void shouldFailOnTryingToStoreMixedArraysAsAProperty() throws Exception {
        long nodeId = graphdbHelper.createNode(new Label[0]);
        HashMap<String, Object[]> properties = new HashMap<String, Object[]>();
        Object[] dodgyArray = new Object[]{0, 1, "two"};
        properties.put("foo", dodgyArray);
        actions.setAllNodeProperties(nodeId, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldOverwriteExistingProperties() throws PropertyValueException, NodeNotFoundException {
        long nodeId;
        Transaction tx = database.getGraph().beginTx();
        try {
            Node node = database.getGraph().createNode();
            node.setProperty("remove me", (Object)"trash");
            nodeId = node.getId();
            tx.success();
        }
        finally {
            tx.finish();
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("foo", "bar");
        properties.put("baz", 17);
        actions.setAllNodeProperties(nodeId, properties);
        tx = database.getGraph().beginTx();
        try {
            Node node = database.getGraph().getNodeById(nodeId);
            this.assertHasProperties((PropertyContainer)node, properties);
            Assert.assertNull((Object)node.getProperty("remove me", null));
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToGetPropertiesOnNode() throws NodeNotFoundException {
        long nodeId;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("foo", "bar");
        properties.put("neo", "Thomas A. Anderson");
        properties.put("number", 15L);
        Transaction tx = database.getGraph().beginTx();
        try {
            Node node = database.getGraph().createNode();
            for (Map.Entry entry : properties.entrySet()) {
                node.setProperty((String)entry.getKey(), entry.getValue());
            }
            nodeId = node.getId();
            tx.success();
        }
        finally {
            tx.finish();
        }
        Transaction transaction = graph.beginTx();
        try {
            Assert.assertEquals(properties, RepresentationTestAccess.serialize((MappingRepresentation)actions.getAllNodeProperties(nodeId)));
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRemoveNodeWithNoRelationsFromDBOnDelete() throws NodeNotFoundException, OperationFailureException {
        long nodeId;
        Transaction tx = database.getGraph().beginTx();
        try {
            Node node = database.getGraph().createNode();
            nodeId = node.getId();
            tx.success();
        }
        finally {
            tx.finish();
        }
        int nodeCount = graphdbHelper.getNumberOfNodes();
        actions.deleteNode(nodeId);
        Assert.assertEquals((long)(nodeCount - 1), (long)graphdbHelper.getNumberOfNodes());
    }

    @Test
    public void shouldBeAbleToSetPropertyOnNode() throws Exception {
        long nodeId = this.createNode(Collections.emptyMap());
        String key = "foo";
        String value = "bar";
        actions.setNodeProperty(nodeId, key, (Object)value);
        Assert.assertEquals(Collections.singletonMap(key, value), graphdbHelper.getNodeProperties(nodeId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void settingAnEmptyArrayShouldWorkIfOriginalEntityHasAnEmptyArrayAsWell() throws Exception {
        long nodeId = this.createNode(MapUtil.map((Object[])new Object[]{"emptyArray", new int[0]}));
        actions.setNodeProperty(nodeId, "emptyArray", new ArrayList());
        Transaction transaction = graph.beginTx();
        try {
            MatcherAssert.assertThat((Object)((List)RepresentationTestAccess.serialize(actions.getNodeProperty(nodeId, "emptyArray"))).size(), (Matcher)Matchers.is((Object)0));
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToGetPropertyOnNode() throws Exception {
        String key = "foo";
        String value = "bar";
        long nodeId = this.createNode(Collections.singletonMap(key, value));
        Transaction transaction = graph.beginTx();
        try {
            Assert.assertEquals((Object)value, (Object)RepresentationTestAccess.serialize(actions.getNodeProperty(nodeId, key)));
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToRemoveNodeProperties() throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("foo", "bar");
        properties.put("number", 15);
        long nodeId = this.createNode(properties);
        actions.removeAllNodeProperties(nodeId);
        Transaction tx = database.getGraph().beginTx();
        try {
            Node node = database.getGraph().getNodeById(nodeId);
            Assert.assertEquals((Object)false, (Object)node.getPropertyKeys().iterator().hasNext());
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    @Test
    public void shouldStoreRelationshipsBetweenTwoExistingNodes() throws Exception {
        int relationshipCount = graphdbHelper.getNumberOfRelationships();
        actions.createRelationship(graphdbHelper.createNode(new Label[0]), graphdbHelper.createNode(new Label[0]), "LOVES", Collections.emptyMap());
        Assert.assertEquals((long)(relationshipCount + 1), (long)graphdbHelper.getNumberOfRelationships());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldStoreSuppliedPropertiesWhenCreatingRelationship() throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("string", "value");
        properties.put("integer", 17);
        long relId = actions.createRelationship(graphdbHelper.createNode(new Label[0]), graphdbHelper.createNode(new Label[0]), "LOVES", properties).getId();
        Transaction tx = database.getGraph().beginTx();
        try {
            Relationship rel = database.getGraph().getRelationshipById(relId);
            for (String string : rel.getPropertyKeys()) {
                Assert.assertTrue((String)"extra property stored", (boolean)properties.containsKey(string));
            }
            for (Map.Entry entry : properties.entrySet()) {
                Assert.assertEquals(entry.getValue(), (Object)rel.getProperty((String)entry.getKey()));
            }
        }
        finally {
            tx.finish();
        }
    }

    @Test
    public void shouldNotCreateRelationshipBetweenNonExistentNodes() throws Exception {
        long nodeId = graphdbHelper.createNode(new Label[0]);
        Map properties = Collections.emptyMap();
        try {
            actions.createRelationship(nodeId, nodeId * 1000L, "Loves", properties);
            Assert.fail();
        }
        catch (EndNodeNotFoundException e) {
            // empty catch block
        }
        try {
            actions.createRelationship(nodeId * 1000L, nodeId, "Loves", properties);
            Assert.fail();
        }
        catch (StartNodeNotFoundException e) {
            // empty catch block
        }
    }

    @Test
    public void shouldAllowCreateRelationshipWithSameStartAsEndNode() throws Exception {
        long nodeId = graphdbHelper.createNode(new Label[0]);
        Map properties = Collections.emptyMap();
        RelationshipRepresentation rel = actions.createRelationship(nodeId, nodeId, "Loves", properties);
        Assert.assertNotNull((Object)rel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToRemoveNodeProperty() throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("foo", "bar");
        properties.put("number", 15);
        long nodeId = this.createNode(properties);
        actions.removeNodeProperty(nodeId, "foo");
        Transaction tx = database.getGraph().beginTx();
        try {
            Node node = database.getGraph().getNodeById(nodeId);
            Assert.assertEquals((Object)15, (Object)node.getProperty("number"));
            Assert.assertEquals((Object)false, (Object)node.hasProperty("foo"));
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    @Test
    public void shouldReturnTrueIfNodePropertyRemoved() throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("foo", "bar");
        properties.put("number", 15);
        long nodeId = this.createNode(properties);
        actions.removeNodeProperty(nodeId, "foo");
    }

    @Test(expected=NoSuchPropertyException.class)
    public void shouldReturnFalseIfNodePropertyNotRemoved() throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("foo", "bar");
        properties.put("number", 15);
        long nodeId = this.createNode(properties);
        actions.removeNodeProperty(nodeId, "baz");
    }

    @Test
    public void shouldBeAbleToRetrieveARelationship() throws Exception {
        long relationship = graphdbHelper.createRelationship("ENJOYED");
        Assert.assertNotNull((Object)actions.getRelationship(relationship));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToGetPropertiesOnRelationship() throws Exception {
        long relationshipId;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("foo", "bar");
        properties.put("neo", "Thomas A. Anderson");
        properties.put("number", 15L);
        Transaction tx = database.getGraph().beginTx();
        try {
            Node startNode = database.getGraph().createNode();
            Node endNode = database.getGraph().createNode();
            Relationship relationship = startNode.createRelationshipTo(endNode, (RelationshipType)DynamicRelationshipType.withName((String)"knows"));
            for (Map.Entry entry : properties.entrySet()) {
                relationship.setProperty((String)entry.getKey(), entry.getValue());
            }
            relationshipId = relationship.getId();
            tx.success();
        }
        finally {
            tx.finish();
        }
        Transaction transaction = graph.beginTx();
        try {
            Assert.assertEquals(properties, RepresentationTestAccess.serialize((MappingRepresentation)actions.getAllRelationshipProperties(relationshipId)));
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToRetrieveASinglePropertyFromARelationship() throws Exception {
        Object relationshipProperty;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("foo", "bar");
        properties.put("neo", "Thomas A. Anderson");
        properties.put("number", 15L);
        long relationshipId = graphdbHelper.createRelationship("LOVES");
        graphdbHelper.setRelationshipProperties(relationshipId, properties);
        Transaction transaction = graph.beginTx();
        try {
            relationshipProperty = RepresentationTestAccess.serialize(actions.getRelationshipProperty(relationshipId, "foo"));
        }
        finally {
            transaction.finish();
        }
        Assert.assertEquals((Object)"bar", (Object)relationshipProperty);
    }

    @Test
    public void shouldBeAbleToDeleteARelationship() throws Exception {
        long relationshipId = graphdbHelper.createRelationship("LOVES");
        actions.deleteRelationship(relationshipId);
        try {
            graphdbHelper.getRelationship(relationshipId);
            Assert.fail();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToRetrieveRelationshipsFromNode() throws Exception {
        long nodeId = graphdbHelper.createNode(new Label[0]);
        graphdbHelper.createRelationship("LIKES", nodeId, graphdbHelper.createNode(new Label[0]));
        graphdbHelper.createRelationship("LIKES", graphdbHelper.createNode(new Label[0]), nodeId);
        graphdbHelper.createRelationship("HATES", nodeId, graphdbHelper.createNode(new Label[0]));
        Transaction transaction = graph.beginTx();
        try {
            this.verifyRelReps(3, actions.getNodeRelationships(nodeId, DatabaseActions.RelationshipDirection.all, Collections.emptyList()));
            this.verifyRelReps(1, actions.getNodeRelationships(nodeId, DatabaseActions.RelationshipDirection.in, Collections.emptyList()));
            this.verifyRelReps(2, actions.getNodeRelationships(nodeId, DatabaseActions.RelationshipDirection.out, Collections.emptyList()));
            this.verifyRelReps(3, actions.getNodeRelationships(nodeId, DatabaseActions.RelationshipDirection.all, Arrays.asList("LIKES", "HATES")));
            this.verifyRelReps(1, actions.getNodeRelationships(nodeId, DatabaseActions.RelationshipDirection.in, Arrays.asList("LIKES", "HATES")));
            this.verifyRelReps(2, actions.getNodeRelationships(nodeId, DatabaseActions.RelationshipDirection.out, Arrays.asList("LIKES", "HATES")));
            this.verifyRelReps(2, actions.getNodeRelationships(nodeId, DatabaseActions.RelationshipDirection.all, Arrays.asList("LIKES")));
            this.verifyRelReps(1, actions.getNodeRelationships(nodeId, DatabaseActions.RelationshipDirection.in, Arrays.asList("LIKES")));
            this.verifyRelReps(1, actions.getNodeRelationships(nodeId, DatabaseActions.RelationshipDirection.out, Arrays.asList("LIKES")));
            this.verifyRelReps(1, actions.getNodeRelationships(nodeId, DatabaseActions.RelationshipDirection.all, Arrays.asList("HATES")));
            this.verifyRelReps(0, actions.getNodeRelationships(nodeId, DatabaseActions.RelationshipDirection.in, Arrays.asList("HATES")));
            this.verifyRelReps(1, actions.getNodeRelationships(nodeId, DatabaseActions.RelationshipDirection.out, Arrays.asList("HATES")));
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotGetAnyRelationshipsWhenRetrievingFromNodeWithoutRelationships() throws Exception {
        long nodeId = graphdbHelper.createNode(new Label[0]);
        Transaction transaction = graph.beginTx();
        try {
            this.verifyRelReps(0, actions.getNodeRelationships(nodeId, DatabaseActions.RelationshipDirection.all, Collections.emptyList()));
            this.verifyRelReps(0, actions.getNodeRelationships(nodeId, DatabaseActions.RelationshipDirection.in, Collections.emptyList()));
            this.verifyRelReps(0, actions.getNodeRelationships(nodeId, DatabaseActions.RelationshipDirection.out, Collections.emptyList()));
        }
        finally {
            transaction.finish();
        }
    }

    @Test
    public void shouldBeAbleToSetRelationshipProperties() throws Exception {
        long relationshipId = graphdbHelper.createRelationship("KNOWS");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("foo", "bar");
        properties.put("number", 10);
        actions.setAllRelationshipProperties(relationshipId, properties);
        Assert.assertEquals(properties, graphdbHelper.getRelationshipProperties(relationshipId));
    }

    @Test
    public void shouldBeAbleToSetRelationshipProperty() throws Exception {
        long relationshipId = graphdbHelper.createRelationship("KNOWS");
        String key = "foo";
        String value = "bar";
        actions.setRelationshipProperty(relationshipId, key, (Object)value);
        Assert.assertEquals(Collections.singletonMap(key, value), graphdbHelper.getRelationshipProperties(relationshipId));
    }

    @Test
    public void shouldRemoveRelationProperties() throws Exception {
        long relId = graphdbHelper.createRelationship("PAIR-PROGRAMS_WITH");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("foo", "bar");
        map.put("baz", 22);
        graphdbHelper.setRelationshipProperties(relId, map);
        actions.removeAllRelationshipProperties(relId);
        Assert.assertTrue((boolean)graphdbHelper.getRelationshipProperties(relId).isEmpty());
    }

    @Test
    public void shouldRemoveRelationshipProperty() throws Exception {
        long relId = graphdbHelper.createRelationship("PAIR-PROGRAMS_WITH");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("foo", "bar");
        map.put("baz", 22);
        graphdbHelper.setRelationshipProperties(relId, map);
        actions.removeRelationshipProperty(relId, "foo");
        Assert.assertEquals((long)1L, (long)graphdbHelper.getRelationshipProperties(relId).size());
    }

    private void verifyRelReps(int expectedSize, ListRepresentation repr) {
        List<Object> relreps = RepresentationTestAccess.serialize(repr);
        Assert.assertEquals((long)expectedSize, (long)relreps.size());
        for (Object relrep : relreps) {
            RelationshipRepresentationTest.verifySerialisation((Map)relrep);
        }
    }

    private void assertHasProperties(PropertyContainer container, Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            Assert.assertEquals((Object)entry.getValue(), (Object)container.getProperty(entry.getKey()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToIndexNode() {
        List<Object> listOfIndexedNodes;
        String key = "mykey";
        String value = "myvalue";
        long nodeId = graphdbHelper.createNode(new Label[0]);
        String indexName = "node";
        actions.createNodeIndex(MapUtil.map((Object[])new Object[]{"name", indexName}));
        Transaction transaction = graph.beginTx();
        try {
            listOfIndexedNodes = RepresentationTestAccess.serialize(actions.getIndexedNodes(indexName, key, value));
        }
        finally {
            transaction.finish();
        }
        Assert.assertFalse((boolean)listOfIndexedNodes.iterator().hasNext());
        actions.addToNodeIndex(indexName, key, value, nodeId);
        Assert.assertEquals(Arrays.asList(nodeId), graphdbHelper.getIndexedNodes(indexName, key, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToFulltextIndex() {
        String key = "key";
        String value = "the value with spaces";
        long nodeId = graphdbHelper.createNode(new Label[0]);
        String indexName = "fulltext-node";
        graphdbHelper.createNodeFullTextIndex(indexName);
        Transaction transaction = graph.beginTx();
        try {
            Assert.assertFalse((boolean)RepresentationTestAccess.serialize(actions.getIndexedNodes(indexName, key, value)).iterator().hasNext());
        }
        finally {
            transaction.finish();
        }
        actions.addToNodeIndex(indexName, key, value, nodeId);
        Assert.assertEquals(Arrays.asList(nodeId), graphdbHelper.getIndexedNodes(indexName, key, value));
        Assert.assertEquals(Arrays.asList(nodeId), graphdbHelper.getIndexedNodes(indexName, key, "the value with spaces"));
        Assert.assertEquals(Arrays.asList(nodeId), graphdbHelper.queryIndexedNodes(indexName, key, "the"));
        Assert.assertEquals(Arrays.asList(nodeId), graphdbHelper.queryIndexedNodes(indexName, key, "value"));
        Assert.assertEquals(Arrays.asList(nodeId), graphdbHelper.queryIndexedNodes(indexName, key, "with"));
        Assert.assertEquals(Arrays.asList(nodeId), graphdbHelper.queryIndexedNodes(indexName, key, "spaces"));
        Assert.assertEquals(Arrays.asList(nodeId), graphdbHelper.queryIndexedNodes(indexName, key, "*spaces*"));
        Assert.assertTrue((boolean)graphdbHelper.getIndexedNodes(indexName, key, "nohit").isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldGetExtendedNodeRepresentationsWhenGettingFromIndex() {
        List<Object> indexedNodes;
        String key = "mykey3";
        String value = "value";
        long nodeId = graphdbHelper.createNode(LABEL);
        String indexName = "node";
        graphdbHelper.addNodeToIndex(indexName, key, value, nodeId);
        int counter = 0;
        Transaction transaction = graph.beginTx();
        try {
            indexedNodes = RepresentationTestAccess.serialize(actions.getIndexedNodes(indexName, key, value));
        }
        finally {
            transaction.finish();
        }
        for (Object indexedNode : indexedNodes) {
            Map serialized = (Map)indexedNode;
            NodeRepresentationTest.verifySerialisation(serialized);
            Assert.assertNotNull(serialized.get("indexed"));
            ++counter;
        }
        Assert.assertEquals((long)1L, (long)counter);
    }

    @Test
    public void shouldBeAbleToRemoveNodeFromIndex() {
        String key = "mykey2";
        String value = "myvalue";
        String value2 = "myvalue2";
        String indexName = "node";
        long nodeId = graphdbHelper.createNode(new Label[0]);
        actions.addToNodeIndex(indexName, key, value, nodeId);
        actions.addToNodeIndex(indexName, key, value2, nodeId);
        Assert.assertEquals((long)1L, (long)graphdbHelper.getIndexedNodes(indexName, key, value).size());
        Assert.assertEquals((long)1L, (long)graphdbHelper.getIndexedNodes(indexName, key, value2).size());
        actions.removeFromNodeIndex(indexName, key, value, nodeId);
        Assert.assertEquals((long)0L, (long)graphdbHelper.getIndexedNodes(indexName, key, value).size());
        Assert.assertEquals((long)1L, (long)graphdbHelper.getIndexedNodes(indexName, key, value2).size());
        actions.removeFromNodeIndex(indexName, key, value2, nodeId);
        Assert.assertEquals((long)0L, (long)graphdbHelper.getIndexedNodes(indexName, key, value).size());
        Assert.assertEquals((long)0L, (long)graphdbHelper.getIndexedNodes(indexName, key, value2).size());
    }

    @Test
    public void shouldBeAbleToRemoveNodeFromIndexWithoutKeyValue() {
        String key1 = "kvkey1";
        String key2 = "kvkey2";
        String value = "myvalue";
        String value2 = "myvalue2";
        String indexName = "node";
        long nodeId = graphdbHelper.createNode(new Label[0]);
        actions.addToNodeIndex(indexName, key1, value, nodeId);
        actions.addToNodeIndex(indexName, key1, value2, nodeId);
        actions.addToNodeIndex(indexName, key2, value, nodeId);
        actions.addToNodeIndex(indexName, key2, value2, nodeId);
        Assert.assertEquals((long)1L, (long)graphdbHelper.getIndexedNodes(indexName, key1, value).size());
        Assert.assertEquals((long)1L, (long)graphdbHelper.getIndexedNodes(indexName, key1, value2).size());
        Assert.assertEquals((long)1L, (long)graphdbHelper.getIndexedNodes(indexName, key2, value).size());
        Assert.assertEquals((long)1L, (long)graphdbHelper.getIndexedNodes(indexName, key2, value2).size());
        actions.removeFromNodeIndexNoValue(indexName, key1, nodeId);
        Assert.assertEquals((long)0L, (long)graphdbHelper.getIndexedNodes(indexName, key1, value).size());
        Assert.assertEquals((long)0L, (long)graphdbHelper.getIndexedNodes(indexName, key1, value2).size());
        Assert.assertEquals((long)1L, (long)graphdbHelper.getIndexedNodes(indexName, key2, value).size());
        Assert.assertEquals((long)1L, (long)graphdbHelper.getIndexedNodes(indexName, key2, value2).size());
        actions.removeFromNodeIndexNoKeyValue(indexName, nodeId);
        Assert.assertEquals((long)0L, (long)graphdbHelper.getIndexedNodes(indexName, key1, value).size());
        Assert.assertEquals((long)0L, (long)graphdbHelper.getIndexedNodes(indexName, key1, value2).size());
        Assert.assertEquals((long)0L, (long)graphdbHelper.getIndexedNodes(indexName, key2, value).size());
        Assert.assertEquals((long)0L, (long)graphdbHelper.getIndexedNodes(indexName, key2, value2).size());
    }

    private long createBasicTraversableGraph() {
        long startNode = graphdbHelper.createNode(MapUtil.map((Object[])new Object[]{"name", "Root"}), LABEL);
        long child1_l1 = graphdbHelper.createNode(MapUtil.map((Object[])new Object[]{"name", "Mattias"}), LABEL);
        graphdbHelper.createRelationship("knows", startNode, child1_l1);
        long child2_l1 = graphdbHelper.createNode(MapUtil.map((Object[])new Object[]{"name", "Johan"}), LABEL);
        graphdbHelper.createRelationship("knows", startNode, child2_l1);
        long child1_l2 = graphdbHelper.createNode(MapUtil.map((Object[])new Object[]{"name", "Emil"}), LABEL);
        graphdbHelper.createRelationship("knows", child2_l1, child1_l2);
        long child1_l3 = graphdbHelper.createNode(MapUtil.map((Object[])new Object[]{"name", "Peter"}), LABEL);
        graphdbHelper.createRelationship("knows", child1_l2, child1_l3);
        long child2_l3 = graphdbHelper.createNode(MapUtil.map((Object[])new Object[]{"name", "Tobias"}), LABEL);
        graphdbHelper.createRelationship("loves", child1_l2, child2_l3);
        return startNode;
    }

    private long[] createMoreComplexGraph() {
        long a = graphdbHelper.createNode(new Label[0]);
        long b = graphdbHelper.createNode(new Label[0]);
        long c = graphdbHelper.createNode(new Label[0]);
        long d = graphdbHelper.createNode(new Label[0]);
        long e = graphdbHelper.createNode(new Label[0]);
        long f = graphdbHelper.createNode(new Label[0]);
        long g = graphdbHelper.createNode(new Label[0]);
        graphdbHelper.createRelationship("to", a, c);
        graphdbHelper.createRelationship("to", a, d);
        graphdbHelper.createRelationship("to", c, b);
        graphdbHelper.createRelationship("to", d, e);
        graphdbHelper.createRelationship("to", b, f);
        graphdbHelper.createRelationship("to", c, f);
        graphdbHelper.createRelationship("to", f, g);
        graphdbHelper.createRelationship("to", d, g);
        graphdbHelper.createRelationship("to", e, g);
        graphdbHelper.createRelationship("to", c, g);
        return new long[]{a, g};
    }

    private void createRelationshipWithProperties(long start, long end, Map<String, Object> properties) {
        long rel = graphdbHelper.createRelationship("to", start, end);
        graphdbHelper.setRelationshipProperties(rel, properties);
    }

    private long[] createDijkstraGraph(boolean includeOnes) {
        Map costOneProperties = includeOnes ? MapUtil.map((Object[])new Object[]{"cost", 1.0}) : MapUtil.map((Object[])new Object[0]);
        long start = graphdbHelper.createNode(new Label[0]);
        long a = graphdbHelper.createNode(new Label[0]);
        long b = graphdbHelper.createNode(new Label[0]);
        long c = graphdbHelper.createNode(new Label[0]);
        long d = graphdbHelper.createNode(new Label[0]);
        long e = graphdbHelper.createNode(new Label[0]);
        long f = graphdbHelper.createNode(new Label[0]);
        long x = graphdbHelper.createNode(new Label[0]);
        long y = graphdbHelper.createNode(new Label[0]);
        this.createRelationshipWithProperties(start, a, costOneProperties);
        this.createRelationshipWithProperties(a, x, MapUtil.map((Object[])new Object[]{"cost", 9.0}));
        this.createRelationshipWithProperties(a, b, costOneProperties);
        this.createRelationshipWithProperties(b, x, MapUtil.map((Object[])new Object[]{"cost", 7.0}));
        this.createRelationshipWithProperties(b, c, costOneProperties);
        this.createRelationshipWithProperties(c, x, MapUtil.map((Object[])new Object[]{"cost", 5.0}));
        this.createRelationshipWithProperties(c, x, MapUtil.map((Object[])new Object[]{"cost", 4.0}));
        this.createRelationshipWithProperties(c, d, costOneProperties);
        this.createRelationshipWithProperties(d, x, MapUtil.map((Object[])new Object[]{"cost", 3.0}));
        this.createRelationshipWithProperties(d, e, costOneProperties);
        this.createRelationshipWithProperties(e, x, costOneProperties);
        this.createRelationshipWithProperties(e, f, MapUtil.map((Object[])new Object[]{"cost", 2.0}));
        this.createRelationshipWithProperties(x, y, MapUtil.map((Object[])new Object[]{"cost", 2.0}));
        return new long[]{start, x};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToTraverseWithDefaultParameters() {
        long startNode = this.createBasicTraversableGraph();
        Transaction transaction = graph.beginTx();
        try {
            Assert.assertEquals((long)2L, (long)RepresentationTestAccess.serialize(actions.traverse(startNode, new HashMap(), TraverserReturnType.node)).size());
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToTraverseDepthTwo() {
        long startNode = this.createBasicTraversableGraph();
        Transaction transaction = graph.beginTx();
        try {
            Assert.assertEquals((long)3L, (long)RepresentationTestAccess.serialize(actions.traverse(startNode, MapUtil.map((Object[])new Object[]{"max_depth", 2}), TraverserReturnType.node)).size());
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToTraverseEverything() {
        long startNode = this.createBasicTraversableGraph();
        Transaction transaction = graph.beginTx();
        try {
            Assert.assertEquals((long)6L, (long)RepresentationTestAccess.serialize(actions.traverse(startNode, MapUtil.map((Object[])new Object[]{"return_filter", MapUtil.map((Object[])new Object[]{"language", "javascript", "body", "true;"}), "max_depth", 10}), TraverserReturnType.node)).size());
            Assert.assertEquals((long)6L, (long)RepresentationTestAccess.serialize(actions.traverse(startNode, MapUtil.map((Object[])new Object[]{"return_filter", MapUtil.map((Object[])new Object[]{"language", "builtin", "name", "all"}), "max_depth", 10}), TraverserReturnType.node)).size());
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToUseCustomReturnFilter() {
        long startNode = this.createBasicTraversableGraph();
        Transaction transaction = graph.beginTx();
        try {
            Assert.assertEquals((long)3L, (long)RepresentationTestAccess.serialize(actions.traverse(startNode, MapUtil.map((Object[])new Object[]{"prune_evaluator", MapUtil.map((Object[])new Object[]{"language", "builtin", "name", "none"}), "return_filter", MapUtil.map((Object[])new Object[]{"language", "javascript", "body", "position.endNode().getProperty( 'name' ).contains( 'o' )"})}), TraverserReturnType.node)).size());
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToTraverseWithMaxDepthAndPruneEvaluatorCombined() {
        long startNode = this.createBasicTraversableGraph();
        Transaction transaction = graph.beginTx();
        try {
            Assert.assertEquals((long)3L, (long)RepresentationTestAccess.serialize(actions.traverse(startNode, MapUtil.map((Object[])new Object[]{"max_depth", 2, "prune_evaluator", MapUtil.map((Object[])new Object[]{"language", "javascript", "body", "position.endNode().getProperty('name').equals('Emil')"})}), TraverserReturnType.node)).size());
            Assert.assertEquals((long)2L, (long)RepresentationTestAccess.serialize(actions.traverse(startNode, MapUtil.map((Object[])new Object[]{"max_depth", 1, "prune_evaluator", MapUtil.map((Object[])new Object[]{"language", "javascript", "body", "position.endNode().getProperty('name').equals('Emil')"})}), TraverserReturnType.node)).size());
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToGetRelationshipsIfSpecified() {
        List<Object> hits;
        long startNode = this.createBasicTraversableGraph();
        Transaction transaction = graph.beginTx();
        try {
            hits = RepresentationTestAccess.serialize(actions.traverse(startNode, new HashMap(), TraverserReturnType.relationship));
        }
        finally {
            transaction.finish();
        }
        for (Object hit : hits) {
            Map map = (Map)hit;
            RelationshipRepresentationTest.verifySerialisation(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToGetPathsIfSpecified() {
        List<Object> hits;
        long startNode = this.createBasicTraversableGraph();
        Transaction transaction = graph.beginTx();
        try {
            hits = RepresentationTestAccess.serialize(actions.traverse(startNode, new HashMap(), TraverserReturnType.path));
        }
        finally {
            transaction.finish();
        }
        for (Object hit : hits) {
            Map map = (Map)hit;
            MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasKey((Object)"start"));
            MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasKey((Object)"end"));
            MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasKey((Object)"length"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToGetFullPathsIfSpecified() {
        List<Object> hits;
        long startNode = this.createBasicTraversableGraph();
        Transaction transaction = graph.beginTx();
        try {
            hits = RepresentationTestAccess.serialize(actions.traverse(startNode, new HashMap(), TraverserReturnType.fullpath));
        }
        finally {
            transaction.finish();
        }
        for (Object hit : hits) {
            Map map = (Map)hit;
            Collection relationships = (Collection)map.get("relationships");
            for (Object rel : relationships) {
                Map relationship = (Map)rel;
                RelationshipRepresentationTest.verifySerialisation(relationship);
            }
            Collection nodes = (Collection)map.get("nodes");
            for (Object n : nodes) {
                Map node = (Map)n;
                NodeRepresentationTest.verifySerialisation(node);
            }
            MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasKey((Object)"start"));
            MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasKey((Object)"end"));
            MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasKey((Object)"length"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToGetShortestPaths() throws Exception {
        long[] nodes = this.createMoreComplexGraph();
        Transaction transaction = graph.beginTx();
        try {
            List<Object> result = RepresentationTestAccess.serialize(actions.findPaths(nodes[0], nodes[1], MapUtil.map((Object[])new Object[]{"max_depth", 2, "algorithm", "shortestPath", "relationships", MapUtil.map((Object[])new Object[]{"type", "to", "direction", "out"})})));
            this.assertPaths(2, nodes, 2, result);
            Map<String, Object> path = RepresentationTestAccess.serialize((MappingRepresentation)actions.findSinglePath(nodes[0], nodes[1], MapUtil.map((Object[])new Object[]{"max_depth", 2, "algorithm", "shortestPath", "relationships", MapUtil.map((Object[])new Object[]{"type", "to", "direction", "out"})})));
            this.assertPaths(1, nodes, 2, Arrays.asList(path));
            path = RepresentationTestAccess.serialize((MappingRepresentation)actions.findSinglePath(nodes[0], nodes[1], MapUtil.map((Object[])new Object[]{"max_depth", 2, "algorithm", "shortestPath", "relationships", MapUtil.map((Object[])new Object[]{"type", "to", "direction", "out"}), "single", false})));
            this.assertPaths(1, nodes, 2, Arrays.asList(path));
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToGetPathsUsingDijkstra() throws Exception {
        long[] nodes = this.createDijkstraGraph(true);
        Transaction transaction = graph.beginTx();
        try {
            this.assertPaths(1, nodes, 6, RepresentationTestAccess.serialize(actions.findPaths(nodes[0], nodes[1], MapUtil.map((Object[])new Object[]{"algorithm", "dijkstra", "cost_property", "cost", "relationships", MapUtil.map((Object[])new Object[]{"type", "to", "direction", "out"})}))));
            Map<String, Object> path = RepresentationTestAccess.serialize((MappingRepresentation)actions.findSinglePath(nodes[0], nodes[1], MapUtil.map((Object[])new Object[]{"algorithm", "dijkstra", "cost_property", "cost", "relationships", MapUtil.map((Object[])new Object[]{"type", "to", "direction", "out"})})));
            this.assertPaths(1, nodes, 6, Arrays.asList(path));
            Assert.assertEquals((Object)6.0, (Object)path.get("weight"));
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToGetPathsUsingDijkstraWithDefaults() throws Exception {
        long[] nodes = this.createDijkstraGraph(false);
        Transaction transaction = graph.beginTx();
        try {
            List<Object> result = RepresentationTestAccess.serialize(actions.findPaths(nodes[0], nodes[1], MapUtil.map((Object[])new Object[]{"algorithm", "dijkstra", "cost_property", "cost", "default_cost", 1, "relationships", MapUtil.map((Object[])new Object[]{"type", "to", "direction", "out"})})));
            this.assertPaths(1, nodes, 6, result);
            Map<String, Object> path = RepresentationTestAccess.serialize((MappingRepresentation)actions.findSinglePath(nodes[0], nodes[1], MapUtil.map((Object[])new Object[]{"algorithm", "dijkstra", "cost_property", "cost", "default_cost", 1, "relationships", MapUtil.map((Object[])new Object[]{"type", "to", "direction", "out"})})));
            this.assertPaths(1, nodes, 6, Arrays.asList(path));
            Assert.assertEquals((Object)6.0, (Object)path.get("weight"));
        }
        finally {
            transaction.finish();
        }
    }

    @Test(expected=NotFoundException.class)
    public void shouldHandleNoFoundPathsCorrectly() {
        long[] nodes = this.createMoreComplexGraph();
        actions.findSinglePath(nodes[0], nodes[1], MapUtil.map((Object[])new Object[]{"max_depth", 2, "algorithm", "shortestPath", "relationships", MapUtil.map((Object[])new Object[]{"type", "to", "direction", "in"}), "single", false}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAddLabelToNode() throws Exception {
        long node = actions.createNode(null, new Label[0]).getId();
        ArrayList<String> labels = new ArrayList<String>();
        String labelName = "Wonk";
        labels.add(labelName);
        actions.addLabelToNode(node, labels);
        Transaction transaction = graph.beginTx();
        try {
            Iterable<String> result = graphdbHelper.getNodeLabels(node);
            Assert.assertEquals((Object)labelName, (Object)Iterables.single(result));
        }
        finally {
            transaction.finish();
        }
    }

    @Test
    public void shouldRemoveLabelFromNode() throws Exception {
        String labelName = "mylabel";
        long node = actions.createNode(null, new Label[]{DynamicLabel.label((String)labelName)}).getId();
        actions.removeLabelFromNode(node, labelName);
        Assert.assertEquals((long)0L, (long)graphdbHelper.getLabelCount(node));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldListExistingLabelsOnNode() throws Exception {
        List<Object> labels;
        long node = graphdbHelper.createNode(new Label[0]);
        String labelName1 = "LabelOne";
        String labelName2 = "labelTwo";
        graphdbHelper.addLabelToNode(node, labelName1);
        graphdbHelper.addLabelToNode(node, labelName2);
        Transaction transaction = graph.beginTx();
        try {
            labels = RepresentationTestAccess.serialize(actions.getNodeLabels(node));
        }
        finally {
            transaction.finish();
        }
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[]{labelName1, labelName2}), (Object)IteratorUtil.asSet(labels));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getNodesWithLabel() throws Exception {
        List<Object> representation;
        String label1 = "first";
        String label2 = "second";
        long node1 = graphdbHelper.createNode(DynamicLabel.label((String)label1));
        long node2 = graphdbHelper.createNode(DynamicLabel.label((String)label1), DynamicLabel.label((String)label2));
        graphdbHelper.createNode(DynamicLabel.label((String)label2));
        Transaction transaction = graph.beginTx();
        try {
            representation = RepresentationTestAccess.serialize(actions.getNodesWithLabel(label1, MapUtil.map((Object[])new Object[0])));
        }
        finally {
            transaction.finish();
        }
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{node1, node2}), (Object)IteratorUtil.asSet((Iterable)Iterables.map((Function)new Function<Object, Long>(){

            public Long apply(Object from) {
                Map nodeMap = (Map)from;
                return RepresentationTestAccess.nodeUriToId((String)nodeMap.get("self"));
            }
        }, representation)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNodesWithLabelAndSeveralPropertiesShouldFail() throws Exception {
        actions.getNodesWithLabel("Person", MapUtil.map((Object[])new Object[]{"name", "bob", "age", 12}));
    }

    private void assertPaths(int numPaths, long[] nodes, int length, List<Object> result) {
        Assert.assertEquals((long)numPaths, (long)result.size());
        for (Object path : result) {
            Map serialized = (Map)path;
            Assert.assertTrue((boolean)serialized.get("start").toString().endsWith("/" + nodes[0]));
            Assert.assertTrue((boolean)serialized.get("end").toString().endsWith("/" + nodes[1]));
            Assert.assertEquals((Object)length, serialized.get("length"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldCreateSchemaIndex() throws Exception {
        String labelName = "person";
        String propertyKey = "name";
        actions.createSchemaIndex(labelName, Arrays.asList(propertyKey));
        Transaction transaction = graph.beginTx();
        try {
            Iterable<IndexDefinition> defs = graphdbHelper.getSchemaIndexes(labelName);
            Assert.assertEquals((long)1L, (long)IteratorUtil.count(defs));
            Assert.assertEquals((Object)propertyKey, (Object)Iterables.first((Iterable)((IndexDefinition)Iterables.first(defs)).getPropertyKeys()));
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldDropSchemaIndex() throws Exception {
        String labelName = "user";
        String propertyKey = "login";
        IndexDefinition index = graphdbHelper.createSchemaIndex(labelName, propertyKey);
        actions.dropSchemaIndex(labelName, propertyKey);
        Transaction transaction = graph.beginTx();
        try {
            Assert.assertFalse((String)"Index should have been dropped", (boolean)IteratorUtil.asSet(graphdbHelper.getSchemaIndexes(labelName)).contains(index));
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldGetSchemaIndexes() throws Exception {
        List<Object> serialized;
        String labelName = "mylabel";
        String propertyKey = "name";
        graphdbHelper.createSchemaIndex(labelName, propertyKey);
        Transaction transaction = graph.beginTx();
        try {
            serialized = RepresentationTestAccess.serialize(actions.getSchemaIndexes(labelName));
        }
        finally {
            transaction.finish();
        }
        Assert.assertEquals((long)1L, (long)serialized.size());
        Map definition = (Map)serialized.get(0);
        Assert.assertEquals((Object)labelName, definition.get("label"));
        Assert.assertEquals(Arrays.asList(propertyKey), definition.get("property_keys"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldCreatePropertyUniquenessConstraint() throws Exception {
        String labelName = "person";
        String propertyKey = "name";
        actions.createPropertyUniquenessConstraint(labelName, Arrays.asList(propertyKey));
        Transaction tx = graph.beginTx();
        try {
            Iterable<ConstraintDefinition> defs = graphdbHelper.getPropertyUniquenessConstraints(labelName, propertyKey);
            Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[]{propertyKey}), (Object)IteratorUtil.asSet((Iterable)((ConstraintDefinition)Iterables.single(defs)).getPropertyKeys()));
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    @Test
    public void shouldDropPropertyUniquenessConstraint() throws Exception {
        String labelName = "user";
        String propertyKey = "login";
        ConstraintDefinition index = graphdbHelper.createPropertyUniquenessConstraint(labelName, Arrays.asList(propertyKey));
        actions.dropPropertyUniquenessConstraint(labelName, Arrays.asList(propertyKey));
        Assert.assertFalse((String)"Constraint should have been dropped", (boolean)IteratorUtil.asSet(graphdbHelper.getPropertyUniquenessConstraints(labelName, propertyKey)).contains(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldGetPropertyUniquenessConstraint() throws Exception {
        List<Object> serialized;
        String labelName = "mylabel";
        String propertyKey = "name";
        graphdbHelper.createPropertyUniquenessConstraint(labelName, Arrays.asList(propertyKey));
        Transaction transaction = graph.beginTx();
        try {
            serialized = RepresentationTestAccess.serialize(actions.getPropertyUniquenessConstraint(labelName, Arrays.asList(propertyKey)));
        }
        finally {
            transaction.finish();
        }
        Assert.assertEquals((long)1L, (long)serialized.size());
        Map definition = (Map)serialized.get(0);
        Assert.assertEquals((Object)labelName, definition.get("label"));
        Assert.assertEquals(Arrays.asList(propertyKey), definition.get("property_keys"));
        Assert.assertEquals((Object)"UNIQUENESS", definition.get("type"));
    }

    @Test
    public void shouldIndexNodeOnlyOnce() throws Exception {
        Pair result;
        long nodeId = graphdbHelper.createNode(new Label[0]);
        graphdbHelper.createRelationshipIndex("myIndex");
        try (Transaction tx = graph.beginTx();){
            result = actions.getOrCreateIndexedNode("myIndex", "foo", "bar", Long.valueOf(nodeId), null);
            MatcherAssert.assertThat((Object)result.other(), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)RepresentationTestAccess.serialize(actions.getIndexedNodes("myIndex", "foo", "bar")).size(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)actions.nodeIsIndexed("myIndex", "foo", (Object)"bar", nodeId), (Matcher)Matchers.is((Object)true));
            tx.success();
        }
        tx = graph.beginTx();
        var4_3 = null;
        try {
            result = actions.getOrCreateIndexedNode("myIndex", "foo", "bar", Long.valueOf(nodeId), null);
            MatcherAssert.assertThat((Object)result.other(), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)RepresentationTestAccess.serialize(actions.getIndexedNodes("myIndex", "foo", "bar")).size(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)actions.nodeIsIndexed("myIndex", "foo", (Object)"bar", nodeId), (Matcher)Matchers.is((Object)true));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldIndexRelationshipOnlyOnce() throws Exception {
        Pair result;
        long relationshipId = graphdbHelper.createRelationship("FOO");
        graphdbHelper.createRelationshipIndex("myIndex");
        try (Transaction tx = graph.beginTx();){
            result = actions.getOrCreateIndexedRelationship("myIndex", "foo", "bar", Long.valueOf(relationshipId), null, null, null, null);
            MatcherAssert.assertThat((Object)result.other(), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)RepresentationTestAccess.serialize(actions.getIndexedRelationships("myIndex", "foo", "bar")).size(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)actions.relationshipIsIndexed("myIndex", "foo", (Object)"bar", relationshipId), (Matcher)Matchers.is((Object)true));
            tx.success();
        }
        tx = graph.beginTx();
        var4_3 = null;
        try {
            result = actions.getOrCreateIndexedRelationship("myIndex", "foo", "bar", Long.valueOf(relationshipId), null, null, null, null);
            MatcherAssert.assertThat((Object)result.other(), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)RepresentationTestAccess.serialize(actions.getIndexedRelationships("myIndex", "foo", "bar")).size(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)actions.relationshipIsIndexed("myIndex", "foo", (Object)"bar", relationshipId), (Matcher)Matchers.is((Object)true));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldNotIndexNodeWhenAnotherNodeAlreadyIndexed() throws Exception {
        Pair result;
        long nodeId;
        graphdbHelper.createRelationshipIndex("myIndex");
        try (Transaction tx = graph.beginTx();){
            nodeId = graphdbHelper.createNode(new Label[0]);
            result = actions.getOrCreateIndexedNode("myIndex", "foo", "bar", Long.valueOf(nodeId), null);
            MatcherAssert.assertThat((Object)result.other(), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)RepresentationTestAccess.serialize(actions.getIndexedNodes("myIndex", "foo", "bar")).size(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)actions.nodeIsIndexed("myIndex", "foo", (Object)"bar", nodeId), (Matcher)Matchers.is((Object)true));
            tx.success();
        }
        tx = graph.beginTx();
        var2_2 = null;
        try {
            nodeId = graphdbHelper.createNode(new Label[0]);
            result = actions.getOrCreateIndexedNode("myIndex", "foo", "bar", Long.valueOf(nodeId), null);
            MatcherAssert.assertThat((Object)result.other(), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)RepresentationTestAccess.serialize(actions.getIndexedNodes("myIndex", "foo", "bar")).size(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)actions.nodeIsIndexed("myIndex", "foo", (Object)"bar", nodeId), (Matcher)Matchers.is((Object)false));
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var2_2.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldNotIndexRelationshipWhenAnotherRelationshipAlreadyIndexed() throws Exception {
        Pair result;
        long relationshipId;
        graphdbHelper.createRelationshipIndex("myIndex");
        try (Transaction tx = graph.beginTx();){
            relationshipId = graphdbHelper.createRelationship("FOO");
            result = actions.getOrCreateIndexedRelationship("myIndex", "foo", "bar", Long.valueOf(relationshipId), null, null, null, null);
            MatcherAssert.assertThat((Object)result.other(), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)RepresentationTestAccess.serialize(actions.getIndexedRelationships("myIndex", "foo", "bar")).size(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)actions.relationshipIsIndexed("myIndex", "foo", (Object)"bar", relationshipId), (Matcher)Matchers.is((Object)true));
            tx.success();
        }
        tx = graph.beginTx();
        var2_2 = null;
        try {
            relationshipId = graphdbHelper.createRelationship("FOO");
            result = actions.getOrCreateIndexedRelationship("myIndex", "foo", "bar", Long.valueOf(relationshipId), null, null, null, null);
            MatcherAssert.assertThat((Object)result.other(), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)RepresentationTestAccess.serialize(actions.getIndexedRelationships("myIndex", "foo", "bar")).size(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)actions.relationshipIsIndexed("myIndex", "foo", (Object)"bar", relationshipId), (Matcher)Matchers.is((Object)false));
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var2_2.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }
}

