/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.preflight;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.configuration.Configuration;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Settings;
import org.neo4j.server.configuration.MapBasedConfiguration;
import org.neo4j.server.preflight.EnsurePreparedForHttpLogging;
import org.neo4j.test.TargetDirectory;

public class HTTPLoggingPreparednessRuleTest {
    @Test
    public void shouldPassWhenExplicitlyDisabled() {
        MapBasedConfiguration config = new MapBasedConfiguration();
        config.setProperty("org.neo4j.server.http.log.enabled", (Object)"false");
        EnsurePreparedForHttpLogging rule = new EnsurePreparedForHttpLogging((Configuration)config);
        boolean result = rule.run();
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((Object)"", (Object)rule.getFailureMessage());
    }

    @Test
    public void shouldPassWhenImplicitlyDisabled() {
        MapBasedConfiguration config = new MapBasedConfiguration();
        EnsurePreparedForHttpLogging rule = new EnsurePreparedForHttpLogging((Configuration)config);
        boolean result = rule.run();
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((Object)"", (Object)rule.getFailureMessage());
    }

    @Test
    public void shouldPassWhenEnabledWithGoodConfigSpecified() throws Exception {
        File logDir = TargetDirectory.forTest(this.getClass()).cleanDirectory("logDir");
        File confDir = TargetDirectory.forTest(this.getClass()).cleanDirectory("confDir");
        MapBasedConfiguration config = new MapBasedConfiguration();
        config.setProperty("org.neo4j.server.http.log.enabled", (Object)"true");
        config.setProperty("org.neo4j.server.http.log.config", (Object)HTTPLoggingPreparednessRuleTest.createConfigFile(HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(logDir), confDir).getAbsolutePath());
        EnsurePreparedForHttpLogging rule = new EnsurePreparedForHttpLogging((Configuration)config);
        boolean result = rule.run();
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((Object)"", (Object)rule.getFailureMessage());
    }

    @Test
    public void shouldFailWhenEnabledWithUnwritableLogDirSpecifiedInConfig() throws Exception {
        File confDir = TargetDirectory.forTest(this.getClass()).cleanDirectory("confDir");
        MapBasedConfiguration config = new MapBasedConfiguration();
        config.setProperty("org.neo4j.server.http.log.enabled", (Object)"true");
        File unwritableDirectory = HTTPLoggingPreparednessRuleTest.createUnwritableDirectory();
        config.setProperty("org.neo4j.server.http.log.config", (Object)HTTPLoggingPreparednessRuleTest.createConfigFile(HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(unwritableDirectory), confDir).getAbsolutePath());
        EnsurePreparedForHttpLogging rule = new EnsurePreparedForHttpLogging((Configuration)config);
        boolean result = rule.run();
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((Object)String.format("HTTP log directory [%s] does not exist", unwritableDirectory), (Object)rule.getFailureMessage());
    }

    public static File createUnwritableDirectory() {
        File file = Settings.osIsWindows() ? new File("\\\\" + UUID.randomUUID().toString() + "\\") : (Settings.osIsMacOS() ? new File("/Network/Servers/localhost/" + UUID.randomUUID().toString()) : new File("/proc/" + UUID.randomUUID().toString() + "/random"));
        return file;
    }

    public static File createConfigFile(String configXml, File location) throws IOException {
        File configFile = new File(location.getAbsolutePath() + File.separator + "neo4j-logback-config.xml");
        FileOutputStream fos = new FileOutputStream(configFile);
        fos.write(configXml.getBytes());
        fos.close();
        return configFile;
    }

    public static String createLogbackConfigXml(File logDirectory) {
        return HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(logDirectory, "%h %l %user [%t{dd/MMM/yyyy:HH:mm:ss Z}] \"%r\" %s %b \"%i{Referer}\" \"%i{User-Agent}\"");
    }

    public static String createLogbackConfigXml(File logDirectory, String logPattern) {
        return "<configuration>\n  <appender name=\"FILE\" class=\"ch.qos.logback.core.rolling.RollingFileAppender\">\n    <file>" + logDirectory.getAbsolutePath() + File.separator + "http.log</file>\n" + "    <rollingPolicy class=\"ch.qos.logback.core.rolling.TimeBasedRollingPolicy\">\n" + "      <fileNamePattern>" + logDirectory.getAbsolutePath() + File.separator + "http.%d{yyyy-MM-dd_HH}.log</fileNamePattern>\n" + "      <maxHistory>30</maxHistory>\n" + "    </rollingPolicy>\n" + "\n" + "    <encoder>\n" + "      <!-- Note the deliberate misspelling of \"referer\" in accordance with RFC 2616 -->\n" + "      <pattern>" + logPattern + "</pattern>\n" + "    </encoder>\n" + "  </appender>\n" + "\n" + "  <appender-ref ref=\"FILE\" />\n" + "</configuration>";
    }
}

