/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.server.security.auth.User;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.auth.exception.IllegalTokenException;

public class InMemoryUserRepository
implements UserRepository {
    private final ConcurrentHashMap<String, User> users = new ConcurrentHashMap();

    public User get(String name) {
        return this.users.get(name);
    }

    public synchronized void save(User user) throws IllegalTokenException {
        if (user.hasToken()) {
            for (User other : this.users.values()) {
                if (!other.tokenEquals(user.token()) || other.name().equals(user.name())) continue;
                throw new IllegalTokenException("Unable to set token, because the chosen token is already in use.");
            }
        }
        this.users.put(user.name(), user);
    }

    public Iterator<User> iterator() {
        return this.users.values().iterator();
    }

    public int numberOfUsers() {
        return this.users.size();
    }

    public boolean isValidName(String name) {
        return true;
    }

    public boolean isValidToken(String token) {
        return true;
    }
}

