/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webdriver;

import java.lang.reflect.InvocationTargetException;
import org.hamcrest.Matcher;
import org.neo4j.server.webdriver.Condition;
import org.neo4j.server.webdriver.ConditionFailedException;
import org.neo4j.server.webdriver.ElementReference;
import org.neo4j.server.webdriver.WebDriverFacade;
import org.neo4j.server.webdriver.WebdriverLibrary;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;

public class WebadminWebdriverLibrary
extends WebdriverLibrary {
    private static final String USE_DEV_HTML_FILE_KEY = "testWithDevHtmlFile";
    private static final String AVOID_REDIRECT_AND_GO_STRAIGHT_TO_WEB_ADMIN_HOMEPAGE = "avoidRedirectAndGoStraightToWebAdminHomepage";
    private String serverUrl;
    private final ElementReference dataBrowserSearchField;
    private final ElementReference dataBrowserItemSubtitle;
    private final ElementReference dataBrowserSearchButton;
    private final ElementReference dataBrowserTitle;

    public WebadminWebdriverLibrary(WebDriverFacade wf, String serverUrl) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        super(wf);
        this.setServerUrl(serverUrl);
        this.dataBrowserTitle = new ElementReference(this, By.xpath((String)"//div[@id='data-area']//h3"));
        this.dataBrowserItemSubtitle = new ElementReference(this, By.xpath((String)"//div[@id='data-area']//div[@class='title']//p[@class='small']"));
        this.dataBrowserSearchField = new ElementReference(this, By.xpath((String)"//div[@id='data-console']//textarea"));
        this.dataBrowserSearchButton = new ElementReference(this, By.id((String)"data-execute-console"));
    }

    public void setServerUrl(String url) {
        this.serverUrl = url;
    }

    public void goToServerRoot() {
        this.d.get(this.serverUrl);
    }

    public void goToWebadminStartPage() {
        if (this.isUsingDevDotHTML()) {
            this.d.get(this.serverUrl + "webadmin/dev.html");
        } else if (this.avoidRedirectAndGoStraightToWebAdminHomepage()) {
            this.d.get(this.serverUrl + "webadmin/");
        } else {
            this.goToServerRoot();
        }
        this.waitForTitleToBe("Neo4j Monitoring and Management Tool");
    }

    public void clickOnTab(String tabName) {
        ElementReference tab = this.getElement(By.xpath((String)("//*[@id='mainmenu']//a[contains(.,'" + tabName + "')]")));
        new Condition<ElementReference>((Matcher<ElementReference>)new WebdriverLibrary.ElementClickable(), tab).waitUntilFulfilled();
    }

    public void searchForInDataBrowser(String query) {
        this.dataBrowserSearchField.waitUntilVisible();
        this.executeScript("document.dataBrowserEditor.setValue(\"" + query + "\")", new Object[0]);
        this.dataBrowserSearchButton.click();
    }

    public long createNodeInDataBrowser() {
        this.goToWebadminStartPage();
        this.clickOnTab("Data browser");
        this.clickOnButton("Node");
        return this.extractEntityIdFromLastSegmentOfUrl(this.getCurrentDatabrowserItemSubtitle());
    }

    public long createRelationshipInDataBrowser() {
        this.createNodeInDataBrowser();
        String prevItemHeadline = this.getCurrentDatabrowserItemSubtitle();
        this.clickOnButton("Relationship");
        this.getElement(By.id((String)"create-relationship-to")).sendKeys("0");
        this.clickOnButton("Create");
        this.dataBrowserItemSubtitle.waitForTextToChangeFrom(prevItemHeadline);
        return this.extractEntityIdFromLastSegmentOfUrl(this.getCurrentDatabrowserItemSubtitle());
    }

    public String getCurrentDatabrowserItemSubtitle() {
        return this.getDataBrowserItemSubtitle().getText();
    }

    public ElementReference getDataBrowserItemSubtitle() {
        return this.dataBrowserItemSubtitle;
    }

    public ElementReference getDataBrowserItemTitle() {
        return this.dataBrowserTitle;
    }

    public void waitForSingleElementToAppear(By xpath) {
        this.waitForElementToAppear(xpath);
        int numElems = this.d.findElements(xpath).size();
        if (numElems != 1) {
            throw new ConditionFailedException("Expected single element, got " + numElems + " :(.", null);
        }
    }

    private boolean isUsingDevDotHTML() {
        return System.getProperty(USE_DEV_HTML_FILE_KEY, "false").equals("true");
    }

    private boolean avoidRedirectAndGoStraightToWebAdminHomepage() {
        return System.getProperty(AVOID_REDIRECT_AND_GO_STRAIGHT_TO_WEB_ADMIN_HOMEPAGE, "false").equals("true");
    }

    public void confirmAll() {
        this.executeScript("window.confirm=function(){return true;}", "");
    }

    public Object executeScript(String script, Object ... args) {
        if (this.d instanceof JavascriptExecutor) {
            JavascriptExecutor javascriptExecutor = (JavascriptExecutor)this.d;
            return javascriptExecutor.executeScript(script, args);
        }
        throw new RuntimeException("Arbitrary script execution is only available for WebDrivers that implement the JavascriptExecutor interface.");
    }

    public void writeTo(By by, CharSequence ... toWrite) {
        ElementReference el = this.getElement(by);
        el.click();
        el.clear();
        el.sendKeys(toWrite);
    }

    private long extractEntityIdFromLastSegmentOfUrl(String url) {
        return Long.valueOf(url.substring(url.lastIndexOf("/") + 1, url.length()));
    }
}

