/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.DatabaseTuningPropertyFileBuilder;
import org.neo4j.server.configuration.PropertyFileBuilder;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.server.configuration.ServerSettings;

public class ConfiguratorTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void shouldProvideAConfiguration() throws IOException {
        File configFile = PropertyFileBuilder.builder(this.folder.getRoot()).build();
        Config config = new PropertyFileConfigurator(configFile).configuration();
        Assert.assertNotNull((Object)config);
    }

    @Test
    public void shouldUseSpecifiedConfigFile() throws Exception {
        File configFile = PropertyFileBuilder.builder(this.folder.getRoot()).withNameValue("foo", "bar").build();
        Config testConf = new PropertyFileConfigurator(configFile).configuration();
        String EXPECTED_VALUE = "bar";
        Assert.assertEquals((Object)"bar", testConf.getParams().get("foo"));
    }

    @Test
    public void shouldAcceptDuplicateKeysWithSameValue() throws IOException {
        File configFile = PropertyFileBuilder.builder(this.folder.getRoot()).withNameValue("foo", "bar").withNameValue("foo", "bar").build();
        PropertyFileConfigurator configurator = new PropertyFileConfigurator(configFile);
        Config testConf = configurator.configuration();
        Assert.assertNotNull((Object)testConf);
        String EXPECTED_VALUE = "bar";
        Assert.assertEquals((Object)"bar", testConf.getParams().get("foo"));
    }

    @Test
    public void shouldSupportProvidingDatabaseTuningParametersSeparately() throws IOException {
        File databaseTuningPropertyFile = DatabaseTuningPropertyFileBuilder.builder(this.folder.getRoot()).build();
        File propertyFileWithDbTuningProperty = PropertyFileBuilder.builder(this.folder.getRoot()).withDbTuningPropertyFile(databaseTuningPropertyFile).build();
        PropertyFileConfigurator configurator = new PropertyFileConfigurator(propertyFileWithDbTuningProperty);
        Map databaseTuningProperties = configurator.getDatabaseTuningProperties();
        Assert.assertNotNull((Object)databaseTuningProperties);
        Assert.assertEquals((long)6L, (long)databaseTuningProperties.size());
    }

    @Test
    public void shouldFindThirdPartyJaxRsPackages() throws IOException {
        File file = ServerTestUtils.createTempPropertyFile(this.folder.getRoot());
        FileWriter fstream = new FileWriter(file, true);
        BufferedWriter out = new BufferedWriter(fstream);
        out.write(Configurator.THIRD_PARTY_PACKAGES_KEY);
        out.write("=");
        out.write("com.foo.bar=\"mount/point/foo\",");
        out.write("com.foo.baz=\"/bar\",");
        out.write("com.foo.foobarbaz=\"/\"");
        out.write(System.getProperty("line.separator"));
        out.close();
        PropertyFileConfigurator configurator = new PropertyFileConfigurator(file);
        List thirdpartyJaxRsPackages = (List)configurator.configuration().get(ServerSettings.third_party_packages);
        Assert.assertNotNull((Object)thirdpartyJaxRsPackages);
        Assert.assertEquals((long)3L, (long)thirdpartyJaxRsPackages.size());
    }
}

